/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.key;

import java.io.IOException;
import javax.annotation.Nonnull;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

public class OMKeyCommitResponse
extends OMClientResponse {
    private OmKeyInfo omKeyInfo;
    private long openKeySessionID;

    public OMKeyCommitResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, @Nonnull OmKeyInfo omKeyInfo, long openKeySessionID) {
        super(omResponse);
        this.omKeyInfo = omKeyInfo;
        this.openKeySessionID = openKeySessionID;
    }

    public OMKeyCommitResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse) {
        super(omResponse);
        this.checkStatusNotOK();
    }

    @Override
    public void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        String volumeName = this.omKeyInfo.getVolumeName();
        String bucketName = this.omKeyInfo.getBucketName();
        String keyName = this.omKeyInfo.getKeyName();
        String openKey = omMetadataManager.getOpenKey(volumeName, bucketName, keyName, this.openKeySessionID);
        String ozoneKey = omMetadataManager.getOzoneKey(volumeName, bucketName, keyName);
        omMetadataManager.getOpenKeyTable().deleteWithBatch(batchOperation, (Object)openKey);
        omMetadataManager.getKeyTable().putWithBatch(batchOperation, (Object)ozoneKey, (Object)this.omKeyInfo);
    }
}

