/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.key;

import java.io.IOException;
import javax.annotation.Nonnull;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

public class OMKeyCreateResponse
extends OMClientResponse {
    private OmKeyInfo omKeyInfo;
    private long openKeySessionID;

    public OMKeyCreateResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, @Nonnull OmKeyInfo omKeyInfo, long openKeySessionID) {
        super(omResponse);
        this.omKeyInfo = omKeyInfo;
        this.openKeySessionID = openKeySessionID;
    }

    public OMKeyCreateResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse) {
        super(omResponse);
        this.checkStatusNotOK();
    }

    @Override
    protected void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        String openKey = omMetadataManager.getOpenKey(this.omKeyInfo.getVolumeName(), this.omKeyInfo.getBucketName(), this.omKeyInfo.getKeyName(), this.openKeySessionID);
        omMetadataManager.getOpenKeyTable().putWithBatch(batchOperation, (Object)openKey, (Object)this.omKeyInfo);
    }
}

