/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.key;

import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfoGroup;
import org.apache.hadoop.ozone.om.helpers.RepeatedOmKeyInfo;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

public class OMKeyDeleteResponse
extends OMClientResponse {
    private OmKeyInfo omKeyInfo;
    private boolean isRatisEnabled;

    public OMKeyDeleteResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, @Nonnull OmKeyInfo omKeyInfo, boolean isRatisEnabled) {
        super(omResponse);
        this.omKeyInfo = omKeyInfo;
        this.isRatisEnabled = isRatisEnabled;
    }

    public OMKeyDeleteResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse) {
        super(omResponse);
        this.checkStatusNotOK();
    }

    @Override
    public void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        if (this.getOMResponse().getStatus() == OzoneManagerProtocolProtos.Status.OK) {
            String ozoneKey = omMetadataManager.getOzoneKey(this.omKeyInfo.getVolumeName(), this.omKeyInfo.getBucketName(), this.omKeyInfo.getKeyName());
            omMetadataManager.getKeyTable().deleteWithBatch(batchOperation, (Object)ozoneKey);
            if (!this.isKeyEmpty(this.omKeyInfo)) {
                RepeatedOmKeyInfo repeatedOmKeyInfo = (RepeatedOmKeyInfo)omMetadataManager.getDeletedTable().get((Object)ozoneKey);
                repeatedOmKeyInfo = OmUtils.prepareKeyForDelete((OmKeyInfo)this.omKeyInfo, (RepeatedOmKeyInfo)repeatedOmKeyInfo, (long)this.omKeyInfo.getUpdateID(), (boolean)this.isRatisEnabled);
                omMetadataManager.getDeletedTable().putWithBatch(batchOperation, (Object)ozoneKey, (Object)repeatedOmKeyInfo);
            }
        }
    }

    private boolean isKeyEmpty(@Nullable OmKeyInfo keyInfo) {
        if (keyInfo == null) {
            return true;
        }
        for (OmKeyLocationInfoGroup keyLocationList : keyInfo.getKeyLocationVersions()) {
            if (keyLocationList.getLocationList().size() == 0) continue;
            return false;
        }
        return true;
    }
}

