/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.s3.bucket;

import java.io.IOException;
import javax.annotation.Nonnull;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

public class S3BucketDeleteResponse
extends OMClientResponse {
    private String s3BucketName;
    private String volumeName;

    public S3BucketDeleteResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, @Nonnull String s3BucketName, @Nonnull String volumeName) {
        super(omResponse);
        this.s3BucketName = s3BucketName;
        this.volumeName = volumeName;
    }

    public S3BucketDeleteResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse) {
        super(omResponse);
        this.checkStatusNotOK();
    }

    @Override
    public void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        omMetadataManager.getBucketTable().deleteWithBatch(batchOperation, (Object)omMetadataManager.getBucketKey(this.volumeName, this.s3BucketName));
        omMetadataManager.getS3Table().deleteWithBatch(batchOperation, (Object)this.s3BucketName);
    }
}

