/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.s3.multipart;

import java.io.IOException;
import javax.annotation.Nonnull;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartKeyInfo;
import org.apache.hadoop.ozone.om.helpers.RepeatedOmKeyInfo;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

public class S3MultipartUploadCommitPartResponse
extends OMClientResponse {
    private String multipartKey;
    private String openKey;
    private OmKeyInfo deletePartKeyInfo;
    private OmMultipartKeyInfo omMultipartKeyInfo;
    private OzoneManagerProtocolProtos.PartKeyInfo oldMultipartKeyInfo;
    private boolean isRatisEnabled;

    public S3MultipartUploadCommitPartResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, String multipartKey, String openKey, @Nonnull OmKeyInfo deletePartKeyInfo, @Nonnull OmMultipartKeyInfo omMultipartKeyInfo, @Nonnull OzoneManagerProtocolProtos.PartKeyInfo oldPartKeyInfo, boolean isRatisEnabled) {
        super(omResponse);
        this.multipartKey = multipartKey;
        this.openKey = openKey;
        this.deletePartKeyInfo = deletePartKeyInfo;
        this.omMultipartKeyInfo = omMultipartKeyInfo;
        this.oldMultipartKeyInfo = oldPartKeyInfo;
        this.isRatisEnabled = isRatisEnabled;
    }

    public S3MultipartUploadCommitPartResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse) {
        super(omResponse);
        this.checkStatusNotOK();
    }

    @Override
    public void checkAndUpdateDB(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        if (this.getOMResponse().getStatus() == OzoneManagerProtocolProtos.Status.NO_SUCH_MULTIPART_UPLOAD_ERROR) {
            RepeatedOmKeyInfo repeatedOmKeyInfo = (RepeatedOmKeyInfo)omMetadataManager.getDeletedTable().get((Object)this.openKey);
            repeatedOmKeyInfo = OmUtils.prepareKeyForDelete((OmKeyInfo)this.deletePartKeyInfo, (RepeatedOmKeyInfo)repeatedOmKeyInfo, (long)this.deletePartKeyInfo.getUpdateID(), (boolean)this.isRatisEnabled);
            omMetadataManager.getDeletedTable().putWithBatch(batchOperation, (Object)this.openKey, (Object)repeatedOmKeyInfo);
        }
        if (this.getOMResponse().getStatus() == OzoneManagerProtocolProtos.Status.OK) {
            this.addToDBBatch(omMetadataManager, batchOperation);
        }
    }

    @Override
    public void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        if (this.oldMultipartKeyInfo != null) {
            OmKeyInfo partKey = OmKeyInfo.getFromProtobuf((OzoneManagerProtocolProtos.KeyInfo)this.oldMultipartKeyInfo.getPartKeyInfo());
            RepeatedOmKeyInfo repeatedOmKeyInfo = (RepeatedOmKeyInfo)omMetadataManager.getDeletedTable().get((Object)this.oldMultipartKeyInfo.getPartName());
            repeatedOmKeyInfo = OmUtils.prepareKeyForDelete((OmKeyInfo)partKey, (RepeatedOmKeyInfo)repeatedOmKeyInfo, (long)this.omMultipartKeyInfo.getUpdateID(), (boolean)this.isRatisEnabled);
            omMetadataManager.getDeletedTable().putWithBatch(batchOperation, (Object)this.oldMultipartKeyInfo.getPartName(), (Object)repeatedOmKeyInfo);
        }
        omMetadataManager.getMultipartInfoTable().putWithBatch(batchOperation, (Object)this.multipartKey, (Object)this.omMultipartKeyInfo);
        omMetadataManager.getOpenKeyTable().deleteWithBatch(batchOperation, (Object)this.openKey);
    }
}

