/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.s3.multipart;

import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.RepeatedOmKeyInfo;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

public class S3MultipartUploadCompleteResponse
extends OMClientResponse {
    private String multipartKey;
    private OmKeyInfo omKeyInfo;
    private List<OmKeyInfo> partsUnusedList;

    public S3MultipartUploadCompleteResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, @Nonnull String multipartKey, @Nonnull OmKeyInfo omKeyInfo, @Nonnull List<OmKeyInfo> unUsedParts) {
        super(omResponse);
        this.partsUnusedList = unUsedParts;
        this.multipartKey = multipartKey;
        this.omKeyInfo = omKeyInfo;
    }

    public S3MultipartUploadCompleteResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse) {
        super(omResponse);
        this.checkStatusNotOK();
    }

    @Override
    public void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        omMetadataManager.getKeyTable().putWithBatch(batchOperation, (Object)omMetadataManager.getOzoneKey(this.omKeyInfo.getVolumeName(), this.omKeyInfo.getBucketName(), this.omKeyInfo.getKeyName()), (Object)this.omKeyInfo);
        omMetadataManager.getOpenKeyTable().deleteWithBatch(batchOperation, (Object)this.multipartKey);
        omMetadataManager.getMultipartInfoTable().deleteWithBatch(batchOperation, (Object)this.multipartKey);
        String keyName = omMetadataManager.getOzoneKey(this.omKeyInfo.getVolumeName(), this.omKeyInfo.getBucketName(), this.omKeyInfo.getKeyName());
        RepeatedOmKeyInfo repeatedOmKeyInfo = (RepeatedOmKeyInfo)omMetadataManager.getDeletedTable().get((Object)keyName);
        if (repeatedOmKeyInfo == null) {
            repeatedOmKeyInfo = new RepeatedOmKeyInfo(this.partsUnusedList);
        } else {
            repeatedOmKeyInfo.addOmKeyInfo(this.omKeyInfo);
        }
        omMetadataManager.getDeletedTable().putWithBatch(batchOperation, (Object)keyName, (Object)repeatedOmKeyInfo);
    }
}

