/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.volume;

import java.io.IOException;
import javax.annotation.Nonnull;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

public class OMVolumeSetOwnerResponse
extends OMClientResponse {
    private String oldOwner;
    private OzoneManagerProtocolProtos.UserVolumeInfo oldOwnerVolumeList;
    private OzoneManagerProtocolProtos.UserVolumeInfo newOwnerVolumeList;
    private OmVolumeArgs newOwnerVolumeArgs;

    public OMVolumeSetOwnerResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, @Nonnull String oldOwner, @Nonnull OzoneManagerProtocolProtos.UserVolumeInfo oldOwnerVolumeList, @Nonnull OzoneManagerProtocolProtos.UserVolumeInfo newOwnerVolumeList, @Nonnull OmVolumeArgs newOwnerVolumeArgs) {
        super(omResponse);
        this.oldOwner = oldOwner;
        this.oldOwnerVolumeList = oldOwnerVolumeList;
        this.newOwnerVolumeList = newOwnerVolumeList;
        this.newOwnerVolumeArgs = newOwnerVolumeArgs;
    }

    public OMVolumeSetOwnerResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse) {
        super(omResponse);
        this.checkStatusNotOK();
    }

    @Override
    protected void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        String oldOwnerKey = omMetadataManager.getUserKey(this.oldOwner);
        String newOwnerKey = omMetadataManager.getUserKey(this.newOwnerVolumeArgs.getOwnerName());
        if (this.oldOwnerVolumeList.getVolumeNamesList().size() == 0) {
            omMetadataManager.getUserTable().deleteWithBatch(batchOperation, (Object)oldOwnerKey);
        } else {
            omMetadataManager.getUserTable().putWithBatch(batchOperation, (Object)oldOwnerKey, (Object)this.oldOwnerVolumeList);
        }
        omMetadataManager.getUserTable().putWithBatch(batchOperation, (Object)newOwnerKey, (Object)this.newOwnerVolumeList);
        String dbVolumeKey = omMetadataManager.getVolumeKey(this.newOwnerVolumeArgs.getVolume());
        omMetadataManager.getVolumeTable().putWithBatch(batchOperation, (Object)dbVolumeKey, (Object)this.newOwnerVolumeArgs);
    }
}

