/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.web.ozShell;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneClientException;
import org.apache.hadoop.ozone.client.OzoneClientFactory;
import org.apache.http.client.utils.URIBuilder;

public class OzoneAddress {
    private static final String EMPTY_HOST = "___DEFAULT___";
    private URI ozoneURI;
    private String volumeName = "";
    private String bucketName = "";
    private String keyName = "";

    public OzoneAddress() throws OzoneClientException {
        this("o3:///");
    }

    public OzoneAddress(String address) throws OzoneClientException {
        if (address == null || address.equals("")) {
            address = "o3:///";
        }
        this.ozoneURI = this.parseURI(address);
        String path = this.ozoneURI.getPath();
        path = path.replaceAll("^/+", "");
        int sep1 = path.indexOf(47);
        int sep2 = path.indexOf(47, sep1 + 1);
        if (sep1 == -1) {
            this.volumeName = path;
        } else {
            this.volumeName = path.substring(0, sep1);
            if (sep2 == -1) {
                this.bucketName = path.substring(sep1 + 1);
            } else {
                this.bucketName = path.substring(sep1 + 1, sep2);
                this.keyName = path.substring(sep2 + 1);
            }
        }
    }

    public OzoneClient createClient(OzoneConfiguration conf) throws IOException, OzoneClientException {
        OzoneClient client;
        String scheme = this.ozoneURI.getScheme();
        if (this.ozoneURI.getScheme() == null || scheme.isEmpty()) {
            scheme = "o3";
        }
        if (scheme.equals("http")) {
            throw new UnsupportedOperationException("REST schema is not supported any more. Please use AWS S3 protocol if you need REST interface.");
        }
        if (scheme.equals("o3")) {
            if (this.ozoneURI.getHost() != null && !this.ozoneURI.getAuthority().equals(EMPTY_HOST)) {
                if (OmUtils.isOmHAServiceId((Configuration)conf, (String)this.ozoneURI.getHost())) {
                    if (this.ozoneURI.getPort() != -1) {
                        throw new OzoneClientException("Port " + this.ozoneURI.getPort() + " specified in URI but host '" + this.ozoneURI.getHost() + "' is a logical (HA) OzoneManager and does not use port information.");
                    }
                    client = OzoneClientFactory.getRpcClient((String)this.ozoneURI.getHost(), (Configuration)conf);
                } else {
                    client = this.ozoneURI.getPort() == -1 ? OzoneClientFactory.getRpcClient((String)this.ozoneURI.getHost(), (Integer)OmUtils.getOmRpcPort((Configuration)conf), (Configuration)conf) : OzoneClientFactory.getRpcClient((String)this.ozoneURI.getHost(), (Integer)this.ozoneURI.getPort(), (Configuration)conf);
                }
            } else {
                if (OmUtils.isServiceIdsDefined((Configuration)conf)) {
                    throw new OzoneClientException("Service ID or host name must not be omitted when ozone.om.service.ids is defined.");
                }
                client = OzoneClientFactory.getRpcClient((Configuration)conf);
            }
        } else {
            throw new OzoneClientException("Invalid URI, unknown protocol scheme: " + scheme);
        }
        return client;
    }

    public OzoneClient createClientForS3Commands(OzoneConfiguration conf, String omServiceID) throws IOException, OzoneClientException {
        if (omServiceID != null) {
            if (OmUtils.isOmHAServiceId((Configuration)conf, (String)omServiceID)) {
                return OzoneClientFactory.getRpcClient((String)omServiceID, (Configuration)conf);
            }
            throw new OzoneClientException("Service ID specified does not match with ozone.om.service.ids defined in the configuration. Configured ozone.om.service.ids are" + conf.getTrimmedStringCollection("ozone.om.service.ids"));
        }
        if (OmUtils.isServiceIdsDefined((Configuration)conf)) {
            throw new OzoneClientException("Service ID must not be omitted when ozone.om.service.ids is defined. Configured ozone.om.service.ids are " + conf.getTrimmedStringCollection("ozone.om.service.ids"));
        }
        return OzoneClientFactory.getRpcClient((Configuration)conf);
    }

    protected URI parseURI(String uri) throws OzoneClientException {
        if (uri == null || uri.isEmpty()) {
            throw new OzoneClientException("Ozone URI is needed to execute this command.");
        }
        URIBuilder uriBuilder = new URIBuilder(OzoneAddress.stringToUri(uri));
        if (uriBuilder.getPort() == 0) {
            uriBuilder.setPort(50070);
        }
        try {
            return uriBuilder.build();
        }
        catch (URISyntaxException e) {
            throw new OzoneClientException("Invalid URI: " + this.ozoneURI, (Throwable)e);
        }
    }

    private static URI stringToUri(String pathString) {
        String path;
        int firstSlash;
        String scheme = null;
        String authority = null;
        int start = 0;
        int colon = pathString.indexOf(58);
        int slash = pathString.indexOf(47);
        if (colon > 0 && slash == colon + 1) {
            scheme = pathString.substring(0, colon);
            start = colon + 1;
        }
        if (pathString.startsWith("//", start) && pathString.length() - start > 2) {
            int nextSlash = pathString.indexOf(47, start += 2);
            int authEnd = nextSlash > 0 ? nextSlash : pathString.length();
            authority = pathString.substring(start, authEnd);
            start = authEnd;
        }
        if ((firstSlash = (path = pathString.substring(start, pathString.length())).indexOf(47)) != 0) {
            path = "/" + path;
        }
        if (authority == null || authority.equals("")) {
            authority = EMPTY_HOST;
        }
        try {
            return new URI(scheme, authority, path, null, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String getVolumeName() {
        return this.volumeName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public void ensureBucketAddress() throws OzoneClientException {
        if (this.keyName.length() > 0) {
            throw new OzoneClientException("Invalid bucket name. Delimiters (/) not allowed in bucket name");
        }
        if (this.volumeName.length() == 0) {
            throw new OzoneClientException("Volume name is required.");
        }
        if (this.bucketName.length() == 0) {
            throw new OzoneClientException("Bucket name is required.");
        }
    }

    public void ensureKeyAddress() throws OzoneClientException {
        if (this.keyName.length() == 0) {
            throw new OzoneClientException("Key name is missing.");
        }
        if (this.volumeName.length() == 0) {
            throw new OzoneClientException("Volume name is missing");
        }
        if (this.bucketName.length() == 0) {
            throw new OzoneClientException("Bucket name is missing");
        }
    }

    public void ensureVolumeAddress() throws OzoneClientException {
        if (this.keyName.length() != 0) {
            throw new OzoneClientException("Invalid volume name. Delimiters (/) not allowed in volume name");
        }
        if (this.volumeName.length() == 0) {
            throw new OzoneClientException("Volume name is required");
        }
        if (this.bucketName.length() != 0) {
            throw new OzoneClientException("Invalid volume name. Delimiters (/) not allowed in volume name");
        }
    }

    public void ensureRootAddress() throws OzoneClientException {
        if (this.keyName.length() != 0 || this.bucketName.length() != 0 || this.volumeName.length() != 0) {
            throw new OzoneClientException("Invalid URI. Volume/bucket/key elements should not been used");
        }
    }
}

