/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.web.ozShell;

import io.opentracing.Scope;
import io.opentracing.util.GlobalTracer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.tracing.TracingUtil;
import org.apache.hadoop.ozone.web.ozShell.Shell;
import org.apache.hadoop.ozone.web.ozShell.bucket.BucketCommands;
import org.apache.hadoop.ozone.web.ozShell.keys.KeyCommands;
import org.apache.hadoop.ozone.web.ozShell.token.TokenCommands;
import org.apache.hadoop.ozone.web.ozShell.volume.VolumeCommands;
import picocli.CommandLine;

@CommandLine.Command(name="ozone sh", description={"Shell for Ozone object store"}, subcommands={VolumeCommands.class, BucketCommands.class, KeyCommands.class, TokenCommands.class}, versionProvider=HddsVersionProvider.class, mixinStandardHelpOptions=true)
public class OzoneShell
extends Shell {
    public static void main(String[] argv) throws Exception {
        new OzoneShell().run(argv);
    }

    public void execute(String[] argv) {
        TracingUtil.initTracing((String)"shell", (Configuration)this.createOzoneConfiguration());
        try (Scope scope = GlobalTracer.get().buildSpan("main").startActive(true);){
            super.execute(argv);
        }
    }
}

