/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.web.ozShell.bucket;

import java.util.Objects;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.ozone.security.acl.OzoneObjInfo;
import org.apache.hadoop.ozone.web.ozShell.Handler;
import org.apache.hadoop.ozone.web.ozShell.OzoneAddress;
import picocli.CommandLine;

@CommandLine.Command(name="addacl", description={"Add a new ACL."})
public class AddAclBucketHandler
extends Handler {
    @CommandLine.Parameters(arity="1..1", description={"URI of the volume/bucket.\nOzone URI could start with o3:// or without prefix. URI may contain the host and port of the OM server. Both are optional. If they are not specified it will be identified from the config files."})
    private String uri;
    @CommandLine.Option(names={"--acl", "-a"}, required=true, description={"The new ACL to be added.\nEx: user:user1:rw or group:hadoop:rw\nr = READ, w = WRITE, c = CREATE, d = DELETE, l = LIST, a = ALL, n = NONE, x = READ_ACL, y = WRITE_ACL."})
    private String acl;
    @CommandLine.Option(names={"--store", "-s"}, required=false, description={"Store type. i.e OZONE or S3"})
    private String storeType;

    @Override
    public Void call() throws Exception {
        Objects.requireNonNull(this.acl, "You need to specify a new ACL to be added.");
        OzoneAddress address = new OzoneAddress(this.uri);
        address.ensureBucketAddress();
        try (OzoneClient client = address.createClient(this.createOzoneConfiguration());){
            String volumeName = address.getVolumeName();
            String bucketName = address.getBucketName();
            if (this.isVerbose()) {
                System.out.printf("Volume Name : %s%n", volumeName);
                System.out.printf("Bucket Name : %s%n", bucketName);
            }
            OzoneObjInfo obj = OzoneObjInfo.Builder.newBuilder().setBucketName(bucketName).setVolumeName(volumeName).setResType(OzoneObj.ResourceType.BUCKET).setStoreType(this.storeType == null ? OzoneObj.StoreType.OZONE : OzoneObj.StoreType.valueOf((String)this.storeType)).build();
            boolean result = client.getObjectStore().addAcl((OzoneObj)obj, OzoneAcl.parseAcl((String)this.acl));
            String message = result ? "ACL added successfully." : "ACL already exists.";
            System.out.println(message);
        }
        return null;
    }
}

