/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.web.ozShell.bucket;

import org.apache.hadoop.hdds.protocol.StorageType;
import org.apache.hadoop.ozone.client.BucketArgs;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneVolume;
import org.apache.hadoop.ozone.web.ozShell.Handler;
import org.apache.hadoop.ozone.web.ozShell.ObjectPrinter;
import org.apache.hadoop.ozone.web.ozShell.OzoneAddress;
import picocli.CommandLine;

@CommandLine.Command(name="create", description={"creates a bucket in a given volume"})
public class CreateBucketHandler
extends Handler {
    @CommandLine.Parameters(arity="1..1", description={"URI of the volume/bucket.\nOzone URI could start with o3:// or without prefix. URI may contain the host and port of the OM server. Both are optional. If they are not specified it will be identified from the config files."})
    private String uri;
    @CommandLine.Option(names={"--bucketkey", "-k"}, description={"bucket encryption key name"})
    private String bekName;
    @CommandLine.Option(names={"--enforcegdpr", "-g"}, description={"if true, indicates GDPR enforced bucket, false/unspecified indicates otherwise"})
    private Boolean isGdprEnforced;

    @Override
    public Void call() throws Exception {
        OzoneAddress address = new OzoneAddress(this.uri);
        address.ensureBucketAddress();
        try (OzoneClient client = address.createClient(this.createOzoneConfiguration());){
            String volumeName = address.getVolumeName();
            String bucketName = address.getBucketName();
            BucketArgs.Builder bb = new BucketArgs.Builder().setStorageType(StorageType.DEFAULT).setVersioning(Boolean.valueOf(false));
            if (this.isGdprEnforced != null) {
                if (this.isGdprEnforced.booleanValue()) {
                    bb.addMetadata("gdprEnabled", String.valueOf(Boolean.TRUE));
                } else {
                    bb.addMetadata("gdprEnabled", String.valueOf(Boolean.FALSE));
                }
            }
            if (this.bekName != null) {
                if (!this.bekName.isEmpty()) {
                    bb.setBucketEncryptionKey(this.bekName);
                } else {
                    throw new IllegalArgumentException("Bucket encryption key name must be specified to enable bucket encryption!");
                }
            }
            if (this.isVerbose()) {
                System.out.printf("Volume Name : %s%n", volumeName);
                System.out.printf("Bucket Name : %s%n", bucketName);
                if (this.bekName != null) {
                    System.out.printf("Bucket Encryption enabled with Key Name: %s%n", this.bekName);
                }
            }
            OzoneVolume vol = client.getObjectStore().getVolume(volumeName);
            vol.createBucket(bucketName, bb.build());
            if (this.isVerbose()) {
                OzoneBucket bucket = vol.getBucket(bucketName);
                ObjectPrinter.printObjectAsJson(bucket);
            }
        }
        return null;
    }
}

