/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.web.ozShell.bucket;

import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.web.ozShell.Handler;
import org.apache.hadoop.ozone.web.ozShell.OzoneAddress;
import picocli.CommandLine;

@CommandLine.Command(name="path", description={"Returns the ozone path for S3Bucket"})
public class S3BucketMapping
extends Handler {
    @CommandLine.Parameters(arity="1..1", description={"Name of the s3 bucket."})
    private String s3BucketName;

    @Override
    public Void call() throws Exception {
        OzoneAddress ozoneAddress = new OzoneAddress();
        try (OzoneClient client = ozoneAddress.createClient(this.createOzoneConfiguration());){
            String mapping = client.getObjectStore().getOzoneBucketMapping(this.s3BucketName);
            String volumeName = client.getObjectStore().getOzoneVolumeName(this.s3BucketName);
            if (this.isVerbose()) {
                System.out.printf("Mapping created for S3Bucket is : %s%n", mapping);
            }
            System.out.printf("Volume name for S3Bucket is : %s%n", volumeName);
            String ozoneFsUri = String.format("%s://%s.%s", "o3fs", this.s3BucketName, volumeName);
            System.out.printf("Ozone FileSystem Uri is : %s%n", ozoneFsUri);
        }
        return null;
    }
}

