/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.web.ozShell.keys;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.hadoop.conf.StorageUnit;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneClientException;
import org.apache.hadoop.ozone.client.OzoneVolume;
import org.apache.hadoop.ozone.client.io.OzoneInputStream;
import org.apache.hadoop.ozone.web.ozShell.Handler;
import org.apache.hadoop.ozone.web.ozShell.OzoneAddress;
import picocli.CommandLine;

@CommandLine.Command(name="get", description={"Gets a specific key from ozone server"})
public class GetKeyHandler
extends Handler {
    @CommandLine.Parameters(index="0", arity="1..1", description={"URI of the volume/bucket/key.\nOzone URI could start with o3:// or without prefix. URI may contain the host and port of the OM server. Both are optional. If they are not specified it will be identified from the config files."})
    private String uri;
    @CommandLine.Parameters(index="1", arity="1..1", description={"File path to download the key to"})
    private String fileName;

    @Override
    public Void call() throws Exception {
        block52: {
            OzoneAddress address = new OzoneAddress(this.uri);
            address.ensureKeyAddress();
            OzoneConfiguration conf = this.createOzoneConfiguration();
            try (OzoneClient client = address.createClient(conf);){
                File dataFile;
                String volumeName = address.getVolumeName();
                String bucketName = address.getBucketName();
                String keyName = address.getKeyName();
                if (this.isVerbose()) {
                    System.out.printf("Volume Name : %s%n", volumeName);
                    System.out.printf("Bucket Name : %s%n", bucketName);
                    System.out.printf("Key Name : %s%n", keyName);
                }
                if ((dataFile = new File(this.fileName)).exists() && dataFile.isDirectory()) {
                    dataFile = new File(this.fileName, keyName);
                }
                if (dataFile.exists()) {
                    throw new OzoneClientException(dataFile.getPath() + " exists. Download would overwrite an existing file. Aborting.");
                }
                int chunkSize = (int)conf.getStorageSize("ozone.scm.chunk.size", "4MB", StorageUnit.BYTES);
                OzoneVolume vol = client.getObjectStore().getVolume(volumeName);
                OzoneBucket bucket = vol.getBucket(bucketName);
                try (OzoneInputStream input = bucket.readKey(keyName);
                     FileOutputStream output = new FileOutputStream(dataFile);){
                    IOUtils.copyBytes((InputStream)input, (OutputStream)output, (int)chunkSize);
                }
                if (!this.isVerbose()) break block52;
                var13_15 = null;
                try (FileInputStream stream = new FileInputStream(dataFile);){
                    String hash = DigestUtils.md5Hex((InputStream)stream);
                    System.out.printf("Downloaded file hash : %s%n", hash);
                }
                catch (Throwable throwable) {
                    var13_15 = throwable;
                    throw throwable;
                }
            }
        }
        return null;
    }
}

