/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.web.ozShell.keys;

import java.util.Iterator;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneKey;
import org.apache.hadoop.ozone.client.OzoneVolume;
import org.apache.hadoop.ozone.web.ozShell.Handler;
import org.apache.hadoop.ozone.web.ozShell.ObjectPrinter;
import org.apache.hadoop.ozone.web.ozShell.OzoneAddress;
import picocli.CommandLine;

@CommandLine.Command(name="list", aliases={"ls"}, description={"list all keys in a given bucket"})
public class ListKeyHandler
extends Handler {
    @CommandLine.Parameters(arity="1..1", description={"URI of the volume/bucket.\nOzone URI could start with o3:// or without prefix. URI may contain the host and port of the OM server. Both are optional. If they are not specified it will be identified from the config files."})
    private String uri;
    @CommandLine.Option(names={"--length", "-l"}, description={"Limit of the max results"}, defaultValue="100")
    private int maxKeys;
    @CommandLine.Option(names={"--start", "-s"}, description={"The key to start the listing from.\nThis will be excluded from the result."})
    private String startKey;
    @CommandLine.Option(names={"--prefix", "-p"}, description={"Prefix to filter the key"})
    private String prefix;

    @Override
    public Void call() throws Exception {
        OzoneAddress address = new OzoneAddress(this.uri);
        address.ensureBucketAddress();
        try (OzoneClient client = address.createClient(this.createOzoneConfiguration());){
            String volumeName = address.getVolumeName();
            String bucketName = address.getBucketName();
            if (this.maxKeys < 1) {
                throw new IllegalArgumentException("the length should be a positive number");
            }
            if (this.isVerbose()) {
                System.out.printf("Volume Name : %s%n", volumeName);
                System.out.printf("bucket Name : %s%n", bucketName);
            }
            OzoneVolume vol = client.getObjectStore().getVolume(volumeName);
            OzoneBucket bucket = vol.getBucket(bucketName);
            Iterator keyIterator = bucket.listKeys(this.prefix, this.startKey);
            int maxKeyLimit = this.maxKeys;
            int counter = 0;
            while (this.maxKeys > 0 && keyIterator.hasNext()) {
                OzoneKey ozoneKey = (OzoneKey)keyIterator.next();
                ObjectPrinter.printObjectAsJson(ozoneKey);
                --this.maxKeys;
                ++counter;
            }
            if (keyIterator.hasNext()) {
                System.out.println("Listing first " + maxKeyLimit + " entries of the result. Use --length (-l) to override max returned keys.");
            } else if (this.isVerbose()) {
                System.out.printf("Found : %d keys for bucket %s in volume : %s ", counter, bucketName, volumeName);
            }
        }
        return null;
    }
}

