/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.web.ozShell.keys;

import java.util.Objects;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.ozone.security.acl.OzoneObjInfo;
import org.apache.hadoop.ozone.web.ozShell.Handler;
import org.apache.hadoop.ozone.web.ozShell.OzoneAddress;
import picocli.CommandLine;

@CommandLine.Command(name="removeacl", description={"Remove an existing ACL."})
public class RemoveAclKeyHandler
extends Handler {
    @CommandLine.Parameters(arity="1..1", description={"URI of the volume/bucket.\nOzone URI could start with o3:// or without prefix. URI may contain the host and port of the OM server. Both are optional. If they are not specified it will be identified from the config files."})
    private String uri;
    @CommandLine.Option(names={"--acl", "-a"}, required=true, description={"The ACL to be removed.\nEx: user:user1:rw or group:hadoop:rw\nr = READ, w = WRITE, c = CREATE, d = DELETE, l = LIST, a = ALL, n = NONE, x = READ_ACL, y = WRITE_ACL."})
    private String acl;
    @CommandLine.Option(names={"--store", "-s"}, required=false, description={"Store type. i.e OZONE or S3"})
    private String storeType;

    @Override
    public Void call() throws Exception {
        Objects.requireNonNull(this.acl, "You need to specify an ACL to be removed.");
        OzoneAddress address = new OzoneAddress(this.uri);
        address.ensureKeyAddress();
        try (OzoneClient client = address.createClient(this.createOzoneConfiguration());){
            String volumeName = address.getVolumeName();
            String bucketName = address.getBucketName();
            String keyName = address.getKeyName();
            if (this.isVerbose()) {
                System.out.printf("Volume Name : %s%n", volumeName);
                System.out.printf("Bucket Name : %s%n", bucketName);
                System.out.printf("Key Name : %s%n", keyName);
            }
            OzoneObjInfo obj = OzoneObjInfo.Builder.newBuilder().setBucketName(bucketName).setVolumeName(volumeName).setKeyName(keyName).setResType(OzoneObj.ResourceType.KEY).setStoreType(this.storeType == null ? OzoneObj.StoreType.OZONE : OzoneObj.StoreType.valueOf((String)this.storeType)).build();
            boolean result = client.getObjectStore().removeAcl((OzoneObj)obj, OzoneAcl.parseAcl((String)this.acl));
            String message = result ? "ACL removed successfully." : "ACL doesn't exist.";
            System.out.println(message);
        }
        return null;
    }
}

