/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.web.ozShell.keys;

import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneVolume;
import org.apache.hadoop.ozone.web.ozShell.Handler;
import org.apache.hadoop.ozone.web.ozShell.OzoneAddress;
import picocli.CommandLine;

@CommandLine.Command(name="rename", description={"renames an existing key"})
public class RenameKeyHandler
extends Handler {
    @CommandLine.Parameters(index="0", arity="1..1", description={"URI of the volume/bucket.\nOzone URI could start with o3:// or without prefix. URI may contain the host and port of the OM server. Both are optional. If they are not specified it will be identified from the config files."})
    private String uri;
    @CommandLine.Parameters(index="1", arity="1..1", description={"The existing key to be renamed"})
    private String fromKey;
    @CommandLine.Parameters(index="2", arity="1..1", description={"The new desired name of the key"})
    private String toKey;

    @Override
    public Void call() throws Exception {
        OzoneAddress address = new OzoneAddress(this.uri);
        address.ensureBucketAddress();
        try (OzoneClient client = address.createClient(this.createOzoneConfiguration());){
            String volumeName = address.getVolumeName();
            String bucketName = address.getBucketName();
            if (this.isVerbose()) {
                System.out.printf("Volume Name : %s%n", volumeName);
                System.out.printf("Bucket Name : %s%n", bucketName);
            }
            OzoneVolume vol = client.getObjectStore().getVolume(volumeName);
            OzoneBucket bucket = vol.getBucket(bucketName);
            bucket.renameKey(this.fromKey, this.toKey);
            if (this.isVerbose()) {
                System.out.printf("Renamed Key : %s to %s%n", this.fromKey, this.toKey);
            }
        }
        return null;
    }
}

