/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.web.ozShell.s3;

import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.web.ozShell.Handler;
import org.apache.hadoop.ozone.web.ozShell.OzoneAddress;
import org.apache.hadoop.security.UserGroupInformation;
import picocli.CommandLine;

@CommandLine.Command(name="getsecret", description={"Returns s3 secret for current user"})
public class GetS3SecretHandler
extends Handler {
    public static final String OZONE_GETS3SECRET_ERROR = "This command is not supported in unsecure clusters.";
    @CommandLine.Option(names={"--om-service-id"}, required=false, description={"OM Service ID is required to be specified for OM HA cluster"})
    private String omServiceID;

    @Override
    public Void call() throws Exception {
        OzoneConfiguration ozoneConfiguration = this.createOzoneConfiguration();
        try (OzoneClient client = new OzoneAddress().createClientForS3Commands(ozoneConfiguration, this.omServiceID);){
            if (ozoneConfiguration.getBoolean("ozone.security.enabled", false)) {
                System.out.println(client.getObjectStore().getS3Secret(UserGroupInformation.getCurrentUser().getUserName()).toString());
            } else {
                System.out.println(OZONE_GETS3SECRET_ERROR);
            }
        }
        return null;
    }
}

