/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.web.ozShell.volume;

import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneVolume;
import org.apache.hadoop.ozone.client.VolumeArgs;
import org.apache.hadoop.ozone.web.ozShell.Handler;
import org.apache.hadoop.ozone.web.ozShell.ObjectPrinter;
import org.apache.hadoop.ozone.web.ozShell.OzoneAddress;
import org.apache.hadoop.security.UserGroupInformation;
import picocli.CommandLine;

@CommandLine.Command(name="create", description={"Creates a volume for the specified user"})
public class CreateVolumeHandler
extends Handler {
    @CommandLine.Parameters(arity="1..1", description={"URI of the volume.\nOzone URI could start with o3:// or without prefix. URI may contain the host and port of the OM server. Both are optional. If they are not specified it will be identified from the config files."})
    private String uri;
    @CommandLine.Option(names={"--user", "-u"}, description={"Owner of of the volume"})
    private String userName;
    @CommandLine.Option(names={"--quota", "-q"}, description={"Quota of the newly created volume (eg. 1G)"})
    private String quota;
    @CommandLine.Option(names={"--root"}, description={"Development flag to execute the command as the admin (hdfs) user."})
    private boolean root;

    @Override
    public Void call() throws Exception {
        if (this.userName == null) {
            this.userName = UserGroupInformation.getCurrentUser().getUserName();
        }
        OzoneAddress address = new OzoneAddress(this.uri);
        address.ensureVolumeAddress();
        try (OzoneClient client = address.createClient(this.createOzoneConfiguration());){
            String volumeName = address.getVolumeName();
            if (this.isVerbose()) {
                System.out.printf("Volume name : %s%n", volumeName);
            }
            String rootName = this.root ? "hdfs" : UserGroupInformation.getCurrentUser().getShortUserName();
            VolumeArgs.Builder volumeArgsBuilder = VolumeArgs.newBuilder().setAdmin(rootName).setOwner(this.userName);
            if (this.quota != null) {
                volumeArgsBuilder.setQuota(this.quota);
            }
            client.getObjectStore().createVolume(volumeName, volumeArgsBuilder.build());
            if (this.isVerbose()) {
                OzoneVolume vol = client.getObjectStore().getVolume(volumeName);
                ObjectPrinter.printObjectAsJson(vol);
            }
        }
        return null;
    }
}

