/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.web.ozShell.volume;

import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneVolume;
import org.apache.hadoop.ozone.web.ozShell.Handler;
import org.apache.hadoop.ozone.web.ozShell.ObjectPrinter;
import org.apache.hadoop.ozone.web.ozShell.OzoneAddress;
import picocli.CommandLine;

@CommandLine.Command(name="info", description={"returns information about a specific volume"})
public class InfoVolumeHandler
extends Handler {
    @CommandLine.Parameters(arity="1..1", description={"URI of the volume.\nOzone URI could start with o3:// or without prefix. URI may contain the host and port of the OM server. Both are optional. If they are not specified it will be identified from the config files."})
    private String uri;

    @Override
    public Void call() throws Exception {
        OzoneAddress address = new OzoneAddress(this.uri);
        address.ensureVolumeAddress();
        try (OzoneClient client = address.createClient(this.createOzoneConfiguration());){
            String volumeName = address.getVolumeName();
            OzoneVolume vol = client.getObjectStore().getVolume(volumeName);
            ObjectPrinter.printObjectAsJson(vol);
        }
        return null;
    }
}

