/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.web.ozShell.volume;

import java.util.Iterator;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneVolume;
import org.apache.hadoop.ozone.web.ozShell.Handler;
import org.apache.hadoop.ozone.web.ozShell.ObjectPrinter;
import org.apache.hadoop.ozone.web.ozShell.OzoneAddress;
import org.apache.hadoop.security.UserGroupInformation;
import picocli.CommandLine;

@CommandLine.Command(name="list", aliases={"ls"}, description={"List the volumes of a given user"})
public class ListVolumeHandler
extends Handler {
    @CommandLine.Parameters(arity="1..1", description={"URI of the volume.\nOzone URI could start with o3:// or without prefix. URI may contain the host and port of the OM server. Both are optional. If they are not specified it will be identified from the config files."}, defaultValue="/")
    private String uri;
    @CommandLine.Option(names={"--length", "-l"}, description={"Limit of the max results"}, defaultValue="100")
    private int maxVolumes;
    @CommandLine.Option(names={"--start", "-s"}, description={"The volume to start the listing from.\nThis will be excluded from the result."})
    private String startVolume;
    @CommandLine.Option(names={"--prefix", "-p"}, description={"Prefix to filter the volumes"})
    private String prefix;
    @CommandLine.Option(names={"--user", "-u"}, description={"Owner of the volumes to list."})
    private String userName;

    @Override
    public Void call() throws Exception {
        OzoneAddress address = new OzoneAddress(this.uri);
        address.ensureRootAddress();
        try (OzoneClient client = address.createClient(this.createOzoneConfiguration());){
            if (this.userName == null) {
                this.userName = UserGroupInformation.getCurrentUser().getUserName();
            }
            if (this.maxVolumes < 1) {
                throw new IllegalArgumentException("the length should be a positive number");
            }
            Iterator volumeIterator = this.userName != null ? client.getObjectStore().listVolumesByUser(this.userName, this.prefix, this.startVolume) : client.getObjectStore().listVolumes(this.prefix);
            int counter = 0;
            while (this.maxVolumes > 0 && volumeIterator.hasNext()) {
                OzoneVolume next = (OzoneVolume)volumeIterator.next();
                ObjectPrinter.printObjectAsJson(next);
                --this.maxVolumes;
                ++counter;
            }
            if (this.isVerbose()) {
                System.out.printf("Found : %d volumes for user : %s ", counter, this.userName);
            }
        }
        return null;
    }
}

