/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.web.ozShell.volume;

import org.apache.hadoop.hdds.client.OzoneQuota;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneVolume;
import org.apache.hadoop.ozone.web.ozShell.Handler;
import org.apache.hadoop.ozone.web.ozShell.ObjectPrinter;
import org.apache.hadoop.ozone.web.ozShell.OzoneAddress;
import picocli.CommandLine;

@CommandLine.Command(name="update", description={"Updates parameter of the volumes"})
public class UpdateVolumeHandler
extends Handler {
    @CommandLine.Parameters(arity="1..1", description={"URI of the volume.\nOzone URI could start with o3:// or without prefix. URI may contain the host and port of the OM server. Both are optional. If they are not specified it will be identified from the config files."})
    private String uri;
    @CommandLine.Option(names={"--user"}, description={"Owner of the volume to set"})
    private String ownerName;
    @CommandLine.Option(names={"--quota"}, description={"Quota of the volume to set(eg. 1G)"})
    private String quota;

    @Override
    public Void call() throws Exception {
        OzoneAddress address = new OzoneAddress(this.uri);
        address.ensureVolumeAddress();
        try (OzoneClient client = address.createClient(this.createOzoneConfiguration());){
            String volumeName = address.getVolumeName();
            OzoneVolume volume = client.getObjectStore().getVolume(volumeName);
            if (this.quota != null && !this.quota.isEmpty()) {
                volume.setQuota(OzoneQuota.parseQuota((String)this.quota));
            }
            if (this.ownerName != null && !this.ownerName.isEmpty()) {
                volume.setOwner(this.ownerName);
            }
            ObjectPrinter.printObjectAsJson(volume);
        }
        return null;
    }
}

