/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.PrivilegedExceptionAction;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.StorageUnit;
import org.apache.hadoop.crypto.key.KeyProviderCryptoExtension;
import org.apache.hadoop.fs.FileEncryptionInfo;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.AllocatedBlock;
import org.apache.hadoop.hdds.scm.container.common.helpers.ContainerWithPipeline;
import org.apache.hadoop.hdds.scm.container.common.helpers.ExcludeList;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.scm.protocol.ScmBlockLocationProtocol;
import org.apache.hadoop.hdds.utils.BackgroundService;
import org.apache.hadoop.hdds.utils.UniqueId;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.hdds.utils.db.CodecRegistry;
import org.apache.hadoop.hdds.utils.db.DBStore;
import org.apache.hadoop.hdds.utils.db.RDBStore;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.common.BlockGroup;
import org.apache.hadoop.ozone.om.KeyDeletingService;
import org.apache.hadoop.ozone.om.KeyManager;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.PrefixManager;
import org.apache.hadoop.ozone.om.ScmClient;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.BucketEncryptionKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyArgs;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfoGroup;
import org.apache.hadoop.ozone.om.helpers.OmMultipartCommitUploadPartInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartUpload;
import org.apache.hadoop.ozone.om.helpers.OmMultipartUploadCompleteInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartUploadCompleteList;
import org.apache.hadoop.ozone.om.helpers.OmMultipartUploadList;
import org.apache.hadoop.ozone.om.helpers.OmMultipartUploadListParts;
import org.apache.hadoop.ozone.om.helpers.OmPartInfo;
import org.apache.hadoop.ozone.om.helpers.OmPrefixInfo;
import org.apache.hadoop.ozone.om.helpers.OpenKeySession;
import org.apache.hadoop.ozone.om.helpers.OzoneAclUtil;
import org.apache.hadoop.ozone.om.helpers.OzoneFSUtils;
import org.apache.hadoop.ozone.om.helpers.OzoneFileStatus;
import org.apache.hadoop.ozone.om.helpers.RepeatedOmKeyInfo;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.OzoneBlockTokenSecretManager;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.ozone.security.acl.RequestContext;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyManagerImpl
implements KeyManager {
    private static final Logger LOG = LoggerFactory.getLogger(KeyManagerImpl.class);
    private final OzoneManager ozoneManager;
    private final ScmClient scmClient;
    private final OMMetadataManager metadataManager;
    private final long scmBlockSize;
    private final boolean useRatis;
    private final int preallocateBlocksMax;
    private final int listTrashKeysMax;
    private final String omId;
    private final OzoneBlockTokenSecretManager secretManager;
    private final boolean grpcBlockTokenEnabled;
    private BackgroundService keyDeletingService;
    private final KeyProviderCryptoExtension kmsProvider;
    private final PrefixManager prefixManager;

    @VisibleForTesting
    public KeyManagerImpl(ScmBlockLocationProtocol scmBlockClient, OMMetadataManager metadataManager, OzoneConfiguration conf, String omId, OzoneBlockTokenSecretManager secretManager) {
        this(null, new ScmClient(scmBlockClient, null), metadataManager, conf, omId, secretManager, null, null);
    }

    public KeyManagerImpl(OzoneManager om, ScmClient scmClient, OzoneConfiguration conf, String omId) {
        this(om, scmClient, om.getMetadataManager(), conf, omId, om.getBlockTokenMgr(), om.getKmsProvider(), om.getPrefixManager());
    }

    public KeyManagerImpl(OzoneManager om, ScmClient scmClient, OMMetadataManager metadataManager, OzoneConfiguration conf, String omId, OzoneBlockTokenSecretManager secretManager, KeyProviderCryptoExtension kmsProvider, PrefixManager prefixManager) {
        this.scmBlockSize = (long)conf.getStorageSize("ozone.scm.block.size", "256MB", StorageUnit.BYTES);
        this.useRatis = conf.getBoolean("dfs.container.ratis.enabled", false);
        this.preallocateBlocksMax = conf.getInt("ozone.key.preallocation.max.blocks", 64);
        this.grpcBlockTokenEnabled = conf.getBoolean("hdds.block.token.enabled", false);
        this.listTrashKeysMax = conf.getInt("ozone.client.list.trash.keys.max", 1000);
        this.ozoneManager = om;
        this.omId = omId;
        this.scmClient = scmClient;
        this.metadataManager = metadataManager;
        this.prefixManager = prefixManager;
        this.secretManager = secretManager;
        this.kmsProvider = kmsProvider;
    }

    @Override
    public void start(OzoneConfiguration configuration) {
        if (this.keyDeletingService == null) {
            long blockDeleteInterval = configuration.getTimeDuration("ozone.block.deleting.service.interval", "60s", TimeUnit.MILLISECONDS);
            long serviceTimeout = configuration.getTimeDuration("ozone.block.deleting.service.timeout", "300s", TimeUnit.MILLISECONDS);
            this.keyDeletingService = new KeyDeletingService(this.ozoneManager, this.scmClient.getBlockClient(), this, blockDeleteInterval, serviceTimeout, (ConfigurationSource)configuration);
            this.keyDeletingService.start();
        }
    }

    KeyProviderCryptoExtension getKMSProvider() {
        return this.kmsProvider;
    }

    @Override
    public void stop() throws IOException {
        if (this.keyDeletingService != null) {
            this.keyDeletingService.shutdown();
            this.keyDeletingService = null;
        }
    }

    private OmBucketInfo getBucketInfo(String volumeName, String bucketName) throws IOException {
        String bucketKey = this.metadataManager.getBucketKey(volumeName, bucketName);
        return (OmBucketInfo)this.metadataManager.getBucketTable().get((Object)bucketKey);
    }

    private void validateBucket(String volumeName, String bucketName) throws IOException {
        String bucketKey = this.metadataManager.getBucketKey(volumeName, bucketName);
        if (this.metadataManager.getBucketTable().get((Object)bucketKey) == null) {
            String volumeKey = this.metadataManager.getVolumeKey(volumeName);
            if (this.metadataManager.getVolumeTable().get((Object)volumeKey) == null) {
                LOG.error("volume not found: {}", (Object)volumeName);
                throw new OMException("Volume not found", OMException.ResultCodes.VOLUME_NOT_FOUND);
            }
            LOG.error("bucket not found: {}/{} ", (Object)volumeName, (Object)bucketName);
            throw new OMException("Bucket not found", OMException.ResultCodes.BUCKET_NOT_FOUND);
        }
    }

    private OmBucketInfo validateS3Bucket(String volumeName, String bucketName) throws IOException {
        String bucketKey = this.metadataManager.getBucketKey(volumeName, bucketName);
        OmBucketInfo omBucketInfo = (OmBucketInfo)this.metadataManager.getBucketTable().get((Object)bucketKey);
        if (omBucketInfo == null) {
            LOG.error("bucket not found: {}/{} ", (Object)volumeName, (Object)bucketName);
            throw new OMException("Bucket not found", OMException.ResultCodes.BUCKET_NOT_FOUND);
        }
        return omBucketInfo;
    }

    @Override
    public OmKeyLocationInfo allocateBlock(OmKeyArgs args, long clientID, ExcludeList excludeList) throws IOException {
        Preconditions.checkNotNull((Object)args);
        String volumeName = args.getVolumeName();
        String bucketName = args.getBucketName();
        String keyName = args.getKeyName();
        this.validateBucket(volumeName, bucketName);
        String openKey = this.metadataManager.getOpenKey(volumeName, bucketName, keyName, clientID);
        OmKeyInfo keyInfo = (OmKeyInfo)this.metadataManager.getOpenKeyTable().get((Object)openKey);
        if (keyInfo == null) {
            LOG.error("Allocate block for a key not in open status in meta store /{}/{}/{} with ID {}", new Object[]{volumeName, bucketName, keyName, clientID});
            throw new OMException("Open Key not found", OMException.ResultCodes.KEY_NOT_FOUND);
        }
        List<OmKeyLocationInfo> locationInfos = this.allocateBlock(keyInfo, excludeList, this.scmBlockSize);
        keyInfo.appendNewBlocks(locationInfos, true);
        keyInfo.updateModifcationTime();
        this.metadataManager.getOpenKeyTable().put((Object)openKey, (Object)keyInfo);
        return locationInfos.get(0);
    }

    private List<OmKeyLocationInfo> allocateBlock(OmKeyInfo keyInfo, ExcludeList excludeList, long requestedSize) throws IOException {
        List allocatedBlocks;
        int numBlocks = Math.min((int)((requestedSize - 1L) / this.scmBlockSize + 1L), this.preallocateBlocksMax);
        ArrayList<OmKeyLocationInfo> locationInfos = new ArrayList<OmKeyLocationInfo>(numBlocks);
        String remoteUser = KeyManagerImpl.getRemoteUser().getShortUserName();
        try {
            allocatedBlocks = this.scmClient.getBlockClient().allocateBlock(this.scmBlockSize, numBlocks, keyInfo.getType(), keyInfo.getFactor(), this.omId, excludeList);
        }
        catch (SCMException ex) {
            if (ex.getResult().equals((Object)SCMException.ResultCodes.SAFE_MODE_EXCEPTION)) {
                throw new OMException(ex.getMessage(), OMException.ResultCodes.SCM_IN_SAFE_MODE);
            }
            throw ex;
        }
        for (AllocatedBlock allocatedBlock : allocatedBlocks) {
            OmKeyLocationInfo.Builder builder = new OmKeyLocationInfo.Builder().setBlockID(new BlockID(allocatedBlock.getBlockID())).setLength(this.scmBlockSize).setOffset(0L).setPipeline(allocatedBlock.getPipeline());
            if (this.grpcBlockTokenEnabled) {
                builder.setToken(this.secretManager.generateToken(remoteUser, allocatedBlock.getBlockID().toString(), this.getAclForUser(remoteUser), this.scmBlockSize));
            }
            locationInfos.add(builder.build());
        }
        return locationInfos;
    }

    public static UserGroupInformation getRemoteUser() throws IOException {
        UserGroupInformation ugi = Server.getRemoteUser();
        return ugi != null ? ugi : UserGroupInformation.getCurrentUser();
    }

    private EnumSet<HddsProtos.BlockTokenSecretProto.AccessModeProto> getAclForUser(String user) {
        return EnumSet.allOf(HddsProtos.BlockTokenSecretProto.AccessModeProto.class);
    }

    private KeyProviderCryptoExtension.EncryptedKeyVersion generateEDEK(final String ezKeyName) throws IOException {
        if (ezKeyName == null) {
            return null;
        }
        long generateEDEKStartTime = Time.monotonicNow();
        KeyProviderCryptoExtension.EncryptedKeyVersion edek = (KeyProviderCryptoExtension.EncryptedKeyVersion)SecurityUtil.doAsLoginUser((PrivilegedExceptionAction)new PrivilegedExceptionAction<KeyProviderCryptoExtension.EncryptedKeyVersion>(){

            @Override
            public KeyProviderCryptoExtension.EncryptedKeyVersion run() throws IOException {
                try {
                    return KeyManagerImpl.this.getKMSProvider().generateEncryptedKey(ezKeyName);
                }
                catch (GeneralSecurityException e) {
                    throw new IOException(e);
                }
            }
        });
        long generateEDEKTime = Time.monotonicNow() - generateEDEKStartTime;
        LOG.debug("generateEDEK takes {} ms", (Object)generateEDEKTime);
        Preconditions.checkNotNull((Object)edek);
        return edek;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public OpenKeySession openKey(OmKeyArgs args) throws IOException {
        OmKeyInfo keyInfo;
        FileEncryptionInfo encInfo;
        OmBucketInfo bucketInfo;
        HddsProtos.ReplicationType type;
        Preconditions.checkNotNull((Object)args);
        Preconditions.checkNotNull((Object)args.getAcls(), (Object)"Default acls should be set.");
        String volumeName = args.getVolumeName();
        String bucketName = args.getBucketName();
        String keyName = args.getKeyName();
        this.validateBucket(volumeName, bucketName);
        long currentTime = UniqueId.next();
        long size = args.getDataSize() > 0L ? args.getDataSize() : this.scmBlockSize;
        ArrayList<OmKeyLocationInfo> locations = new ArrayList<OmKeyLocationInfo>();
        HddsProtos.ReplicationFactor factor = args.getFactor();
        if (factor == null) {
            HddsProtos.ReplicationFactor replicationFactor = factor = this.useRatis ? HddsProtos.ReplicationFactor.THREE : HddsProtos.ReplicationFactor.ONE;
        }
        if ((type = args.getType()) == null) {
            type = this.useRatis ? HddsProtos.ReplicationType.RATIS : HddsProtos.ReplicationType.STAND_ALONE;
        }
        String dbKeyName = this.metadataManager.getOzoneKey(args.getVolumeName(), args.getBucketName(), args.getKeyName());
        this.metadataManager.getLock().acquireLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        try {
            bucketInfo = this.getBucketInfo(volumeName, bucketName);
            encInfo = this.getFileEncryptionInfo(bucketInfo);
            keyInfo = this.prepareKeyInfo(args, dbKeyName, size, locations, encInfo);
        }
        catch (OMException e) {
            try {
                throw e;
                catch (IOException ex) {
                    LOG.error("Key open failed for volume:{} bucket:{} key:{}", new Object[]{volumeName, bucketName, keyName, ex});
                    throw new OMException(ex.getMessage(), OMException.ResultCodes.KEY_ALLOCATION_ERROR);
                }
            }
            catch (Throwable throwable) {
                this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                throw throwable;
            }
        }
        this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        if (keyInfo == null) {
            keyInfo = this.createKeyInfo(args, locations, factor, type, size, encInfo, bucketInfo);
        }
        long openVersion = keyInfo.getLatestVersionLocations().getVersion();
        LOG.debug("Key {} allocated in volume {} bucket {}", new Object[]{keyName, volumeName, bucketName});
        this.allocateBlockInKey(keyInfo, size, currentTime);
        return new OpenKeySession(currentTime, keyInfo, openVersion);
    }

    private void allocateBlockInKey(OmKeyInfo keyInfo, long size, long sessionId) throws IOException {
        String openKey = this.metadataManager.getOpenKey(keyInfo.getVolumeName(), keyInfo.getBucketName(), keyInfo.getKeyName(), sessionId);
        if (size > 0L) {
            List<OmKeyLocationInfo> locationInfos = this.allocateBlock(keyInfo, new ExcludeList(), size);
            keyInfo.appendNewBlocks(locationInfos, true);
        }
        this.metadataManager.getOpenKeyTable().put((Object)openKey, (Object)keyInfo);
    }

    private OmKeyInfo prepareKeyInfo(OmKeyArgs keyArgs, String dbKeyName, long size, List<OmKeyLocationInfo> locations, FileEncryptionInfo encInfo) throws IOException {
        OmKeyInfo keyInfo = null;
        if (keyArgs.getIsMultipartKey()) {
            keyInfo = this.prepareMultipartKeyInfo(keyArgs, size, locations, encInfo);
        } else if (this.metadataManager.getKeyTable().isExist((Object)dbKeyName)) {
            keyInfo = (OmKeyInfo)this.metadataManager.getKeyTable().get((Object)dbKeyName);
            keyInfo.addNewVersion(locations, true);
            keyInfo.setDataSize(size + keyInfo.getDataSize());
        }
        if (keyInfo != null) {
            keyInfo.setMetadata(keyArgs.getMetadata());
        }
        return keyInfo;
    }

    private OmKeyInfo prepareMultipartKeyInfo(OmKeyArgs args, long size, List<OmKeyLocationInfo> locations, FileEncryptionInfo encInfo) throws IOException {
        Preconditions.checkArgument((args.getMultipartUploadPartNumber() > 0 ? 1 : 0) != 0, (Object)"PartNumber Should be greater than zero");
        String uploadID = args.getMultipartUploadID();
        Preconditions.checkNotNull((Object)uploadID);
        String multipartKey = this.metadataManager.getMultipartKey(args.getVolumeName(), args.getBucketName(), args.getKeyName(), uploadID);
        OmKeyInfo partKeyInfo = (OmKeyInfo)this.metadataManager.getOpenKeyTable().get((Object)multipartKey);
        if (partKeyInfo == null) {
            throw new OMException("No such Multipart upload is with specified uploadId " + uploadID, OMException.ResultCodes.NO_SUCH_MULTIPART_UPLOAD_ERROR);
        }
        HddsProtos.ReplicationFactor factor = partKeyInfo.getFactor();
        HddsProtos.ReplicationType type = partKeyInfo.getType();
        return this.createKeyInfo(args, locations, factor, type, size, encInfo, this.getBucketInfo(args.getVolumeName(), args.getBucketName()));
    }

    private OmKeyInfo createKeyInfo(OmKeyArgs keyArgs, List<OmKeyLocationInfo> locations, HddsProtos.ReplicationFactor factor, HddsProtos.ReplicationType type, long size, FileEncryptionInfo encInfo, OmBucketInfo omBucketInfo) {
        OmKeyInfo.Builder builder = new OmKeyInfo.Builder().setVolumeName(keyArgs.getVolumeName()).setBucketName(keyArgs.getBucketName()).setKeyName(keyArgs.getKeyName()).setOmKeyLocationInfos(Collections.singletonList(new OmKeyLocationInfoGroup(0L, locations))).setCreationTime(Time.now()).setModificationTime(Time.now()).setDataSize(size).setReplicationType(type).setReplicationFactor(factor).setFileEncryptionInfo(encInfo).addAllMetadata(keyArgs.getMetadata());
        builder.setAcls(this.getAclsForKey(keyArgs, omBucketInfo));
        if (Boolean.valueOf((String)omBucketInfo.getMetadata().get("gdprEnabled")).booleanValue()) {
            builder.addMetadata("gdprEnabled", Boolean.TRUE.toString());
        }
        return builder.build();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void commitKey(OmKeyArgs args, long clientID) throws IOException {
        Preconditions.checkNotNull((Object)args);
        String volumeName = args.getVolumeName();
        String bucketName = args.getBucketName();
        String keyName = args.getKeyName();
        List locationInfoList = args.getLocationInfoList();
        String objectKey = this.metadataManager.getOzoneKey(volumeName, bucketName, keyName);
        String openKey = this.metadataManager.getOpenKey(volumeName, bucketName, keyName, clientID);
        Preconditions.checkNotNull((Object)locationInfoList);
        try {
            this.metadataManager.getLock().acquireLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            this.validateBucket(volumeName, bucketName);
            OmKeyInfo keyInfo = (OmKeyInfo)this.metadataManager.getOpenKeyTable().get((Object)openKey);
            if (keyInfo == null) {
                throw new OMException("Failed to commit key, as " + openKey + "entry is not found in the openKey table", OMException.ResultCodes.KEY_NOT_FOUND);
            }
            keyInfo.setDataSize(args.getDataSize());
            keyInfo.setModificationTime(Time.now());
            keyInfo.updateLocationInfoList(locationInfoList);
            this.metadataManager.getStore().move((Object)openKey, (Object)objectKey, (Object)keyInfo, this.metadataManager.getOpenKeyTable(), this.metadataManager.getKeyTable());
        }
        catch (OMException e) {
            try {
                throw e;
                catch (IOException ex) {
                    LOG.error("Key commit failed for volume:{} bucket:{} key:{}", new Object[]{volumeName, bucketName, keyName, ex});
                    throw new OMException(ex.getMessage(), OMException.ResultCodes.KEY_ALLOCATION_ERROR);
                }
            }
            catch (Throwable throwable) {
                this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                throw throwable;
            }
        }
        this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
    }

    @Override
    public OmKeyInfo lookupKey(OmKeyArgs args, String clientAddress) throws IOException {
        Preconditions.checkNotNull((Object)args);
        String volumeName = args.getVolumeName();
        String bucketName = args.getBucketName();
        String keyName = args.getKeyName();
        this.metadataManager.getLock().acquireReadLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        OmKeyInfo value = null;
        try {
            String keyBytes = this.metadataManager.getOzoneKey(volumeName, bucketName, keyName);
            value = (OmKeyInfo)this.metadataManager.getKeyTable().get((Object)keyBytes);
        }
        catch (IOException ex) {
            try {
                if (ex instanceof OMException) {
                    throw ex;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Get key failed for volume:{} bucket:{} key:{}", new Object[]{volumeName, bucketName, keyName, ex});
                }
                throw new OMException(ex.getMessage(), OMException.ResultCodes.KEY_NOT_FOUND);
            }
            catch (Throwable throwable) {
                this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                throw throwable;
            }
        }
        this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        if (value == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("volume:{} bucket:{} Key:{} not found", new Object[]{volumeName, bucketName, keyName});
            }
            throw new OMException("Key not found", OMException.ResultCodes.KEY_NOT_FOUND);
        }
        if (this.grpcBlockTokenEnabled) {
            String remoteUser = KeyManagerImpl.getRemoteUser().getShortUserName();
            for (OmKeyLocationInfoGroup key : value.getKeyLocationVersions()) {
                key.getLocationList().forEach(k -> k.setToken(this.secretManager.generateToken(remoteUser, k.getBlockID().getContainerBlockID().toString(), this.getAclForUser(remoteUser), k.getLength())));
            }
        }
        if (args.getRefreshPipeline()) {
            this.refreshPipeline(value);
        }
        if (args.getSortDatanodes()) {
            this.sortDatanodeInPipeline(value, clientAddress);
        }
        return value;
    }

    @VisibleForTesting
    protected void refreshPipeline(OmKeyInfo value) throws IOException {
        List locationInfoGroups;
        List list = locationInfoGroups = value == null ? null : value.getKeyLocationVersions();
        if (this.scmClient.getContainerClient() == null || CollectionUtils.isEmpty((Collection)locationInfoGroups)) {
            return;
        }
        HashSet<Long> containerIDs = new HashSet<Long>();
        for (OmKeyLocationInfoGroup key : locationInfoGroups) {
            for (OmKeyLocationInfo k : key.getLocationList()) {
                containerIDs.add(k.getContainerID());
            }
        }
        HashMap<Long, ContainerWithPipeline> containerWithPipelineMap = new HashMap<Long, ContainerWithPipeline>();
        try {
            List cpList = this.scmClient.getContainerClient().getContainerWithPipelineBatch(new ArrayList(containerIDs));
            for (ContainerWithPipeline cp : cpList) {
                containerWithPipelineMap.put(cp.getContainerInfo().getContainerID(), cp);
            }
        }
        catch (IOException ioEx) {
            LOG.debug("Get containerPipeline failed for volume:{} bucket:{} key:{}", new Object[]{value.getVolumeName(), value.getBucketName(), value.getKeyName(), ioEx});
            throw new OMException(ioEx.getMessage(), OMException.ResultCodes.SCM_GET_PIPELINE_EXCEPTION);
        }
        for (OmKeyLocationInfoGroup key : locationInfoGroups) {
            for (OmKeyLocationInfo k : key.getLocationList()) {
                ContainerWithPipeline cp = (ContainerWithPipeline)containerWithPipelineMap.get(k.getContainerID());
                if (cp.getPipeline().equals((Object)k.getPipeline())) continue;
                k.setPipeline(cp.getPipeline());
            }
        }
    }

    @Override
    public void renameKey(OmKeyArgs args, String toKeyName) throws IOException {
        OmKeyInfo fromKeyValue;
        String fromKey;
        String fromKeyName;
        String bucketName;
        String volumeName;
        block21: {
            Preconditions.checkNotNull((Object)args);
            Preconditions.checkNotNull((Object)toKeyName);
            volumeName = args.getVolumeName();
            bucketName = args.getBucketName();
            fromKeyName = args.getKeyName();
            if (toKeyName.length() == 0 || fromKeyName.length() == 0) {
                LOG.error("Rename key failed for volume:{} bucket:{} fromKey:{} toKey:{}", new Object[]{volumeName, bucketName, fromKeyName, toKeyName});
                throw new OMException("Key name is empty", OMException.ResultCodes.INVALID_KEY_NAME);
            }
            this.metadataManager.getLock().acquireLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            fromKey = this.metadataManager.getOzoneKey(volumeName, bucketName, fromKeyName);
            fromKeyValue = (OmKeyInfo)this.metadataManager.getKeyTable().get((Object)fromKey);
            if (fromKeyValue == null) {
                LOG.error("Rename key failed for volume:{} bucket:{} fromKey:{} toKey:{}. Key: {} not found.", new Object[]{volumeName, bucketName, fromKeyName, toKeyName, fromKeyName});
                throw new OMException("Key not found", OMException.ResultCodes.KEY_NOT_FOUND);
            }
            if (!fromKeyName.equals(toKeyName)) break block21;
            this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            return;
        }
        try {
            String toKey = this.metadataManager.getOzoneKey(volumeName, bucketName, toKeyName);
            OmKeyInfo toKeyValue = (OmKeyInfo)this.metadataManager.getKeyTable().get((Object)toKey);
            if (toKeyValue != null) {
                LOG.error("Rename key failed for volume:{} bucket:{} fromKey:{} toKey:{}. Key: {} already exists.", new Object[]{volumeName, bucketName, fromKeyName, toKeyName, toKeyName});
                throw new OMException("Key already exists", OMException.ResultCodes.KEY_ALREADY_EXISTS);
            }
            fromKeyValue.setKeyName(toKeyName);
            fromKeyValue.updateModifcationTime();
            DBStore store = this.metadataManager.getStore();
            try (BatchOperation batch = store.initBatchOperation();){
                this.metadataManager.getKeyTable().deleteWithBatch(batch, (Object)fromKey);
                this.metadataManager.getKeyTable().putWithBatch(batch, (Object)toKey, (Object)fromKeyValue);
                store.commitBatchOperation(batch);
            }
        }
        catch (IOException ex) {
            try {
                if (ex instanceof OMException) {
                    throw ex;
                }
                LOG.error("Rename key failed for volume:{} bucket:{} fromKey:{} toKey:{}", new Object[]{volumeName, bucketName, fromKeyName, toKeyName, ex});
                throw new OMException(ex.getMessage(), OMException.ResultCodes.KEY_RENAME_ERROR);
            }
            catch (Throwable throwable) {
                this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                throw throwable;
            }
        }
        this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void deleteKey(OmKeyArgs args) throws IOException {
        OmKeyInfo keyInfo;
        String objectKey;
        String keyName;
        String bucketName;
        String volumeName;
        block7: {
            Preconditions.checkNotNull((Object)args);
            volumeName = args.getVolumeName();
            bucketName = args.getBucketName();
            keyName = args.getKeyName();
            this.metadataManager.getLock().acquireLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            objectKey = this.metadataManager.getOzoneKey(volumeName, bucketName, keyName);
            keyInfo = (OmKeyInfo)this.metadataManager.getKeyTable().get((Object)objectKey);
            if (keyInfo == null) {
                throw new OMException("Key not found", OMException.ResultCodes.KEY_NOT_FOUND);
            }
            if (!this.isKeyEmpty(keyInfo)) break block7;
            this.metadataManager.getKeyTable().delete((Object)objectKey);
            LOG.debug("Key {} deleted from OM DB", (Object)keyName);
            this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            return;
        }
        try {
            RepeatedOmKeyInfo repeatedOmKeyInfo = (RepeatedOmKeyInfo)this.metadataManager.getDeletedTable().get((Object)objectKey);
            repeatedOmKeyInfo = OmUtils.prepareKeyForDelete((OmKeyInfo)keyInfo, (RepeatedOmKeyInfo)repeatedOmKeyInfo, (long)0L, (boolean)false);
            this.metadataManager.getKeyTable().delete((Object)objectKey);
            this.metadataManager.getDeletedTable().put((Object)objectKey, (Object)repeatedOmKeyInfo);
        }
        catch (OMException ex) {
            try {
                throw ex;
                catch (IOException ex2) {
                    LOG.error(String.format("Delete key failed for volume:%s bucket:%s key:%s", volumeName, bucketName, keyName), (Throwable)ex2);
                    throw new OMException(ex2.getMessage(), (Throwable)ex2, OMException.ResultCodes.KEY_DELETION_ERROR);
                }
            }
            catch (Throwable throwable) {
                this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                throw throwable;
            }
        }
        this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        return;
    }

    private boolean isKeyEmpty(OmKeyInfo keyInfo) {
        for (OmKeyLocationInfoGroup keyLocationList : keyInfo.getKeyLocationVersions()) {
            if (keyLocationList.getLocationList().size() == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<OmKeyInfo> listKeys(String volumeName, String bucketName, String startKey, String keyPrefix, int maxKeys) throws IOException {
        Preconditions.checkNotNull((Object)volumeName);
        Preconditions.checkNotNull((Object)bucketName);
        return this.metadataManager.listKeys(volumeName, bucketName, startKey, keyPrefix, maxKeys);
    }

    @Override
    public List<RepeatedOmKeyInfo> listTrash(String volumeName, String bucketName, String startKeyName, String keyPrefix, int maxKeys) throws IOException {
        Preconditions.checkNotNull((Object)volumeName);
        Preconditions.checkNotNull((Object)bucketName);
        Preconditions.checkArgument((maxKeys <= this.listTrashKeysMax ? 1 : 0) != 0, (Object)"The max keys limit specified is not less than the cluster allowed maximum limit.");
        return this.metadataManager.listTrash(volumeName, bucketName, startKeyName, keyPrefix, maxKeys);
    }

    @Override
    public List<BlockGroup> getPendingDeletionKeys(int count) throws IOException {
        return this.metadataManager.getPendingDeletionKeys(count);
    }

    @Override
    public List<BlockGroup> getExpiredOpenKeys() throws IOException {
        return this.metadataManager.getExpiredOpenKeys();
    }

    @Override
    public void deleteExpiredOpenKey(String objectKeyName) throws IOException {
        Preconditions.checkNotNull((Object)objectKeyName);
    }

    @Override
    public OMMetadataManager getMetadataManager() {
        return this.metadataManager;
    }

    @Override
    public BackgroundService getDeletingService() {
        return this.keyDeletingService;
    }

    @Override
    public OmMultipartInfo initiateMultipartUpload(OmKeyArgs omKeyArgs) throws IOException {
        Preconditions.checkNotNull((Object)omKeyArgs);
        String uploadID = UUID.randomUUID().toString() + "-" + UniqueId.next();
        return this.createMultipartInfo(omKeyArgs, uploadID);
    }

    /*
     * Exception decompiling
     */
    private OmMultipartInfo createMultipartInfo(OmKeyArgs keyArgs, String multipartUploadID) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List<OzoneAcl> getAclsForKey(OmKeyArgs keyArgs, OmBucketInfo bucketInfo) {
        OmPrefixInfo prefixInfo;
        List<OmPrefixInfo> prefixList;
        ArrayList<OzoneAcl> acls = new ArrayList<OzoneAcl>();
        if (keyArgs.getAcls() != null) {
            acls.addAll(keyArgs.getAcls());
        }
        if (this.prefixManager != null && !(prefixList = this.prefixManager.getLongestPrefixPath("/" + keyArgs.getVolumeName() + "/" + keyArgs.getBucketName() + "/" + keyArgs.getKeyName())).isEmpty() && (prefixInfo = prefixList.get(prefixList.size() - 1)) != null && OzoneAclUtil.inheritDefaultAcls(acls, (List)prefixInfo.getAcls())) {
            return acls;
        }
        if (bucketInfo != null && OzoneAclUtil.inheritDefaultAcls(acls, (List)bucketInfo.getAcls())) {
            return acls;
        }
        return acls;
    }

    @Override
    public OmMultipartCommitUploadPartInfo commitMultipartUploadPart(OmKeyArgs omKeyArgs, long clientID) throws IOException {
        String partName;
        String bucketName;
        String volumeName;
        block30: {
            Preconditions.checkNotNull((Object)omKeyArgs);
            volumeName = omKeyArgs.getVolumeName();
            bucketName = omKeyArgs.getBucketName();
            String keyName = omKeyArgs.getKeyName();
            String uploadID = omKeyArgs.getMultipartUploadID();
            int partNumber = omKeyArgs.getMultipartUploadPartNumber();
            this.metadataManager.getLock().acquireLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            this.validateS3Bucket(volumeName, bucketName);
            try {
                String multipartKey = this.metadataManager.getMultipartKey(volumeName, bucketName, keyName, uploadID);
                OmMultipartKeyInfo multipartKeyInfo = (OmMultipartKeyInfo)this.metadataManager.getMultipartInfoTable().get((Object)multipartKey);
                String openKey = this.metadataManager.getOpenKey(volumeName, bucketName, keyName, clientID);
                OmKeyInfo keyInfo = (OmKeyInfo)this.metadataManager.getOpenKeyTable().get((Object)openKey);
                keyInfo.setDataSize(omKeyArgs.getDataSize());
                keyInfo.updateLocationInfoList(omKeyArgs.getLocationInfoList());
                partName = this.metadataManager.getOzoneKey(volumeName, bucketName, keyName) + clientID;
                if (multipartKeyInfo == null) {
                    RepeatedOmKeyInfo repeatedOmKeyInfo = (RepeatedOmKeyInfo)this.metadataManager.getDeletedTable().get((Object)partName);
                    repeatedOmKeyInfo = OmUtils.prepareKeyForDelete((OmKeyInfo)keyInfo, (RepeatedOmKeyInfo)repeatedOmKeyInfo, (long)0L, (boolean)false);
                    this.metadataManager.getDeletedTable().put((Object)partName, (Object)repeatedOmKeyInfo);
                    throw new OMException("No such Multipart upload is with specified uploadId " + uploadID, OMException.ResultCodes.NO_SUCH_MULTIPART_UPLOAD_ERROR);
                }
                OzoneManagerProtocolProtos.PartKeyInfo oldPartKeyInfo = multipartKeyInfo.getPartKeyInfo(partNumber);
                OzoneManagerProtocolProtos.PartKeyInfo.Builder partKeyInfo = OzoneManagerProtocolProtos.PartKeyInfo.newBuilder();
                partKeyInfo.setPartName(partName);
                partKeyInfo.setPartNumber(partNumber);
                partKeyInfo.setPartKeyInfo(keyInfo.getProtobuf());
                multipartKeyInfo.addPartKeyInfo(partNumber, partKeyInfo.build());
                if (oldPartKeyInfo == null) {
                    DBStore store = this.metadataManager.getStore();
                    try (BatchOperation batch = store.initBatchOperation();){
                        this.metadataManager.getOpenKeyTable().deleteWithBatch(batch, (Object)openKey);
                        this.metadataManager.getMultipartInfoTable().putWithBatch(batch, (Object)multipartKey, (Object)multipartKeyInfo);
                        store.commitBatchOperation(batch);
                        break block30;
                    }
                }
                DBStore store = this.metadataManager.getStore();
                try (BatchOperation batch = store.initBatchOperation();){
                    OmKeyInfo partKey = OmKeyInfo.getFromProtobuf((OzoneManagerProtocolProtos.KeyInfo)oldPartKeyInfo.getPartKeyInfo());
                    RepeatedOmKeyInfo repeatedOmKeyInfo = (RepeatedOmKeyInfo)this.metadataManager.getDeletedTable().get((Object)oldPartKeyInfo.getPartName());
                    repeatedOmKeyInfo = OmUtils.prepareKeyForDelete((OmKeyInfo)partKey, (RepeatedOmKeyInfo)repeatedOmKeyInfo, (long)0L, (boolean)false);
                    this.metadataManager.getDeletedTable().put((Object)partName, (Object)repeatedOmKeyInfo);
                    this.metadataManager.getDeletedTable().putWithBatch(batch, (Object)oldPartKeyInfo.getPartName(), (Object)repeatedOmKeyInfo);
                    this.metadataManager.getOpenKeyTable().deleteWithBatch(batch, (Object)openKey);
                    this.metadataManager.getMultipartInfoTable().putWithBatch(batch, (Object)multipartKey, (Object)multipartKeyInfo);
                    store.commitBatchOperation(batch);
                }
            }
            catch (IOException ex) {
                try {
                    LOG.error("Upload part Failed: volume:{} bucket:{} key:{} PartNumber: {}", new Object[]{volumeName, bucketName, keyName, partNumber, ex});
                    throw new OMException(ex.getMessage(), OMException.ResultCodes.MULTIPART_UPLOAD_PARTFILE_ERROR);
                }
                catch (Throwable throwable) {
                    this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                    throw throwable;
                }
            }
        }
        this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        return new OmMultipartCommitUploadPartInfo(partName);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public OmMultipartUploadCompleteInfo completeMultipartUpload(OmKeyArgs omKeyArgs, OmMultipartUploadCompleteList multipartUploadList) throws IOException {
        OmMultipartUploadCompleteInfo omMultipartUploadCompleteInfo;
        Preconditions.checkNotNull((Object)omKeyArgs);
        Preconditions.checkNotNull((Object)multipartUploadList);
        String volumeName = omKeyArgs.getVolumeName();
        String bucketName = omKeyArgs.getBucketName();
        String keyName = omKeyArgs.getKeyName();
        String uploadID = omKeyArgs.getMultipartUploadID();
        this.metadataManager.getLock().acquireLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        this.validateS3Bucket(volumeName, bucketName);
        try {
            String multipartKey = this.metadataManager.getMultipartKey(volumeName, bucketName, keyName, uploadID);
            OmMultipartKeyInfo multipartKeyInfo = (OmMultipartKeyInfo)this.metadataManager.getMultipartInfoTable().get((Object)multipartKey);
            if (multipartKeyInfo == null) {
                throw new OMException("Complete Multipart Upload Failed: volume: " + volumeName + "bucket: " + bucketName + "key: " + keyName, OMException.ResultCodes.NO_SUCH_MULTIPART_UPLOAD_ERROR);
            }
            omMultipartUploadCompleteInfo = new OmMultipartUploadCompleteInfo(omKeyArgs.getVolumeName(), omKeyArgs.getBucketName(), omKeyArgs.getKeyName(), DigestUtils.sha256Hex((String)keyName));
        }
        catch (OMException ex) {
            try {
                throw ex;
                catch (IOException ex2) {
                    LOG.error("Complete Multipart Upload Failed: volume: " + volumeName + "bucket: " + bucketName + "key: " + keyName, (Throwable)ex2);
                    throw new OMException(ex2.getMessage(), OMException.ResultCodes.COMPLETE_MULTIPART_UPLOAD_ERROR);
                }
            }
            catch (Throwable throwable) {
                this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                throw throwable;
            }
        }
        this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        return omMultipartUploadCompleteInfo;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void abortMultipartUpload(OmKeyArgs omKeyArgs) throws IOException {
        Preconditions.checkNotNull((Object)omKeyArgs);
        String volumeName = omKeyArgs.getVolumeName();
        String bucketName = omKeyArgs.getBucketName();
        String keyName = omKeyArgs.getKeyName();
        String uploadID = omKeyArgs.getMultipartUploadID();
        Preconditions.checkNotNull((Object)uploadID, (Object)"uploadID cannot be null");
        this.validateS3Bucket(volumeName, bucketName);
        this.metadataManager.getLock().acquireLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        try {
            String multipartKey = this.metadataManager.getMultipartKey(volumeName, bucketName, keyName, uploadID);
            OmMultipartKeyInfo multipartKeyInfo = (OmMultipartKeyInfo)this.metadataManager.getMultipartInfoTable().get((Object)multipartKey);
            OmKeyInfo openKeyInfo = (OmKeyInfo)this.metadataManager.getOpenKeyTable().get((Object)multipartKey);
            if (openKeyInfo == null) {
                LOG.error("Abort Multipart Upload Failed: volume: {} bucket: {} key: {} with error no such uploadID: {}", new Object[]{volumeName, bucketName, keyName, uploadID});
                throw new OMException("Abort Multipart Upload Failed: volume: " + volumeName + "bucket: " + bucketName + "key: " + keyName, OMException.ResultCodes.NO_SUCH_MULTIPART_UPLOAD_ERROR);
            }
            TreeMap partKeyInfoMap = multipartKeyInfo.getPartKeyInfoMap();
            DBStore store = this.metadataManager.getStore();
            try (BatchOperation batch = store.initBatchOperation();){
                for (Map.Entry partKeyInfoEntry : partKeyInfoMap.entrySet()) {
                    OzoneManagerProtocolProtos.PartKeyInfo partKeyInfo = (OzoneManagerProtocolProtos.PartKeyInfo)partKeyInfoEntry.getValue();
                    OmKeyInfo currentKeyPartInfo = OmKeyInfo.getFromProtobuf((OzoneManagerProtocolProtos.KeyInfo)partKeyInfo.getPartKeyInfo());
                    RepeatedOmKeyInfo repeatedOmKeyInfo = (RepeatedOmKeyInfo)this.metadataManager.getDeletedTable().get((Object)partKeyInfo.getPartName());
                    repeatedOmKeyInfo = OmUtils.prepareKeyForDelete((OmKeyInfo)currentKeyPartInfo, (RepeatedOmKeyInfo)repeatedOmKeyInfo, (long)0L, (boolean)false);
                    this.metadataManager.getDeletedTable().putWithBatch(batch, (Object)partKeyInfo.getPartName(), (Object)repeatedOmKeyInfo);
                }
                this.metadataManager.getMultipartInfoTable().deleteWithBatch(batch, (Object)multipartKey);
                this.metadataManager.getOpenKeyTable().deleteWithBatch(batch, (Object)multipartKey);
                store.commitBatchOperation(batch);
            }
        }
        catch (OMException ex) {
            try {
                throw ex;
                catch (IOException ex2) {
                    LOG.error("Abort Multipart Upload Failed: volume: " + volumeName + "bucket: " + bucketName + "key: " + keyName, (Throwable)ex2);
                    throw new OMException(ex2.getMessage(), OMException.ResultCodes.ABORT_MULTIPART_UPLOAD_FAILED);
                }
            }
            catch (Throwable throwable) {
                this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                throw throwable;
            }
        }
        this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
    }

    @Override
    public OmMultipartUploadList listMultipartUploads(String volumeName, String bucketName, String prefix) throws OMException {
        OmMultipartUploadList omMultipartUploadList;
        Preconditions.checkNotNull((Object)volumeName);
        Preconditions.checkNotNull((Object)bucketName);
        this.metadataManager.getLock().acquireReadLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        try {
            Set<String> multipartUploadKeys = this.metadataManager.getMultipartUploadKeys(volumeName, bucketName, prefix);
            List collect = multipartUploadKeys.stream().map(OmMultipartUpload::from).peek(upload -> {
                try {
                    Table<String, OmMultipartKeyInfo> keyInfoTable = this.metadataManager.getMultipartInfoTable();
                    OmMultipartKeyInfo multipartKeyInfo = (OmMultipartKeyInfo)keyInfoTable.get((Object)upload.getDbKey());
                    upload.setCreationTime(Instant.ofEpochMilli(multipartKeyInfo.getCreationTime()));
                    upload.setReplicationType(multipartKeyInfo.getReplicationType());
                    upload.setReplicationFactor(multipartKeyInfo.getReplicationFactor());
                }
                catch (IOException e) {
                    LOG.warn("Open key entry for multipart upload record can be read  {}", (Object)this.metadataManager.getOzoneKey(upload.getVolumeName(), upload.getBucketName(), upload.getKeyName()));
                }
            }).collect(Collectors.toList());
            omMultipartUploadList = new OmMultipartUploadList(collect);
        }
        catch (IOException ex) {
            try {
                LOG.error("List Multipart Uploads Failed: volume: " + volumeName + "bucket: " + bucketName + "prefix: " + prefix, (Throwable)ex);
                throw new OMException(ex.getMessage(), OMException.ResultCodes.LIST_MULTIPART_UPLOAD_PARTS_FAILED);
            }
            catch (Throwable throwable) {
                this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                throw throwable;
            }
        }
        this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        return omMultipartUploadList;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public OmMultipartUploadListParts listParts(String volumeName, String bucketName, String keyName, String uploadID, int partNumberMarker, int maxParts) throws IOException {
        OmMultipartUploadListParts omMultipartUploadListParts;
        Preconditions.checkNotNull((Object)volumeName);
        Preconditions.checkNotNull((Object)bucketName);
        Preconditions.checkNotNull((Object)keyName);
        Preconditions.checkNotNull((Object)uploadID);
        boolean isTruncated = false;
        int nextPartNumberMarker = 0;
        this.metadataManager.getLock().acquireReadLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        try {
            Map.Entry partKeyInfoEntry;
            String multipartKey = this.metadataManager.getMultipartKey(volumeName, bucketName, keyName, uploadID);
            OmMultipartKeyInfo multipartKeyInfo = (OmMultipartKeyInfo)this.metadataManager.getMultipartInfoTable().get((Object)multipartKey);
            if (multipartKeyInfo == null) {
                throw new OMException("No Such Multipart upload exists for this key.", OMException.ResultCodes.NO_SUCH_MULTIPART_UPLOAD_ERROR);
            }
            TreeMap partKeyInfoMap = multipartKeyInfo.getPartKeyInfoMap();
            Iterator partKeyInfoMapIterator = partKeyInfoMap.entrySet().iterator();
            HddsProtos.ReplicationType replicationType = null;
            HddsProtos.ReplicationFactor replicationFactor = null;
            int count = 0;
            ArrayList<OmPartInfo> omPartInfoList = new ArrayList<OmPartInfo>();
            while (count < maxParts && partKeyInfoMapIterator.hasNext()) {
                partKeyInfoEntry = partKeyInfoMapIterator.next();
                nextPartNumberMarker = (Integer)partKeyInfoEntry.getKey();
                if ((Integer)partKeyInfoEntry.getKey() <= partNumberMarker) continue;
                OzoneManagerProtocolProtos.PartKeyInfo partKeyInfo = (OzoneManagerProtocolProtos.PartKeyInfo)partKeyInfoEntry.getValue();
                OmPartInfo omPartInfo = new OmPartInfo(partKeyInfo.getPartNumber(), partKeyInfo.getPartName(), partKeyInfo.getPartKeyInfo().getModificationTime(), partKeyInfo.getPartKeyInfo().getDataSize());
                omPartInfoList.add(omPartInfo);
                replicationType = partKeyInfo.getPartKeyInfo().getType();
                replicationFactor = partKeyInfo.getPartKeyInfo().getFactor();
                ++count;
            }
            if (replicationType == null) {
                OmKeyInfo omKeyInfo = (OmKeyInfo)this.metadataManager.getOpenKeyTable().get((Object)multipartKey);
                if (omKeyInfo == null) {
                    throw new IllegalStateException("Open key is missing for multipart upload " + multipartKey);
                }
                replicationType = omKeyInfo.getType();
                replicationFactor = omKeyInfo.getFactor();
            }
            Preconditions.checkNotNull(replicationType, (Object)"Replication type can't be identified");
            Preconditions.checkNotNull(replicationFactor, (Object)"Replication factor can't be identified");
            if (partKeyInfoMapIterator.hasNext()) {
                partKeyInfoEntry = partKeyInfoMapIterator.next();
                isTruncated = true;
            } else {
                isTruncated = false;
                nextPartNumberMarker = 0;
            }
            OmMultipartUploadListParts omMultipartUploadListParts2 = new OmMultipartUploadListParts(replicationType, replicationFactor, nextPartNumberMarker, isTruncated);
            omMultipartUploadListParts2.addPartList(omPartInfoList);
            omMultipartUploadListParts = omMultipartUploadListParts2;
        }
        catch (OMException ex) {
            try {
                throw ex;
                catch (IOException ex2) {
                    LOG.error("List Multipart Upload Parts Failed: volume: {}, bucket: {}, ,key: {} ", new Object[]{volumeName, bucketName, keyName, ex2});
                    throw new OMException(ex2.getMessage(), OMException.ResultCodes.LIST_MULTIPART_UPLOAD_PARTS_FAILED);
                }
            }
            catch (Throwable throwable) {
                this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                throw throwable;
            }
        }
        this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        return omMultipartUploadListParts;
    }

    @Override
    public boolean addAcl(OzoneObj obj, OzoneAcl acl) throws IOException {
        this.validateOzoneObj(obj);
        String volume = obj.getVolumeName();
        String bucket = obj.getBucketName();
        String keyName = obj.getKeyName();
        boolean changed = false;
        this.metadataManager.getLock().acquireLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volume, bucket});
        try {
            this.validateBucket(volume, bucket);
            String objectKey = this.metadataManager.getOzoneKey(volume, bucket, keyName);
            OmKeyInfo keyInfo = (OmKeyInfo)this.metadataManager.getKeyTable().get((Object)objectKey);
            if (keyInfo == null) {
                throw new OMException("Key not found. Key:" + objectKey, OMException.ResultCodes.KEY_NOT_FOUND);
            }
            if (keyInfo.getAcls() == null) {
                keyInfo.setAcls(new ArrayList());
            }
            if (changed = keyInfo.addAcl(acl)) {
                this.metadataManager.getKeyTable().put((Object)objectKey, (Object)keyInfo);
            }
        }
        catch (IOException ex) {
            try {
                if (!(ex instanceof OMException)) {
                    LOG.error("Add acl operation failed for key:{}/{}/{}", new Object[]{volume, bucket, keyName, ex});
                }
                throw ex;
            }
            catch (Throwable throwable) {
                this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volume, bucket});
                throw throwable;
            }
        }
        this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volume, bucket});
        return changed;
    }

    @Override
    public boolean removeAcl(OzoneObj obj, OzoneAcl acl) throws IOException {
        this.validateOzoneObj(obj);
        String volume = obj.getVolumeName();
        String bucket = obj.getBucketName();
        String keyName = obj.getKeyName();
        boolean changed = false;
        this.metadataManager.getLock().acquireLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volume, bucket});
        try {
            this.validateBucket(volume, bucket);
            String objectKey = this.metadataManager.getOzoneKey(volume, bucket, keyName);
            OmKeyInfo keyInfo = (OmKeyInfo)this.metadataManager.getKeyTable().get((Object)objectKey);
            if (keyInfo == null) {
                throw new OMException("Key not found. Key:" + objectKey, OMException.ResultCodes.KEY_NOT_FOUND);
            }
            changed = keyInfo.removeAcl(acl);
            if (changed) {
                this.metadataManager.getKeyTable().put((Object)objectKey, (Object)keyInfo);
            }
        }
        catch (IOException ex) {
            try {
                if (!(ex instanceof OMException)) {
                    LOG.error("Remove acl operation failed for key:{}/{}/{}", new Object[]{volume, bucket, keyName, ex});
                }
                throw ex;
            }
            catch (Throwable throwable) {
                this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volume, bucket});
                throw throwable;
            }
        }
        this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volume, bucket});
        return changed;
    }

    @Override
    public boolean setAcl(OzoneObj obj, List<OzoneAcl> acls) throws IOException {
        this.validateOzoneObj(obj);
        String volume = obj.getVolumeName();
        String bucket = obj.getBucketName();
        String keyName = obj.getKeyName();
        boolean changed = false;
        this.metadataManager.getLock().acquireLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volume, bucket});
        try {
            this.validateBucket(volume, bucket);
            String objectKey = this.metadataManager.getOzoneKey(volume, bucket, keyName);
            OmKeyInfo keyInfo = (OmKeyInfo)this.metadataManager.getKeyTable().get((Object)objectKey);
            if (keyInfo == null) {
                throw new OMException("Key not found. Key:" + objectKey, OMException.ResultCodes.KEY_NOT_FOUND);
            }
            changed = keyInfo.setAcls(acls);
            if (changed) {
                this.metadataManager.getKeyTable().put((Object)objectKey, (Object)keyInfo);
            }
        }
        catch (IOException ex) {
            try {
                if (!(ex instanceof OMException)) {
                    LOG.error("Set acl operation failed for key:{}/{}/{}", new Object[]{volume, bucket, keyName, ex});
                }
                throw ex;
            }
            catch (Throwable throwable) {
                this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volume, bucket});
                throw throwable;
            }
        }
        this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volume, bucket});
        return changed;
    }

    @Override
    public List<OzoneAcl> getAcl(OzoneObj obj) throws IOException {
        List list;
        this.validateOzoneObj(obj);
        String volume = obj.getVolumeName();
        String bucket = obj.getBucketName();
        String keyName = obj.getKeyName();
        this.metadataManager.getLock().acquireReadLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volume, bucket});
        try {
            this.validateBucket(volume, bucket);
            String objectKey = this.metadataManager.getOzoneKey(volume, bucket, keyName);
            OmKeyInfo keyInfo = (OmKeyInfo)this.metadataManager.getKeyTable().get((Object)objectKey);
            if (keyInfo == null) {
                throw new OMException("Key not found. Key:" + objectKey, OMException.ResultCodes.KEY_NOT_FOUND);
            }
            list = keyInfo.getAcls();
        }
        catch (IOException ex) {
            try {
                if (!(ex instanceof OMException)) {
                    LOG.error("Get acl operation failed for key:{}/{}/{}", new Object[]{volume, bucket, keyName, ex});
                }
                throw ex;
            }
            catch (Throwable throwable) {
                this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volume, bucket});
                throw throwable;
            }
        }
        this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volume, bucket});
        return list;
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean checkAccess(OzoneObj ozObject, RequestContext context) throws OMException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void validateOzoneObj(OzoneObj obj) throws OMException {
        Objects.requireNonNull(obj);
        if (!obj.getResourceType().equals((Object)OzoneObj.ResourceType.KEY)) {
            throw new IllegalArgumentException("Unexpected argument passed to KeyManager. OzoneObj type:" + obj.getResourceType());
        }
        String volume = obj.getVolumeName();
        String bucket = obj.getBucketName();
        String keyName = obj.getKeyName();
        if (Strings.isNullOrEmpty((String)volume)) {
            throw new OMException("Volume name is required.", OMException.ResultCodes.VOLUME_NOT_FOUND);
        }
        if (Strings.isNullOrEmpty((String)bucket)) {
            throw new OMException("Bucket name is required.", OMException.ResultCodes.BUCKET_NOT_FOUND);
        }
        if (Strings.isNullOrEmpty((String)keyName)) {
            throw new OMException("Key name is required.", OMException.ResultCodes.KEY_NOT_FOUND);
        }
    }

    @Override
    public OzoneFileStatus getFileStatus(OmKeyArgs args) throws IOException {
        Preconditions.checkNotNull((Object)args, (Object)"Key args can not be null");
        String volumeName = args.getVolumeName();
        String bucketName = args.getBucketName();
        String keyName = args.getKeyName();
        return this.getOzoneFileStatus(volumeName, bucketName, keyName, args.getRefreshPipeline(), false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OzoneFileStatus getOzoneFileStatus(String volumeName, String bucketName, String keyName, boolean refreshPipeline, boolean sortDatanodes, String clientAddress) throws IOException {
        OmKeyInfo fileKeyInfo;
        block17: {
            block16: {
                OzoneFileStatus ozoneFileStatus;
                fileKeyInfo = null;
                this.metadataManager.getLock().acquireReadLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                try {
                    if (keyName.length() != 0) break block16;
                    this.validateBucket(volumeName, bucketName);
                    ozoneFileStatus = new OzoneFileStatus();
                }
                catch (Throwable throwable) {
                    this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                    if (fileKeyInfo != null) {
                        if (refreshPipeline) {
                            this.refreshPipeline(fileKeyInfo);
                        }
                        if (sortDatanodes) {
                            this.sortDatanodeInPipeline(fileKeyInfo, clientAddress);
                        }
                        return new OzoneFileStatus(fileKeyInfo, this.scmBlockSize, false);
                    }
                    throw throwable;
                }
                this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                if (fileKeyInfo != null) {
                    if (refreshPipeline) {
                        this.refreshPipeline(fileKeyInfo);
                    }
                    if (sortDatanodes) {
                        this.sortDatanodeInPipeline(fileKeyInfo, clientAddress);
                    }
                    return new OzoneFileStatus(fileKeyInfo, this.scmBlockSize, false);
                }
                return ozoneFileStatus;
            }
            String fileKeyBytes = this.metadataManager.getOzoneKey(volumeName, bucketName, keyName);
            fileKeyInfo = (OmKeyInfo)this.metadataManager.getKeyTable().get((Object)fileKeyBytes);
            if (fileKeyInfo != null) break block17;
            String dirKey = OzoneFSUtils.addTrailingSlashIfNeeded((String)keyName);
            String dirKeyBytes = this.metadataManager.getOzoneKey(volumeName, bucketName, dirKey);
            OmKeyInfo dirKeyInfo = (OmKeyInfo)this.metadataManager.getKeyTable().get((Object)dirKeyBytes);
            if (dirKeyInfo == null) break block17;
            OzoneFileStatus ozoneFileStatus = new OzoneFileStatus(dirKeyInfo, this.scmBlockSize, true);
            this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            if (fileKeyInfo != null) {
                if (refreshPipeline) {
                    this.refreshPipeline(fileKeyInfo);
                }
                if (sortDatanodes) {
                    this.sortDatanodeInPipeline(fileKeyInfo, clientAddress);
                }
                return new OzoneFileStatus(fileKeyInfo, this.scmBlockSize, false);
            }
            return ozoneFileStatus;
        }
        this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        if (fileKeyInfo != null) {
            if (refreshPipeline) {
                this.refreshPipeline(fileKeyInfo);
            }
            if (sortDatanodes) {
                this.sortDatanodeInPipeline(fileKeyInfo, clientAddress);
            }
            return new OzoneFileStatus(fileKeyInfo, this.scmBlockSize, false);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Unable to get file status for the key: volume: {}, bucket: {}, key: {}, with error: No such file exists.", new Object[]{volumeName, bucketName, keyName});
        }
        throw new OMException("Unable to get file status: volume: " + volumeName + " bucket: " + bucketName + " key: " + keyName, OMException.ResultCodes.FILE_NOT_FOUND);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createDirectory(OmKeyArgs args) throws IOException {
        String keyName;
        String bucketName;
        String volumeName;
        block5: {
            block4: {
                Preconditions.checkNotNull((Object)args, (Object)"Key args can not be null");
                volumeName = args.getVolumeName();
                bucketName = args.getBucketName();
                keyName = args.getKeyName();
                this.metadataManager.getLock().acquireLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                try {
                    if (keyName.length() != 0) break block4;
                }
                catch (Throwable throwable) {
                    this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                    throw throwable;
                }
                this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                return;
            }
            Path keyPath = Paths.get(keyName, new String[0]);
            OzoneFileStatus status = this.verifyNoFilesInPath(volumeName, bucketName, keyPath, false);
            if (status == null || !status.getTrimmedName().equals(keyName)) break block5;
            this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            return;
        }
        OmKeyInfo dirDbKeyInfo = this.createDirectoryKey(volumeName, bucketName, keyName, args.getAcls());
        String dirDbKey = this.metadataManager.getOzoneKey(volumeName, bucketName, dirDbKeyInfo.getKeyName());
        this.metadataManager.getKeyTable().put((Object)dirDbKey, (Object)dirDbKeyInfo);
        this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
    }

    private OmKeyInfo createDirectoryKey(String volumeName, String bucketName, String keyName, List<OzoneAcl> acls) throws IOException {
        OmBucketInfo bucketInfo = this.getBucketInfo(volumeName, bucketName);
        String dir = OzoneFSUtils.addTrailingSlashIfNeeded((String)keyName);
        FileEncryptionInfo encInfo = this.getFileEncryptionInfo(bucketInfo);
        return new OmKeyInfo.Builder().setVolumeName(volumeName).setBucketName(bucketName).setKeyName(dir).setOmKeyLocationInfos(Collections.singletonList(new OmKeyLocationInfoGroup(0L, new ArrayList()))).setCreationTime(Time.now()).setModificationTime(Time.now()).setDataSize(0L).setReplicationType(HddsProtos.ReplicationType.RATIS).setReplicationFactor(HddsProtos.ReplicationFactor.ONE).setFileEncryptionInfo(encInfo).setAcls(acls).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OpenKeySession createFile(OmKeyArgs args, boolean isOverWrite, boolean isRecursive) throws IOException {
        OpenKeySession keySession;
        Preconditions.checkNotNull((Object)args, (Object)"Key args can not be null");
        String volumeName = args.getVolumeName();
        String bucketName = args.getBucketName();
        String keyName = args.getKeyName();
        this.metadataManager.getLock().acquireLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        try {
            block6: {
                try {
                    OzoneFileStatus fileStatus = this.getFileStatus(args);
                    if (fileStatus.isDirectory()) {
                        throw new OMException("Can not write to directory: " + keyName, OMException.ResultCodes.NOT_A_FILE);
                    }
                    if (fileStatus.isFile() && !isOverWrite) {
                        throw new OMException("File " + keyName + " already exists", OMException.ResultCodes.FILE_ALREADY_EXISTS);
                    }
                }
                catch (OMException ex) {
                    if (ex.getResult() == OMException.ResultCodes.FILE_NOT_FOUND) break block6;
                    throw ex;
                }
            }
            this.verifyNoFilesInPath(volumeName, bucketName, Paths.get(keyName, new String[0]).getParent(), !isRecursive);
            keySession = this.openKey(args);
        }
        catch (Throwable throwable) {
            this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            throw throwable;
        }
        this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        return keySession;
    }

    @Override
    public OmKeyInfo lookupFile(OmKeyArgs args, String clientAddress) throws IOException {
        Preconditions.checkNotNull((Object)args, (Object)"Key args can not be null");
        String volumeName = args.getVolumeName();
        String bucketName = args.getBucketName();
        String keyName = args.getKeyName();
        OzoneFileStatus fileStatus = this.getOzoneFileStatus(volumeName, bucketName, keyName, args.getRefreshPipeline(), args.getSortDatanodes(), clientAddress);
        if (fileStatus.isFile()) {
            return fileStatus.getKeyInfo();
        }
        throw new OMException("Can not write to directory: " + keyName, OMException.ResultCodes.NOT_A_FILE);
    }

    private void listStatusFindKeyInTableCache(Iterator<Map.Entry<CacheKey<String>, CacheValue<OmKeyInfo>>> cacheIter, String keyArgs, String startCacheKey, boolean recursive, TreeMap<String, OzoneFileStatus> cacheKeyMap, Set<String> deletedKeySet) {
        while (cacheIter.hasNext()) {
            Map.Entry<CacheKey<String>, CacheValue<OmKeyInfo>> entry = cacheIter.next();
            String cacheKey = (String)entry.getKey().getCacheKey();
            if (cacheKey.equals(keyArgs)) continue;
            OmKeyInfo cacheOmKeyInfo = (OmKeyInfo)entry.getValue().getCacheValue();
            if (cacheOmKeyInfo != null) {
                String remainingKey;
                if (!cacheKey.startsWith(startCacheKey) || cacheKey.compareTo(startCacheKey) < 0 || !recursive && (remainingKey = StringUtils.stripEnd((String)cacheKey.substring(startCacheKey.length()), (String)"/")).contains("/")) continue;
                OzoneFileStatus fileStatus = new OzoneFileStatus(cacheOmKeyInfo, this.scmBlockSize, !OzoneFSUtils.isFile((String)cacheKey));
                cacheKeyMap.put(cacheKey, fileStatus);
                continue;
            }
            deletedKeySet.add(cacheKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public List<OzoneFileStatus> listStatus(OmKeyArgs args, boolean recursive, String startKey, long numEntries) throws IOException {
        block17: {
            Preconditions.checkNotNull((Object)args, (Object)"Key args can not be null");
            fileStatusList = new ArrayList<OzoneFileStatus>();
            if (numEntries <= 0L) {
                return fileStatusList;
            }
            volumeName = args.getVolumeName();
            bucketName = args.getBucketName();
            keyName = args.getKeyName();
            cacheKeyMap = new TreeMap<String, OzoneFileStatus>();
            deletedKeySet = new TreeSet<String>();
            this.metadataManager.getLock().acquireReadLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            if (!Strings.isNullOrEmpty((String)startKey)) ** GOTO lbl23
            fileStatus = this.getFileStatus(args);
            if (!fileStatus.isFile()) break block17;
            var13_12 = Collections.singletonList(fileStatus);
            this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            return var13_12;
        }
        try {
            startKey = OzoneFSUtils.addTrailingSlashIfNeeded((String)keyName);
lbl23:
            // 2 sources

            keyTable = this.metadataManager.getKeyTable();
            cacheIter = keyTable.cacheIterator();
            startCacheKey = "/" + volumeName + "/" + bucketName + "/" + (startKey.equals("/") != false ? "" : startKey);
            keyArgs = OzoneFSUtils.addTrailingSlashIfNeeded((String)this.metadataManager.getOzoneKey(volumeName, bucketName, keyName));
            this.listStatusFindKeyInTableCache(cacheIter, keyArgs, startCacheKey, recursive, cacheKeyMap, deletedKeySet);
            seekKeyInDb = this.metadataManager.getOzoneKey(volumeName, bucketName, startKey);
            iterator = keyTable.iterator();
            iterator.seek((Object)seekKeyInDb);
            countEntries = 0;
            if (iterator.hasNext()) {
                if (((String)iterator.key()).equals(keyArgs)) {
                    iterator.next();
                }
                while (iterator.hasNext() && numEntries - (long)countEntries > 0L) {
                    entryInDb = (String)iterator.key();
                    omKeyInfo = (OmKeyInfo)((Table.KeyValue)iterator.value()).getValue();
                    if (!entryInDb.startsWith(keyArgs)) break;
                    entryKeyName = omKeyInfo.getKeyName();
                    if (recursive) {
                        if (!deletedKeySet.contains(entryInDb)) {
                            cacheKeyMap.put(entryInDb, new OzoneFileStatus(omKeyInfo, this.scmBlockSize, OzoneFSUtils.isFile((String)entryKeyName) == false));
                            ++countEntries;
                        }
                        iterator.next();
                        continue;
                    }
                    immediateChild = OzoneFSUtils.getImmediateChild((String)entryKeyName, (String)keyName);
                    isFile = OzoneFSUtils.isFile((String)immediateChild);
                    if (isFile) {
                        if (!deletedKeySet.contains(entryInDb)) {
                            cacheKeyMap.put(entryInDb, new OzoneFileStatus(omKeyInfo, this.scmBlockSize, isFile == false));
                            ++countEntries;
                        }
                        iterator.next();
                        continue;
                    }
                    if (!deletedKeySet.contains(entryInDb)) {
                        if (!entryKeyName.equals(immediateChild)) {
                            fakeDirEntry = this.createDirectoryKey(omKeyInfo.getVolumeName(), omKeyInfo.getBucketName(), immediateChild, omKeyInfo.getAcls());
                            cacheKeyMap.put(entryInDb, new OzoneFileStatus(fakeDirEntry, this.scmBlockSize, true));
                        } else {
                            cacheKeyMap.put(entryInDb, new OzoneFileStatus(omKeyInfo, 0L, true));
                        }
                        ++countEntries;
                    }
                    iterator.seek((Object)this.getNextGreaterString(volumeName, bucketName, immediateChild));
                }
            }
            countEntries = 0;
            for (Map.Entry<String, OzoneFileStatus> entry : cacheKeyMap.entrySet()) {
                fileStatusList.add(entry.getValue());
                if ((long)(++countEntries) < numEntries) continue;
                break;
            }
            cacheKeyMap.clear();
            deletedKeySet.clear();
        }
        catch (Throwable var25_25) {
            this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            throw var25_25;
        }
        this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        if (args.getRefreshPipeline()) {
            for (OzoneFileStatus fileStatus : fileStatusList) {
                this.refreshPipeline(fileStatus.getKeyInfo());
            }
        }
        return fileStatusList;
    }

    private String getNextGreaterString(String volumeName, String bucketName, String keyPrefix) throws IOException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)keyPrefix) ? 1 : 0) != 0, (Object)"Key prefix is null or empty");
        CodecRegistry codecRegistry = ((RDBStore)this.metadataManager.getStore()).getCodecRegistry();
        byte[] keyPrefixInBytes = codecRegistry.asRawData((Object)keyPrefix);
        int n = keyPrefixInBytes.length - 1;
        keyPrefixInBytes[n] = (byte)(keyPrefixInBytes[n] + 1);
        String nextPrefix = (String)codecRegistry.asObject(keyPrefixInBytes, String.class);
        return this.metadataManager.getOzoneKey(volumeName, bucketName, nextPrefix);
    }

    private OzoneFileStatus verifyNoFilesInPath(String volumeName, String bucketName, Path path, boolean directoryMustExist) throws IOException {
        OmKeyArgs.Builder argsBuilder = new OmKeyArgs.Builder().setVolumeName(volumeName).setBucketName(bucketName);
        while (path != null) {
            block6: {
                String keyName = path.toString();
                try {
                    OzoneFileStatus fileStatus = this.getFileStatus(argsBuilder.setKeyName(keyName).build());
                    if (fileStatus.isFile()) {
                        LOG.error("Unable to create directory (File already exists): volume: {} bucket: {} key: {}", new Object[]{volumeName, bucketName, keyName});
                        throw new OMException("Unable to create directory at : volume: " + volumeName + "bucket: " + bucketName + "key: " + keyName, OMException.ResultCodes.FILE_ALREADY_EXISTS);
                    }
                    if (fileStatus.isDirectory()) {
                        return fileStatus;
                    }
                }
                catch (OMException ex) {
                    if (ex.getResult() != OMException.ResultCodes.FILE_NOT_FOUND) {
                        throw ex;
                    }
                    if (ex.getResult() != OMException.ResultCodes.FILE_NOT_FOUND || !directoryMustExist) break block6;
                    throw new OMException("Parent directory does not exist", ex.getCause(), OMException.ResultCodes.DIRECTORY_NOT_FOUND);
                }
            }
            path = path.getParent();
        }
        return null;
    }

    private FileEncryptionInfo getFileEncryptionInfo(OmBucketInfo bucketInfo) throws IOException {
        FileEncryptionInfo encInfo = null;
        BucketEncryptionKeyInfo ezInfo = bucketInfo.getEncryptionKeyInfo();
        if (ezInfo != null) {
            if (this.getKMSProvider() == null) {
                throw new OMException("Invalid KMS provider, check configuration hadoop.security.key.provider.path", OMException.ResultCodes.INVALID_KMS_PROVIDER);
            }
            String ezKeyName = ezInfo.getKeyName();
            KeyProviderCryptoExtension.EncryptedKeyVersion edek = this.generateEDEK(ezKeyName);
            encInfo = new FileEncryptionInfo(ezInfo.getSuite(), ezInfo.getVersion(), edek.getEncryptedKeyVersion().getMaterial(), edek.getEncryptedKeyIv(), ezKeyName, edek.getEncryptionKeyVersionName());
        }
        return encInfo;
    }

    private void sortDatanodeInPipeline(OmKeyInfo keyInfo, String clientMachine) {
        if (keyInfo != null && clientMachine != null && !clientMachine.isEmpty()) {
            for (OmKeyLocationInfoGroup key : keyInfo.getKeyLocationVersions()) {
                key.getLocationList().forEach(k -> {
                    List nodes = k.getPipeline().getNodes();
                    if (nodes == null || nodes.isEmpty()) {
                        LOG.warn("Datanodes for pipeline {} is empty", (Object)k.getPipeline().getId().toString());
                        return;
                    }
                    ArrayList nodeList = new ArrayList();
                    nodes.stream().forEach(node -> nodeList.add(node.getUuidString()));
                    try {
                        List sortedNodes = this.scmClient.getBlockClient().sortDatanodes(nodeList, clientMachine);
                        k.getPipeline().setNodesInOrder(sortedNodes);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Sort datanodes {} for client {}, return {}", new Object[]{nodes, clientMachine, sortedNodes});
                        }
                    }
                    catch (IOException e) {
                        LOG.warn("Unable to sort datanodes based on distance to client, volume=" + keyInfo.getVolumeName() + ", bucket=" + keyInfo.getBucketName() + ", key=" + keyInfo.getKeyName() + ", client=" + clientMachine + ", datanodes=" + nodes.toString() + ", exception=" + e.getMessage());
                    }
                });
            }
        }
    }
}

