/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.codec;

import com.google.common.base.Preconditions;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

public class OmKeyInfoCodec
implements Codec<OmKeyInfo> {
    public byte[] toPersistedFormat(OmKeyInfo object) throws IOException {
        Preconditions.checkNotNull((Object)object, (Object)"Null object can't be converted to byte array.");
        return object.getProtobuf().toByteArray();
    }

    public OmKeyInfo fromPersistedFormat(byte[] rawData) throws IOException {
        Preconditions.checkNotNull((Object)rawData, (Object)"Null byte array can't converted to real object.");
        try {
            return OmKeyInfo.getFromProtobuf((OzoneManagerProtocolProtos.KeyInfo)OzoneManagerProtocolProtos.KeyInfo.parseFrom((byte[])rawData));
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException("Can't encode the the raw data from the byte array", e);
        }
    }

    public OmKeyInfo copyObject(OmKeyInfo omKeyInfo) {
        return omKeyInfo.copyObject();
    }
}

