/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.ha;

import com.google.common.base.Preconditions;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.OzoneIllegalArgumentException;
import org.apache.hadoop.ozone.om.ha.OMNodeDetails;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMHANodeDetails {
    private static String[] genericConfigKeys = new String[]{"ozone.om.http-address", "ozone.om.https-address", "ozone.om.http-bind-host", "ozone.om.https-bind-host", "ozone.om.db.dirs", "ozone.om.address"};
    public static final Logger LOG = LoggerFactory.getLogger(OMHANodeDetails.class);
    private final OMNodeDetails localNodeDetails;
    private final List<OMNodeDetails> peerNodeDetails;

    public OMHANodeDetails(OMNodeDetails localNodeDetails, List<OMNodeDetails> peerNodeDetails) {
        this.localNodeDetails = localNodeDetails;
        this.peerNodeDetails = peerNodeDetails;
    }

    public OMNodeDetails getLocalNodeDetails() {
        return this.localNodeDetails;
    }

    public List<OMNodeDetails> getPeerNodeDetails() {
        return this.peerNodeDetails;
    }

    public static OMHANodeDetails loadOMHAConfig(OzoneConfiguration conf) {
        Collection<String> omServiceIds;
        InetSocketAddress localRpcAddress = null;
        String localOMServiceId = null;
        String localOMNodeId = null;
        int localRatisPort = 0;
        localOMServiceId = conf.getTrimmed("ozone.om.internal.service.id");
        if (localOMServiceId == null) {
            LOG.info("{} is not defined, falling back to {} to find serviceID for OzoneManager if it is HA enabled cluster", (Object)"ozone.om.internal.service.id", (Object)"ozone.om.service.ids");
            omServiceIds = conf.getTrimmedStringCollection("ozone.om.service.ids");
        } else {
            LOG.info("ServiceID for OzoneManager is {}", (Object)localOMServiceId);
            omServiceIds = Collections.singletonList(localOMServiceId);
        }
        String knownOMNodeId = conf.get("ozone.om.node.id");
        int found = 0;
        boolean isOMAddressSet = false;
        for (String serviceId : omServiceIds) {
            Collection omNodeIds = OmUtils.getOMNodeIds((ConfigurationSource)conf, (String)serviceId);
            if (omNodeIds.size() == 0) {
                OMHANodeDetails.throwConfException("Configuration does not have any value set for %s for the service %s. List of OM Node ID's should be specified for an OM service", "ozone.om.nodes", serviceId);
                return null;
            }
            ArrayList<OMNodeDetails> peerNodesList = new ArrayList<OMNodeDetails>();
            for (String nodeId : omNodeIds) {
                boolean isPeer = knownOMNodeId != null && !knownOMNodeId.equals(nodeId);
                String rpcAddrKey = OmUtils.addKeySuffixes((String)"ozone.om.address", (String[])new String[]{serviceId, nodeId});
                String rpcAddrStr = OmUtils.getOmRpcAddress((ConfigurationSource)conf, (String)rpcAddrKey);
                if (rpcAddrStr == null || rpcAddrStr.isEmpty()) {
                    OMHANodeDetails.throwConfException("Configuration does not have any value set for %s. OM RPC Address should be set for all nodes in an OM service.", rpcAddrKey);
                    return null;
                }
                isOMAddressSet = true;
                String ratisPortKey = OmUtils.addKeySuffixes((String)"ozone.om.ratis.port", (String[])new String[]{serviceId, nodeId});
                int ratisPort = conf.getInt(ratisPortKey, 9872);
                InetSocketAddress addr = null;
                try {
                    addr = NetUtils.createSocketAddr((String)rpcAddrStr);
                }
                catch (Exception e) {
                    LOG.error("Couldn't create socket address for OM {} : {}", new Object[]{nodeId, rpcAddrStr, e});
                    throw e;
                }
                if (addr.isUnresolved()) {
                    LOG.error("Address for OM {} : {} couldn't be resolved. Proceeding with unresolved host to create Ratis ring.", (Object)nodeId, (Object)rpcAddrStr);
                }
                if (!addr.isUnresolved() && !isPeer && OmUtils.isAddressLocal((InetSocketAddress)addr)) {
                    localRpcAddress = addr;
                    localOMServiceId = serviceId;
                    localOMNodeId = nodeId;
                    localRatisPort = ratisPort;
                    ++found;
                    continue;
                }
                peerNodesList.add(OMHANodeDetails.getHAOMNodeDetails(conf, serviceId, nodeId, addr, ratisPort));
            }
            if (found == 1) {
                LOG.debug("Found one matching OM address with service ID: {} and node ID: {}", (Object)localOMServiceId, localOMNodeId);
                LOG.info("Found matching OM address with OMServiceId: {}, OMNodeId: {}, RPC Address: {} and Ratis port: {}", new Object[]{localOMServiceId, localOMNodeId, NetUtils.getHostPortString(localRpcAddress), localRatisPort});
                OMHANodeDetails.setOMNodeSpecificConfigs(conf, localOMServiceId, localOMNodeId);
                return new OMHANodeDetails(OMHANodeDetails.getHAOMNodeDetails(conf, localOMServiceId, localOMNodeId, localRpcAddress, localRatisPort), peerNodesList);
            }
            if (found <= true) continue;
            OMHANodeDetails.throwConfException("Configuration has multiple %s addresses that match local node's address. Please configure the system with %s and %s", "ozone.om.address", "ozone.om.service.ids", "ozone.om.address");
            return null;
        }
        if (!isOMAddressSet) {
            InetSocketAddress omAddress = OmUtils.getOmAddress((ConfigurationSource)conf);
            int ratisPort = conf.getInt("ozone.om.ratis.port", 9872);
            LOG.info("Configuration either no {} set. Falling back to the default OM address {}", (Object)"ozone.om.address", (Object)omAddress);
            return new OMHANodeDetails(OMHANodeDetails.getOMNodeDetails(conf, null, null, omAddress, ratisPort), new ArrayList<OMNodeDetails>());
        }
        OMHANodeDetails.throwConfException("Configuration has no %s address that matches local node's address.", "ozone.om.address");
        return null;
    }

    public static OMNodeDetails getOMNodeDetails(OzoneConfiguration conf, String serviceId, String nodeId, InetSocketAddress rpcAddress, int ratisPort) {
        if (serviceId == null) {
            serviceId = "omServiceIdDefault";
            LOG.info("OM Service ID is not set. Setting it to the default ID: {}", (Object)serviceId);
        }
        String httpAddr = OmUtils.getHttpAddressForOMPeerNode((ConfigurationSource)conf, null, null, (String)rpcAddress.getHostName());
        String httpsAddr = OmUtils.getHttpsAddressForOMPeerNode((ConfigurationSource)conf, null, null, (String)rpcAddress.getHostName());
        return new OMNodeDetails.Builder().setOMServiceId(serviceId).setOMNodeId(nodeId).setRpcAddress(rpcAddress).setRatisPort(ratisPort).setHttpAddress(httpAddr).setHttpsAddress(httpsAddr).build();
    }

    public static OMNodeDetails getHAOMNodeDetails(OzoneConfiguration conf, String serviceId, String nodeId, InetSocketAddress rpcAddress, int ratisPort) {
        Preconditions.checkNotNull((Object)serviceId);
        Preconditions.checkNotNull((Object)nodeId);
        String httpAddr = OmUtils.getHttpAddressForOMPeerNode((ConfigurationSource)conf, (String)serviceId, (String)nodeId, (String)rpcAddress.getHostName());
        String httpsAddr = OmUtils.getHttpsAddressForOMPeerNode((ConfigurationSource)conf, (String)serviceId, (String)nodeId, (String)rpcAddress.getHostName());
        return new OMNodeDetails.Builder().setOMServiceId(serviceId).setOMNodeId(nodeId).setRpcAddress(rpcAddress).setRatisPort(ratisPort).setHttpAddress(httpAddr).setHttpsAddress(httpsAddr).build();
    }

    private static void setOMNodeSpecificConfigs(OzoneConfiguration ozoneConfiguration, String omServiceId, String omNodeId) {
        for (String confKey : genericConfigKeys) {
            String confValue = OmUtils.getConfSuffixedWithOMNodeId((ConfigurationSource)ozoneConfiguration, (String)confKey, (String)omServiceId, (String)omNodeId);
            if (confValue == null) continue;
            LOG.info("Setting configuration key {} with value of key {}: {}", new Object[]{confKey, OmUtils.addKeySuffixes((String)confKey, (String[])new String[]{omNodeId}), confValue});
            ozoneConfiguration.set(confKey, confValue);
        }
    }

    private static void throwConfException(String message, String ... arguments) throws IllegalArgumentException {
        String exceptionMsg = String.format(message, arguments);
        LOG.error(exceptionMsg);
        throw new OzoneIllegalArgumentException(exceptionMsg);
    }
}

