/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.ratis;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Objects;
import org.apache.hadoop.hdds.StringUtils;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.ratis.server.protocol.TermIndex;

public final class OMTransactionInfo {
    private long term;
    private long transactionIndex;

    private OMTransactionInfo(String transactionInfo) {
        String[] tInfo = transactionInfo.split("#");
        Preconditions.checkState((tInfo.length == 2 ? 1 : 0) != 0, (Object)"Incorrect TransactionInfo value");
        this.term = Long.parseLong(tInfo[0]);
        this.transactionIndex = Long.parseLong(tInfo[1]);
    }

    private OMTransactionInfo(long currentTerm, long transactionIndex) {
        this.term = currentTerm;
        this.transactionIndex = transactionIndex;
    }

    public long getTerm() {
        return this.term;
    }

    public long getTransactionIndex() {
        return this.transactionIndex;
    }

    public TermIndex getTermIndex() {
        return TermIndex.newTermIndex((long)this.term, (long)this.transactionIndex);
    }

    private String generateTransactionInfo() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.term);
        stringBuilder.append("#");
        stringBuilder.append(this.transactionIndex);
        return stringBuilder.toString();
    }

    public byte[] convertToByteArray() {
        return StringUtils.string2Bytes((String)this.generateTransactionInfo());
    }

    public static OMTransactionInfo getFromByteArray(byte[] bytes) {
        String tInfo = StringUtils.bytes2String((byte[])bytes);
        return new OMTransactionInfo(tInfo);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OMTransactionInfo that = (OMTransactionInfo)o;
        return this.term == that.term && this.transactionIndex == that.transactionIndex;
    }

    public int hashCode() {
        return Objects.hash(this.term, this.transactionIndex);
    }

    public static OMTransactionInfo readTransactionInfo(OMMetadataManager metadataManager) throws IOException {
        return (OMTransactionInfo)metadataManager.getTransactionInfoTable().get((Object)"#TRANSACTIONINFO");
    }

    public static class Builder {
        private long currentTerm = 0L;
        private long transactionIndex = -1L;

        public Builder setCurrentTerm(long term) {
            this.currentTerm = term;
            return this;
        }

        public Builder setTransactionIndex(long tIndex) {
            this.transactionIndex = tIndex;
            return this;
        }

        public OMTransactionInfo build() {
            return new OMTransactionInfo(this.currentTerm, this.transactionIndex);
        }
    }
}

