/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.ratis.utils;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.utils.db.DBStore;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.ozone.om.OmMetadataManagerImpl;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.ratis.OMTransactionInfo;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.bucket.OMBucketCreateRequest;
import org.apache.hadoop.ozone.om.request.bucket.OMBucketDeleteRequest;
import org.apache.hadoop.ozone.om.request.bucket.OMBucketSetPropertyRequest;
import org.apache.hadoop.ozone.om.request.bucket.acl.OMBucketAddAclRequest;
import org.apache.hadoop.ozone.om.request.bucket.acl.OMBucketRemoveAclRequest;
import org.apache.hadoop.ozone.om.request.bucket.acl.OMBucketSetAclRequest;
import org.apache.hadoop.ozone.om.request.file.OMDirectoryCreateRequest;
import org.apache.hadoop.ozone.om.request.file.OMFileCreateRequest;
import org.apache.hadoop.ozone.om.request.key.OMAllocateBlockRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeyCommitRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeyCreateRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeyDeleteRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeyPurgeRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeyRenameRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeysDeleteRequest;
import org.apache.hadoop.ozone.om.request.key.OMTrashRecoverRequest;
import org.apache.hadoop.ozone.om.request.key.acl.OMKeyAddAclRequest;
import org.apache.hadoop.ozone.om.request.key.acl.OMKeyRemoveAclRequest;
import org.apache.hadoop.ozone.om.request.key.acl.OMKeySetAclRequest;
import org.apache.hadoop.ozone.om.request.key.acl.prefix.OMPrefixAddAclRequest;
import org.apache.hadoop.ozone.om.request.key.acl.prefix.OMPrefixRemoveAclRequest;
import org.apache.hadoop.ozone.om.request.key.acl.prefix.OMPrefixSetAclRequest;
import org.apache.hadoop.ozone.om.request.s3.multipart.S3InitiateMultipartUploadRequest;
import org.apache.hadoop.ozone.om.request.s3.multipart.S3MultipartUploadAbortRequest;
import org.apache.hadoop.ozone.om.request.s3.multipart.S3MultipartUploadCommitPartRequest;
import org.apache.hadoop.ozone.om.request.s3.multipart.S3MultipartUploadCompleteRequest;
import org.apache.hadoop.ozone.om.request.s3.security.S3GetSecretRequest;
import org.apache.hadoop.ozone.om.request.security.OMCancelDelegationTokenRequest;
import org.apache.hadoop.ozone.om.request.security.OMGetDelegationTokenRequest;
import org.apache.hadoop.ozone.om.request.security.OMRenewDelegationTokenRequest;
import org.apache.hadoop.ozone.om.request.volume.OMVolumeCreateRequest;
import org.apache.hadoop.ozone.om.request.volume.OMVolumeDeleteRequest;
import org.apache.hadoop.ozone.om.request.volume.OMVolumeSetOwnerRequest;
import org.apache.hadoop.ozone.om.request.volume.OMVolumeSetQuotaRequest;
import org.apache.hadoop.ozone.om.request.volume.acl.OMVolumeAddAclRequest;
import org.apache.hadoop.ozone.om.request.volume.acl.OMVolumeRemoveAclRequest;
import org.apache.hadoop.ozone.om.request.volume.acl.OMVolumeSetAclRequest;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.ratis.util.FileUtils;
import org.rocksdb.RocksDBException;

public final class OzoneManagerRatisUtils {
    private OzoneManagerRatisUtils() {
    }

    public static OMClientRequest createClientRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        OzoneManagerProtocolProtos.Type cmdType = omRequest.getCmdType();
        switch (cmdType) {
            case CreateVolume: {
                return new OMVolumeCreateRequest(omRequest);
            }
            case SetVolumeProperty: {
                boolean hasQuota = omRequest.getSetVolumePropertyRequest().hasQuotaInBytes();
                boolean hasOwner = omRequest.getSetVolumePropertyRequest().hasOwnerName();
                Preconditions.checkState((hasOwner || hasQuota ? 1 : 0) != 0, (Object)"Either Quota or owner should be set in the SetVolumeProperty request");
                Preconditions.checkState((!hasOwner || !hasQuota ? 1 : 0) != 0, (Object)"Either Quota or owner should be set in the SetVolumeProperty request. Should not set both");
                if (hasQuota) {
                    return new OMVolumeSetQuotaRequest(omRequest);
                }
                return new OMVolumeSetOwnerRequest(omRequest);
            }
            case DeleteVolume: {
                return new OMVolumeDeleteRequest(omRequest);
            }
            case CreateBucket: {
                return new OMBucketCreateRequest(omRequest);
            }
            case DeleteBucket: {
                return new OMBucketDeleteRequest(omRequest);
            }
            case SetBucketProperty: {
                return new OMBucketSetPropertyRequest(omRequest);
            }
            case AllocateBlock: {
                return new OMAllocateBlockRequest(omRequest);
            }
            case CreateKey: {
                return new OMKeyCreateRequest(omRequest);
            }
            case CommitKey: {
                return new OMKeyCommitRequest(omRequest);
            }
            case DeleteKey: {
                return new OMKeyDeleteRequest(omRequest);
            }
            case DeleteKeys: {
                return new OMKeysDeleteRequest(omRequest);
            }
            case RenameKey: {
                return new OMKeyRenameRequest(omRequest);
            }
            case CreateDirectory: {
                return new OMDirectoryCreateRequest(omRequest);
            }
            case CreateFile: {
                return new OMFileCreateRequest(omRequest);
            }
            case PurgeKeys: {
                return new OMKeyPurgeRequest(omRequest);
            }
            case InitiateMultiPartUpload: {
                return new S3InitiateMultipartUploadRequest(omRequest);
            }
            case CommitMultiPartUpload: {
                return new S3MultipartUploadCommitPartRequest(omRequest);
            }
            case AbortMultiPartUpload: {
                return new S3MultipartUploadAbortRequest(omRequest);
            }
            case CompleteMultiPartUpload: {
                return new S3MultipartUploadCompleteRequest(omRequest);
            }
            case AddAcl: 
            case RemoveAcl: 
            case SetAcl: {
                return OzoneManagerRatisUtils.getOMAclRequest(omRequest);
            }
            case GetDelegationToken: {
                return new OMGetDelegationTokenRequest(omRequest);
            }
            case CancelDelegationToken: {
                return new OMCancelDelegationTokenRequest(omRequest);
            }
            case RenewDelegationToken: {
                return new OMRenewDelegationTokenRequest(omRequest);
            }
            case GetS3Secret: {
                return new S3GetSecretRequest(omRequest);
            }
            case RecoverTrash: {
                return new OMTrashRecoverRequest(omRequest);
            }
        }
        throw new IllegalStateException("Unrecognized write command type request" + cmdType);
    }

    private static OMClientRequest getOMAclRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        OzoneManagerProtocolProtos.Type cmdType = omRequest.getCmdType();
        if (OzoneManagerProtocolProtos.Type.AddAcl == cmdType) {
            OzoneManagerProtocolProtos.OzoneObj.ObjectType type = omRequest.getAddAclRequest().getObj().getResType();
            if (OzoneManagerProtocolProtos.OzoneObj.ObjectType.VOLUME == type) {
                return new OMVolumeAddAclRequest(omRequest);
            }
            if (OzoneManagerProtocolProtos.OzoneObj.ObjectType.BUCKET == type) {
                return new OMBucketAddAclRequest(omRequest);
            }
            if (OzoneManagerProtocolProtos.OzoneObj.ObjectType.KEY == type) {
                return new OMKeyAddAclRequest(omRequest);
            }
            return new OMPrefixAddAclRequest(omRequest);
        }
        if (OzoneManagerProtocolProtos.Type.RemoveAcl == cmdType) {
            OzoneManagerProtocolProtos.OzoneObj.ObjectType type = omRequest.getRemoveAclRequest().getObj().getResType();
            if (OzoneManagerProtocolProtos.OzoneObj.ObjectType.VOLUME == type) {
                return new OMVolumeRemoveAclRequest(omRequest);
            }
            if (OzoneManagerProtocolProtos.OzoneObj.ObjectType.BUCKET == type) {
                return new OMBucketRemoveAclRequest(omRequest);
            }
            if (OzoneManagerProtocolProtos.OzoneObj.ObjectType.KEY == type) {
                return new OMKeyRemoveAclRequest(omRequest);
            }
            return new OMPrefixRemoveAclRequest(omRequest);
        }
        OzoneManagerProtocolProtos.OzoneObj.ObjectType type = omRequest.getSetAclRequest().getObj().getResType();
        if (OzoneManagerProtocolProtos.OzoneObj.ObjectType.VOLUME == type) {
            return new OMVolumeSetAclRequest(omRequest);
        }
        if (OzoneManagerProtocolProtos.OzoneObj.ObjectType.BUCKET == type) {
            return new OMBucketSetAclRequest(omRequest);
        }
        if (OzoneManagerProtocolProtos.OzoneObj.ObjectType.KEY == type) {
            return new OMKeySetAclRequest(omRequest);
        }
        return new OMPrefixSetAclRequest(omRequest);
    }

    public static OzoneManagerProtocolProtos.Status exceptionToResponseStatus(IOException exception) {
        if (exception instanceof OMException) {
            return OzoneManagerProtocolProtos.Status.values()[((OMException)((Object)exception)).getResult().ordinal()];
        }
        if (exception.getCause() != null && exception.getCause() instanceof RocksDBException) {
            return OzoneManagerProtocolProtos.Status.METADATA_ERROR;
        }
        return OzoneManagerProtocolProtos.Status.INTERNAL_ERROR;
    }

    public static OMTransactionInfo getTrxnInfoFromCheckpoint(OzoneConfiguration conf, Path dbPath) throws Exception {
        if (dbPath != null) {
            Path dbDir = dbPath.getParent();
            Path dbFile = dbPath.getFileName();
            if (dbDir != null && dbFile != null) {
                return OzoneManagerRatisUtils.getTransactionInfoFromDB(conf, dbDir, dbFile.toString());
            }
        }
        throw new IOException("Checkpoint " + dbPath + " does not have proper DB location");
    }

    private static OMTransactionInfo getTransactionInfoFromDB(OzoneConfiguration tempConfig, Path dbDir, String dbName) throws Exception {
        DBStore dbStore = OmMetadataManagerImpl.loadDB(tempConfig, dbDir.toFile(), dbName);
        Table transactionInfoTable = dbStore.getTable("transactionInfoTable", String.class, OMTransactionInfo.class);
        OMTransactionInfo omTransactionInfo = (OMTransactionInfo)transactionInfoTable.get((Object)"#TRANSACTIONINFO");
        dbStore.close();
        if (omTransactionInfo == null) {
            throw new IOException("Failed to read OMTransactionInfo from DB " + dbName + " at " + dbDir);
        }
        return omTransactionInfo;
    }

    public static boolean verifyTransactionInfo(OMTransactionInfo omTransactionInfo, long lastAppliedIndex, String leaderId, Path newDBlocation) {
        if (omTransactionInfo.getTransactionIndex() <= lastAppliedIndex) {
            OzoneManager.LOG.error("Failed to install checkpoint from OM leader: {}. The last applied index: {} is greater than or equal to the checkpoint's applied index: {}. Deleting the downloaded checkpoint {}", new Object[]{leaderId, lastAppliedIndex, omTransactionInfo.getTransactionIndex(), newDBlocation});
            try {
                FileUtils.deleteFully((Path)newDBlocation);
            }
            catch (IOException e) {
                OzoneManager.LOG.error("Failed to fully delete the downloaded DB checkpoint {} from OM leader {}.", new Object[]{newDBlocation, leaderId, e});
            }
            return false;
        }
        return true;
    }
}

