/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.bucket.acl;

import com.google.common.base.Optional;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerDoubleBufferHelper;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.util.ObjectParser;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.ozone.util.BooleanBiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OMBucketAclRequest
extends OMClientRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMBucketAclRequest.class);
    private BooleanBiFunction<List<OzoneAcl>, OmBucketInfo> omBucketAclOp;

    public OMBucketAclRequest(OzoneManagerProtocolProtos.OMRequest omRequest, BooleanBiFunction<List<OzoneAcl>, OmBucketInfo> aclOp) {
        super(omRequest);
        this.omBucketAclOp = aclOp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long transactionLogIndex, OzoneManagerDoubleBufferHelper ozoneManagerDoubleBufferHelper) {
        ozoneAcls = this.getAcls();
        omMetrics = ozoneManager.getMetrics();
        omMetrics.incNumBucketUpdates();
        omBucketInfo = null;
        omResponse = this.onInit();
        omClientResponse = null;
        exception = null;
        omMetadataManager = ozoneManager.getMetadataManager();
        lockAcquired = false;
        volume = null;
        bucket = null;
        operationResult = false;
        try {
            objectParser = new ObjectParser(this.getPath(), OzoneManagerProtocolProtos.OzoneObj.ObjectType.BUCKET);
            volume = objectParser.getVolume();
            bucket = objectParser.getBucket();
            if (ozoneManager.getAclsEnabled()) {
                this.checkAcls(ozoneManager, OzoneObj.ResourceType.VOLUME, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.WRITE_ACL, volume, null, null);
            }
            lockAcquired = omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volume, bucket});
            dbBucketKey = omMetadataManager.getBucketKey(volume, bucket);
            omBucketInfo = (OmBucketInfo)omMetadataManager.getBucketTable().get((Object)dbBucketKey);
            if (omBucketInfo == null) {
                throw new OMException(OMException.ResultCodes.BUCKET_NOT_FOUND);
            }
            operationResult = this.omBucketAclOp.apply(ozoneAcls, (Object)omBucketInfo);
            omBucketInfo.setUpdateID(transactionLogIndex, ozoneManager.isRatisEnabled());
            if (operationResult) {
                omMetadataManager.getBucketTable().addCacheEntry(new CacheKey((Object)dbBucketKey), new CacheValue(Optional.of((Object)omBucketInfo), transactionLogIndex));
            }
            omClientResponse = this.onSuccess(omResponse, omBucketInfo, operationResult);
        }
        catch (IOException ex) {
            try {
                exception = ex;
                omClientResponse = this.onFailure(omResponse, ex);
            }
            catch (Throwable var18_18) {
                this.addResponseToDoubleBuffer(transactionLogIndex, omClientResponse, ozoneManagerDoubleBufferHelper);
                if (lockAcquired) {
                    omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volume, bucket});
                }
                throw var18_18;
            }
            this.addResponseToDoubleBuffer(transactionLogIndex, omClientResponse, ozoneManagerDoubleBufferHelper);
            if (lockAcquired) {
                omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volume, bucket});
            } else {
                ** GOTO lbl46
            }
        }
        this.addResponseToDoubleBuffer(transactionLogIndex, omClientResponse, ozoneManagerDoubleBufferHelper);
        if (lockAcquired) {
            omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volume, bucket});
        }
        this.onComplete(operationResult, exception, ozoneManager.getMetrics());
        return omClientResponse;
    }

    abstract List<OzoneAcl> getAcls();

    abstract String getPath();

    abstract OzoneManagerProtocolProtos.OMResponse.Builder onInit();

    abstract OMClientResponse onSuccess(OzoneManagerProtocolProtos.OMResponse.Builder var1, OmBucketInfo var2, boolean var3);

    abstract OMClientResponse onFailure(OzoneManagerProtocolProtos.OMResponse.Builder var1, IOException var2);

    abstract void onComplete(boolean var1, IOException var2, OMMetrics var3);
}

