/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.bucket.acl;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.request.bucket.acl.OMBucketAclRequest;
import org.apache.hadoop.ozone.om.request.bucket.acl.OMBucketAddAclRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.bucket.acl.OMBucketAclResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.util.BooleanBiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMBucketRemoveAclRequest
extends OMBucketAclRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMBucketAddAclRequest.class);
    private static BooleanBiFunction<List<OzoneAcl>, OmBucketInfo> bucketAddAclOp = (ozoneAcls, omBucketInfo) -> omBucketInfo.removeAcl((OzoneAcl)ozoneAcls.get(0));
    private String path;
    private List<OzoneAcl> ozoneAcls;

    public OMBucketRemoveAclRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest, bucketAddAclOp);
        OzoneManagerProtocolProtos.RemoveAclRequest removeAclRequest = this.getOmRequest().getRemoveAclRequest();
        this.path = removeAclRequest.getObj().getPath();
        this.ozoneAcls = Lists.newArrayList((Object[])new OzoneAcl[]{OzoneAcl.fromProtobuf((OzoneManagerProtocolProtos.OzoneAclInfo)removeAclRequest.getAcl())});
    }

    @Override
    List<OzoneAcl> getAcls() {
        return this.ozoneAcls;
    }

    @Override
    String getPath() {
        return this.path;
    }

    @Override
    OzoneManagerProtocolProtos.OMResponse.Builder onInit() {
        return OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
    }

    @Override
    OMClientResponse onSuccess(OzoneManagerProtocolProtos.OMResponse.Builder omResponse, OmBucketInfo omBucketInfo, boolean operationResult) {
        omResponse.setSuccess(operationResult);
        omResponse.setRemoveAclResponse(OzoneManagerProtocolProtos.RemoveAclResponse.newBuilder().setResponse(operationResult));
        return new OMBucketAclResponse(omResponse.build(), omBucketInfo);
    }

    @Override
    OMClientResponse onFailure(OzoneManagerProtocolProtos.OMResponse.Builder omResponse, IOException exception) {
        return new OMBucketAclResponse(this.createErrorOMResponse(omResponse, exception));
    }

    @Override
    void onComplete(boolean operationResult, IOException exception, OMMetrics omMetrics) {
        if (operationResult) {
            LOG.debug("Remove acl: {} for path: {} success!", this.getAcls(), (Object)this.getPath());
        } else {
            omMetrics.incNumBucketUpdateFails();
            if (exception == null) {
                LOG.error("Remove acl {} for path {} failed, because acl does not exist", this.getAcls(), (Object)this.getPath());
            } else {
                LOG.error("Remove acl {} for path {} failed!", new Object[]{this.getAcls(), this.getPath(), exception});
            }
        }
    }
}

