/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.key;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.ExcludeList;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerDoubleBufferHelper;
import org.apache.hadoop.ozone.om.request.key.OMKeyRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.key.OMAllocateBlockResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMAllocateBlockRequest
extends OMKeyRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMAllocateBlockRequest.class);

    public OMAllocateBlockRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        OzoneManagerProtocolProtos.AllocateBlockRequest allocateBlockRequest = this.getOmRequest().getAllocateBlockRequest();
        Preconditions.checkNotNull((Object)allocateBlockRequest);
        OzoneManagerProtocolProtos.KeyArgs keyArgs = allocateBlockRequest.getKeyArgs();
        ExcludeList excludeList = new ExcludeList();
        if (allocateBlockRequest.hasExcludeList()) {
            excludeList = ExcludeList.getFromProtoBuf((HddsProtos.ExcludeListProto)allocateBlockRequest.getExcludeList());
        }
        List<OmKeyLocationInfo> omKeyLocationInfoList = this.allocateBlock(ozoneManager.getScmClient(), ozoneManager.getBlockTokenSecretManager(), keyArgs.getType(), keyArgs.getFactor(), excludeList, ozoneManager.getScmBlockSize(), ozoneManager.getScmBlockSize(), ozoneManager.getPreallocateBlocksMax(), ozoneManager.isGrpcBlockTokenEnabled(), ozoneManager.getOMNodeId());
        OzoneManagerProtocolProtos.KeyArgs.Builder newKeyArgs = keyArgs.toBuilder().setModificationTime(Time.now()).setKeyName(OMAllocateBlockRequest.validateAndNormalizeKey(ozoneManager.getEnableFileSystemPaths(), keyArgs.getKeyName()));
        OzoneManagerProtocolProtos.AllocateBlockRequest.Builder newAllocatedBlockRequest = OzoneManagerProtocolProtos.AllocateBlockRequest.newBuilder().setClientID(allocateBlockRequest.getClientID()).setKeyArgs(newKeyArgs);
        if (allocateBlockRequest.hasExcludeList()) {
            newAllocatedBlockRequest.setExcludeList(allocateBlockRequest.getExcludeList());
        }
        newAllocatedBlockRequest.setKeyLocation(omKeyLocationInfoList.get(0).getProtobuf());
        return this.getOmRequest().toBuilder().setUserInfo(this.getUserInfo()).setAllocateBlockRequest(newAllocatedBlockRequest).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long trxnLogIndex, OzoneManagerDoubleBufferHelper omDoubleBufferHelper) {
        OzoneManagerProtocolProtos.AllocateBlockRequest allocateBlockRequest = this.getOmRequest().getAllocateBlockRequest();
        OzoneManagerProtocolProtos.KeyArgs keyArgs = allocateBlockRequest.getKeyArgs();
        OzoneManagerProtocolProtos.KeyLocation blockLocation = allocateBlockRequest.getKeyLocation();
        Preconditions.checkNotNull((Object)blockLocation);
        String volumeName = keyArgs.getVolumeName();
        String bucketName = keyArgs.getBucketName();
        String keyName = keyArgs.getKeyName();
        long clientID = allocateBlockRequest.getClientID();
        OMMetrics omMetrics = ozoneManager.getMetrics();
        omMetrics.incNumBlockAllocateCalls();
        AuditLogger auditLogger = ozoneManager.getAuditLogger();
        Map<String, String> auditMap = this.buildKeyArgsAuditMap(keyArgs);
        auditMap.put("clientID", String.valueOf(clientID));
        OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
        String openKeyName = null;
        OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
        OMAllocateBlockResponse omClientResponse = null;
        IOException exception = null;
        try {
            keyArgs = OMAllocateBlockRequest.resolveBucketLink(ozoneManager, keyArgs, auditMap);
            volumeName = keyArgs.getVolumeName();
            bucketName = keyArgs.getBucketName();
            this.checkKeyAclsInOpenKeyTable(ozoneManager, volumeName, bucketName, keyName, IAccessAuthorizer.ACLType.WRITE, allocateBlockRequest.getClientID());
            this.validateBucketAndVolume(omMetadataManager, volumeName, bucketName);
            openKeyName = omMetadataManager.getOpenKey(volumeName, bucketName, keyName, clientID);
            OmKeyInfo openKeyInfo = (OmKeyInfo)omMetadataManager.getOpenKeyTable().get((Object)openKeyName);
            if (openKeyInfo == null) {
                throw new OMException("Open Key not found " + openKeyName, OMException.ResultCodes.KEY_NOT_FOUND);
            }
            openKeyInfo.appendNewBlocks(Collections.singletonList(OmKeyLocationInfo.getFromProtobuf((OzoneManagerProtocolProtos.KeyLocation)blockLocation)), false);
            openKeyInfo.setModificationTime(keyArgs.getModificationTime());
            openKeyInfo.setUpdateID(trxnLogIndex, ozoneManager.isRatisEnabled());
            omMetadataManager.getOpenKeyTable().addCacheEntry(new CacheKey((Object)openKeyName), new CacheValue(Optional.of((Object)openKeyInfo), trxnLogIndex));
            omResponse.setAllocateBlockResponse(OzoneManagerProtocolProtos.AllocateBlockResponse.newBuilder().setKeyLocation(blockLocation).build());
            omClientResponse = new OMAllocateBlockResponse(omResponse.build(), openKeyInfo, clientID);
            LOG.debug("Allocated block for Volume:{}, Bucket:{}, OpenKey:{}", new Object[]{volumeName, bucketName, openKeyName});
        }
        catch (IOException ex) {
            try {
                omMetrics.incNumBlockAllocateCallFails();
                exception = ex;
                omClientResponse = new OMAllocateBlockResponse(this.createErrorOMResponse(omResponse, exception));
                LOG.error("Allocate Block failed. Volume:{}, Bucket:{}, OpenKey:{}. Exception:{}", new Object[]{volumeName, bucketName, openKeyName, exception});
            }
            catch (Throwable throwable) {
                this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
                throw throwable;
            }
            this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
        }
        this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
        this.auditLog(auditLogger, this.buildAuditMessage((AuditAction)OMAction.ALLOCATE_BLOCK, auditMap, exception, this.getOmRequest().getUserInfo()));
        return omClientResponse;
    }
}

