/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.key;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerDoubleBufferHelper;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeyRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.key.OMKeyCommitResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMKeyCommitRequest
extends OMKeyRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMKeyCommitRequest.class);

    public OMKeyCommitRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        OzoneManagerProtocolProtos.CommitKeyRequest commitKeyRequest = this.getOmRequest().getCommitKeyRequest();
        Preconditions.checkNotNull((Object)commitKeyRequest);
        OzoneManagerProtocolProtos.KeyArgs keyArgs = commitKeyRequest.getKeyArgs();
        boolean checkKeyNameEnabled = ozoneManager.getConfiguration().getBoolean("ozone.om.keyname.character.check.enabled", false);
        if (checkKeyNameEnabled) {
            OmUtils.validateKeyName((String)StringUtils.removeEnd((String)keyArgs.getKeyName(), (String)"._COPYING_"));
        }
        OzoneManagerProtocolProtos.KeyArgs.Builder newKeyArgs = keyArgs.toBuilder().setModificationTime(Time.now()).setKeyName(OMKeyCommitRequest.validateAndNormalizeKey(ozoneManager.getEnableFileSystemPaths(), keyArgs.getKeyName()));
        return this.getOmRequest().toBuilder().setCommitKeyRequest(commitKeyRequest.toBuilder().setKeyArgs(newKeyArgs)).setUserInfo(this.getUserInfo()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long trxnLogIndex, OzoneManagerDoubleBufferHelper omDoubleBufferHelper) {
        commitKeyRequest = this.getOmRequest().getCommitKeyRequest();
        commitKeyArgs = commitKeyRequest.getKeyArgs();
        volumeName = commitKeyArgs.getVolumeName();
        bucketName = commitKeyArgs.getBucketName();
        keyName = commitKeyArgs.getKeyName();
        omMetrics = ozoneManager.getMetrics();
        omMetrics.incNumKeyCommits();
        auditLogger = ozoneManager.getAuditLogger();
        auditMap = this.buildKeyArgsAuditMap(commitKeyArgs);
        omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
        exception = null;
        omKeyInfo = null;
        omClientResponse = null;
        bucketLockAcquired = false;
        omMetadataManager = ozoneManager.getMetadataManager();
        try {
            commitKeyArgs = OMKeyCommitRequest.resolveBucketLink(ozoneManager, commitKeyArgs, auditMap);
            volumeName = commitKeyArgs.getVolumeName();
            bucketName = commitKeyArgs.getBucketName();
            this.checkKeyAclsInOpenKeyTable(ozoneManager, volumeName, bucketName, keyName, IAccessAuthorizer.ACLType.WRITE, commitKeyRequest.getClientID());
            dbOzoneKey = omMetadataManager.getOzoneKey(volumeName, bucketName, keyName);
            dbOpenKey = omMetadataManager.getOpenKey(volumeName, bucketName, keyName, commitKeyRequest.getClientID());
            locationInfoList = new ArrayList<OmKeyLocationInfo>();
            for (OzoneManagerProtocolProtos.KeyLocation keyLocation : commitKeyArgs.getKeyLocationsList()) {
                locationInfoList.add(OmKeyLocationInfo.getFromProtobuf((OzoneManagerProtocolProtos.KeyLocation)keyLocation));
            }
            bucketLockAcquired = omMetadataManager.getLock().acquireLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            this.validateBucketAndVolume(omMetadataManager, volumeName, bucketName);
            omKeyInfo = (OmKeyInfo)omMetadataManager.getOpenKeyTable().get((Object)dbOpenKey);
            if (omKeyInfo == null) {
                throw new OMException("Failed to commit key, as " + dbOpenKey + "entry is not found in the OpenKey table", OMException.ResultCodes.KEY_NOT_FOUND);
            }
            omKeyInfo.setDataSize(commitKeyArgs.getDataSize());
            omKeyInfo.setModificationTime(commitKeyArgs.getModificationTime());
            omKeyInfo.updateLocationInfoList(locationInfoList);
            omKeyInfo.setUpdateID(trxnLogIndex, ozoneManager.isRatisEnabled());
            omMetadataManager.getOpenKeyTable().addCacheEntry(new CacheKey((Object)dbOpenKey), new CacheValue(Optional.absent(), trxnLogIndex));
            omMetadataManager.getKeyTable().addCacheEntry(new CacheKey((Object)dbOzoneKey), new CacheValue(Optional.of((Object)omKeyInfo), trxnLogIndex));
            omClientResponse = new OMKeyCommitResponse(omResponse.build(), omKeyInfo, dbOzoneKey, dbOpenKey);
            result = OMClientRequest.Result.SUCCESS;
        }
        catch (IOException ex) {
            try {
                result = OMClientRequest.Result.FAILURE;
                exception = ex;
                omClientResponse = new OMKeyCommitResponse(this.createErrorOMResponse(omResponse, exception));
            }
            catch (Throwable var25_25) {
                this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
                if (bucketLockAcquired) {
                    omMetadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                }
                throw var25_25;
            }
            this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
            if (bucketLockAcquired) {
                omMetadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            } else {
                ** GOTO lbl59
            }
        }
        this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
        if (bucketLockAcquired) {
            omMetadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        }
        this.auditLog(auditLogger, this.buildAuditMessage((AuditAction)OMAction.COMMIT_KEY, auditMap, exception, this.getOmRequest().getUserInfo()));
        switch (1.$SwitchMap$org$apache$hadoop$ozone$om$request$OMClientRequest$Result[result.ordinal()]) {
            case 1: {
                if (omKeyInfo.getKeyLocationVersions().size() == 1) {
                    omMetrics.incNumKeys();
                }
                OMKeyCommitRequest.LOG.debug("Key committed. Volume:{}, Bucket:{}, Key:{}", new Object[]{volumeName, bucketName, keyName});
                break;
            }
            case 2: {
                OMKeyCommitRequest.LOG.error("Key commit failed. Volume:{}, Bucket:{}, Key:{}. Exception:{}", new Object[]{volumeName, bucketName, keyName, exception});
                omMetrics.incNumKeyCommitFails();
                break;
            }
            default: {
                OMKeyCommitRequest.LOG.error("Unrecognized Result for OMKeyCommitRequest: {}", (Object)commitKeyRequest);
            }
        }
        return omClientResponse;
    }
}

