/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.key;

import com.google.common.base.Optional;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.ResolvedBucket;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerDoubleBufferHelper;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeyRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.key.OMKeysDeleteResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMKeysDeleteRequest
extends OMKeyRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMKeysDeleteRequest.class);

    public OMKeysDeleteRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long trxnLogIndex, OzoneManagerDoubleBufferHelper omDoubleBufferHelper) {
        OzoneManagerProtocolProtos.DeleteKeyArgs.Builder unDeletedKeys;
        OzoneManagerProtocolProtos.UserInfo userInfo;
        AuditLogger auditLogger;
        LinkedHashMap<String, String> auditMap;
        String bucketName;
        String volumeName;
        OMMetrics omMetrics;
        OMClientRequest.Result result;
        OMKeysDeleteResponse omClientResponse;
        IOException exception;
        ArrayList<String> deleteKeys;
        OzoneManagerProtocolProtos.DeleteKeysRequest deleteKeyRequest;
        block15: {
            deleteKeyRequest = this.getOmRequest().getDeleteKeysRequest();
            OzoneManagerProtocolProtos.DeleteKeyArgs deleteKeyArgs = deleteKeyRequest.getDeleteKeys();
            deleteKeys = new ArrayList<String>(deleteKeyArgs.getKeysList());
            exception = null;
            omClientResponse = null;
            result = null;
            omMetrics = ozoneManager.getMetrics();
            omMetrics.incNumKeyDeletes();
            volumeName = deleteKeyArgs.getVolumeName();
            bucketName = deleteKeyArgs.getBucketName();
            auditMap = new LinkedHashMap<String, String>();
            auditMap.put("volume", volumeName);
            auditMap.put("bucket", bucketName);
            ArrayList<OmKeyInfo> omKeyInfoList = new ArrayList<OmKeyInfo>();
            auditLogger = ozoneManager.getAuditLogger();
            userInfo = this.getOmRequest().getUserInfo();
            OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
            OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
            boolean acquiredLock = false;
            int indexFailed = 0;
            int length = deleteKeys.size();
            unDeletedKeys = OzoneManagerProtocolProtos.DeleteKeyArgs.newBuilder().setVolumeName(volumeName).setBucketName(bucketName);
            boolean deleteStatus = true;
            try {
                ResolvedBucket bucket = ozoneManager.resolveBucketLink((Pair<String, String>)Pair.of((Object)volumeName, (Object)bucketName));
                bucket.audit(auditMap);
                volumeName = bucket.realVolume();
                bucketName = bucket.realBucket();
                acquiredLock = omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                this.validateBucketAndVolume(omMetadataManager, volumeName, bucketName);
                for (indexFailed = 0; indexFailed < length; ++indexFailed) {
                    String keyName = deleteKeyArgs.getKeys(indexFailed);
                    String objectKey = omMetadataManager.getOzoneKey(volumeName, bucketName, keyName);
                    OmKeyInfo omKeyInfo = (OmKeyInfo)omMetadataManager.getKeyTable().get((Object)objectKey);
                    if (omKeyInfo == null) {
                        deleteStatus = false;
                        LOG.error("Received a request to delete a Key does not exist {}", (Object)objectKey);
                        deleteKeys.remove(keyName);
                        unDeletedKeys.addKeys(keyName);
                        continue;
                    }
                    try {
                        this.checkKeyAcls(ozoneManager, volumeName, bucketName, keyName, IAccessAuthorizer.ACLType.DELETE, OzoneObj.ResourceType.KEY);
                        omKeyInfoList.add(omKeyInfo);
                        continue;
                    }
                    catch (Exception ex) {
                        deleteStatus = false;
                        LOG.error("Acl check failed for Key: {}", (Object)objectKey, (Object)ex);
                        deleteKeys.remove(keyName);
                        unDeletedKeys.addKeys(keyName);
                    }
                }
                for (OmKeyInfo omKeyInfo : omKeyInfoList) {
                    omMetadataManager.getKeyTable().addCacheEntry(new CacheKey((Object)omMetadataManager.getOzoneKey(volumeName, bucketName, omKeyInfo.getKeyName())), new CacheValue(Optional.absent(), trxnLogIndex));
                }
                omClientResponse = new OMKeysDeleteResponse(omResponse.setDeleteKeysResponse(OzoneManagerProtocolProtos.DeleteKeysResponse.newBuilder().setStatus(deleteStatus).setUnDeletedKeys(unDeletedKeys)).setStatus(deleteStatus ? OzoneManagerProtocolProtos.Status.OK : OzoneManagerProtocolProtos.Status.PARTIAL_DELETE).setSuccess(deleteStatus).build(), omKeyInfoList, trxnLogIndex, ozoneManager.isRatisEnabled());
                result = OMClientRequest.Result.SUCCESS;
                if (!acquiredLock) break block15;
            }
            catch (IOException ex) {
                block16: {
                    try {
                        result = OMClientRequest.Result.FAILURE;
                        exception = ex;
                        this.createErrorOMResponse(omResponse, ex);
                        deleteKeys = new ArrayList();
                        for (int i = indexFailed; i < length; ++i) {
                            unDeletedKeys.addKeys(deleteKeyArgs.getKeys(i));
                        }
                        omResponse.setDeleteKeysResponse(OzoneManagerProtocolProtos.DeleteKeysResponse.newBuilder().setStatus(false).setUnDeletedKeys(unDeletedKeys).build()).build();
                        omClientResponse = new OMKeysDeleteResponse(omResponse.build());
                        if (!acquiredLock) break block16;
                    }
                    catch (Throwable throwable) {
                        if (acquiredLock) {
                            omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                        }
                        this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
                        throw throwable;
                    }
                    omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                }
                this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
            }
            omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        }
        this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
        OMKeysDeleteRequest.addDeletedKeys(auditMap, deleteKeys, unDeletedKeys.getKeysList());
        this.auditLog(auditLogger, this.buildAuditMessage((AuditAction)OMAction.DELETE_KEYS, auditMap, exception, userInfo));
        switch (result) {
            case SUCCESS: {
                omMetrics.decNumKeys(deleteKeys.size());
                if (!LOG.isDebugEnabled()) break;
                LOG.debug("Keys delete success. Volume:{}, Bucket:{}, Keys:{}", new Object[]{volumeName, bucketName, auditMap.get("deletedKeysList")});
                break;
            }
            case FAILURE: {
                omMetrics.decNumKeys(deleteKeys.size());
                omMetrics.incNumKeyDeleteFails();
                if (!LOG.isDebugEnabled()) break;
                LOG.debug("Keys delete failed. Volume:{}, Bucket:{}, DeletedKeys:{}, UnDeletedKeys:{}", new Object[]{volumeName, bucketName, auditMap.get("deletedKeysList"), auditMap.get("unDeletedKeysList"), exception});
                break;
            }
            default: {
                LOG.error("Unrecognized Result for OMKeysDeleteRequest: {}", (Object)deleteKeyRequest);
            }
        }
        return omClientResponse;
    }

    private static void addDeletedKeys(Map<String, String> auditMap, List<String> deletedKeys, List<String> unDeletedKeys) {
        auditMap.put("deletedKeysList", String.join((CharSequence)",", deletedKeys));
        auditMap.put("unDeletedKeysList", String.join((CharSequence)",", unDeletedKeys));
    }
}

