/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.key.acl;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OzoneAclUtil;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.key.acl.OMKeyAclRequest;
import org.apache.hadoop.ozone.om.request.key.acl.OMKeyAddAclRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.key.acl.OMKeyAclResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMKeySetAclRequest
extends OMKeyAclRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMKeyAddAclRequest.class);
    private String path;
    private List<OzoneAcl> ozoneAcls;

    public OMKeySetAclRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
        OzoneManagerProtocolProtos.SetAclRequest setAclRequest = this.getOmRequest().getSetAclRequest();
        this.path = setAclRequest.getObj().getPath();
        this.ozoneAcls = Lists.newArrayList((Iterable)OzoneAclUtil.fromProtobuf((List)setAclRequest.getAclList()));
    }

    @Override
    String getPath() {
        return this.path;
    }

    @Override
    OzoneManagerProtocolProtos.OMResponse.Builder onInit() {
        return OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
    }

    @Override
    OMClientResponse onSuccess(OzoneManagerProtocolProtos.OMResponse.Builder omResponse, OmKeyInfo omKeyInfo, boolean operationResult) {
        omResponse.setSuccess(operationResult);
        omResponse.setSetAclResponse(OzoneManagerProtocolProtos.SetAclResponse.newBuilder().setResponse(operationResult));
        return new OMKeyAclResponse(omResponse.build(), omKeyInfo);
    }

    @Override
    void onComplete(OMClientRequest.Result result, boolean operationResult, IOException exception, long trxnLogIndex) {
        switch (result) {
            case SUCCESS: {
                if (!LOG.isDebugEnabled()) break;
                LOG.debug("Set acl: {} to path: {} success!", this.ozoneAcls, (Object)this.path);
                break;
            }
            case FAILURE: {
                LOG.error("Set acl {} to path {} failed!", new Object[]{this.ozoneAcls, this.path, exception});
                break;
            }
            default: {
                LOG.error("Unrecognized Result for OMKeySetAclRequest: {}", (Object)this.getOmRequest());
            }
        }
    }

    @Override
    boolean apply(OmKeyInfo omKeyInfo, long trxnLogIndex) {
        return omKeyInfo.setAcls(this.ozoneAcls);
    }
}

