/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.security;

import com.google.common.base.Optional;
import java.io.IOException;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerDoubleBufferHelper;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.security.OMRenewDelegationTokenResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.protocolPB.OMPBHelper;
import org.apache.hadoop.ozone.security.OzoneTokenIdentifier;
import org.apache.hadoop.ozone.security.proto.SecurityProtos;
import org.apache.hadoop.security.token.Token;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMRenewDelegationTokenRequest
extends OMClientRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMRenewDelegationTokenRequest.class);

    public OMRenewDelegationTokenRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        SecurityProtos.RenewDelegationTokenRequestProto renewDelegationTokenRequest = this.getOmRequest().getRenewDelegationTokenRequest();
        long renewTime = ozoneManager.renewDelegationToken((Token<OzoneTokenIdentifier>)OMPBHelper.convertToDelegationToken((SecurityProtos.TokenProto)renewDelegationTokenRequest.getToken()));
        OzoneManagerProtocolProtos.RenewDelegationTokenResponseProto.Builder renewResponse = OzoneManagerProtocolProtos.RenewDelegationTokenResponseProto.newBuilder();
        renewResponse.setResponse(SecurityProtos.RenewDelegationTokenResponseProto.newBuilder().setNewExpiryTime(renewTime));
        OzoneManagerProtocolProtos.OMRequest.Builder omRequest = OzoneManagerProtocolProtos.OMRequest.newBuilder().setUserInfo(this.getUserInfo()).setUpdatedRenewDelegationTokenRequest(OzoneManagerProtocolProtos.UpdateRenewDelegationTokenRequest.newBuilder().setRenewDelegationTokenRequest(renewDelegationTokenRequest).setRenewDelegationTokenResponse(renewResponse)).setCmdType(this.getOmRequest().getCmdType()).setClientId(this.getOmRequest().getClientId());
        if (this.getOmRequest().hasTraceID()) {
            omRequest.setTraceID(this.getOmRequest().getTraceID());
        }
        return omRequest.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long transactionLogIndex, OzoneManagerDoubleBufferHelper ozoneManagerDoubleBufferHelper) {
        OzoneManagerProtocolProtos.UpdateRenewDelegationTokenRequest updateRenewDelegationTokenRequest = this.getOmRequest().getUpdatedRenewDelegationTokenRequest();
        Token ozoneTokenIdentifierToken = OMPBHelper.convertToDelegationToken((SecurityProtos.TokenProto)updateRenewDelegationTokenRequest.getRenewDelegationTokenRequest().getToken());
        long renewTime = updateRenewDelegationTokenRequest.getRenewDelegationTokenResponse().getResponse().getNewExpiryTime();
        OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
        OMRenewDelegationTokenResponse omClientResponse = null;
        OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
        try {
            OzoneTokenIdentifier ozoneTokenIdentifier = OzoneTokenIdentifier.readProtoBuf((byte[])ozoneTokenIdentifierToken.getIdentifier());
            ozoneManager.getDelegationTokenMgr().updateRenewToken((Token<OzoneTokenIdentifier>)ozoneTokenIdentifierToken, ozoneTokenIdentifier, renewTime);
            omMetadataManager.getDelegationTokenTable().addCacheEntry(new CacheKey((Object)ozoneTokenIdentifier), new CacheValue(Optional.of((Object)renewTime), transactionLogIndex));
            omClientResponse = new OMRenewDelegationTokenResponse(ozoneTokenIdentifier, renewTime, omResponse.setRenewDelegationTokenResponse(updateRenewDelegationTokenRequest.getRenewDelegationTokenResponse()).build());
        }
        catch (IOException ex) {
            try {
                LOG.error("Error in Updating Renew DelegationToken {}", (Object)ozoneTokenIdentifierToken, (Object)ex);
                omClientResponse = new OMRenewDelegationTokenResponse(null, -1L, this.createErrorOMResponse(omResponse, ex));
            }
            catch (Throwable throwable) {
                this.addResponseToDoubleBuffer(transactionLogIndex, omClientResponse, ozoneManagerDoubleBufferHelper);
                throw throwable;
            }
            this.addResponseToDoubleBuffer(transactionLogIndex, omClientResponse, ozoneManagerDoubleBufferHelper);
        }
        this.addResponseToDoubleBuffer(transactionLogIndex, omClientResponse, ozoneManagerDoubleBufferHelper);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Updated renew delegation token in-memory map: {} with expiry time {}", (Object)ozoneTokenIdentifierToken, (Object)renewTime);
        }
        return omClientResponse;
    }
}

