/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.volume;

import com.google.common.base.Optional;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OMVolumeRequest
extends OMClientRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMVolumeRequest.class);

    public OMVolumeRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    protected OzoneManagerProtocolProtos.UserVolumeInfo delVolumeFromOwnerList(OzoneManagerProtocolProtos.UserVolumeInfo volumeList, String volume, String owner, long txID) throws IOException {
        ArrayList prevVolList = new ArrayList();
        if (volumeList == null) {
            throw new OMException("User not found: " + owner, OMException.ResultCodes.USER_NOT_FOUND);
        }
        prevVolList.addAll(volumeList.getVolumeNamesList());
        prevVolList.remove(volume);
        OzoneManagerProtocolProtos.UserVolumeInfo newVolList = OzoneManagerProtocolProtos.UserVolumeInfo.newBuilder().addAllVolumeNames(prevVolList).setObjectID(volumeList.getObjectID()).setUpdateID(txID).build();
        return newVolList;
    }

    protected OzoneManagerProtocolProtos.UserVolumeInfo addVolumeToOwnerList(OzoneManagerProtocolProtos.UserVolumeInfo volumeList, String volume, String owner, long maxUserVolumeCount, long txID) throws IOException {
        if (volumeList != null && (long)volumeList.getVolumeNamesList().size() >= maxUserVolumeCount) {
            throw new OMException("Too many volumes for user:" + owner, OMException.ResultCodes.USER_TOO_MANY_VOLUMES);
        }
        HashSet<String> volumeSet = new HashSet<String>();
        long objectID = txID;
        if (volumeList != null) {
            volumeSet.addAll(volumeList.getVolumeNamesList());
            objectID = volumeList.getObjectID();
        }
        volumeSet.add(volume);
        return OzoneManagerProtocolProtos.UserVolumeInfo.newBuilder().setObjectID(objectID).setUpdateID(txID).addAllVolumeNames(volumeSet).build();
    }

    protected void createVolume(OMMetadataManager omMetadataManager, OmVolumeArgs omVolumeArgs, OzoneManagerProtocolProtos.UserVolumeInfo volumeList, String dbVolumeKey, String dbUserKey, long transactionLogIndex) {
        omMetadataManager.getUserTable().addCacheEntry(new CacheKey((Object)dbUserKey), new CacheValue(Optional.of((Object)volumeList), transactionLogIndex));
        omMetadataManager.getVolumeTable().addCacheEntry(new CacheKey((Object)dbVolumeKey), new CacheValue(Optional.of((Object)omVolumeArgs), transactionLogIndex));
    }

    protected OmVolumeArgs getVolumeInfo(OMMetadataManager omMetadataManager, String volume) throws IOException {
        String dbVolumeKey = omMetadataManager.getVolumeKey(volume);
        OmVolumeArgs volumeArgs = (OmVolumeArgs)omMetadataManager.getVolumeTable().get((Object)dbVolumeKey);
        if (volumeArgs == null) {
            throw new OMException("Volume " + volume + " is not found", OMException.ResultCodes.VOLUME_NOT_FOUND);
        }
        return volumeArgs;
    }
}

