/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.volume;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerDoubleBufferHelper;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.request.volume.OMVolumeRequest;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.volume.OMVolumeSetOwnerResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMVolumeSetOwnerRequest
extends OMVolumeRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMVolumeSetOwnerRequest.class);

    public OMVolumeSetOwnerRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        long modificationTime = Time.now();
        OzoneManagerProtocolProtos.SetVolumePropertyRequest modifiedRequest = this.getOmRequest().getSetVolumePropertyRequest().toBuilder().setModificationTime(modificationTime).build();
        return this.getOmRequest().toBuilder().setSetVolumePropertyRequest(modifiedRequest.toBuilder()).setUserInfo(this.getUserInfo()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long transactionLogIndex, OzoneManagerDoubleBufferHelper ozoneManagerDoubleBufferHelper) {
        block17: {
            setVolumePropertyRequest = this.getOmRequest().getSetVolumePropertyRequest();
            Preconditions.checkNotNull((Object)setVolumePropertyRequest);
            omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
            if (!setVolumePropertyRequest.hasOwnerName()) {
                omResponse.setStatus(OzoneManagerProtocolProtos.Status.INVALID_REQUEST).setSuccess(false);
                return new OMVolumeSetOwnerResponse(omResponse.build());
            }
            omMetrics = ozoneManager.getMetrics();
            omMetrics.incNumVolumeUpdates();
            volume = setVolumePropertyRequest.getVolumeName();
            newOwner = setVolumePropertyRequest.getOwnerName();
            auditLogger = ozoneManager.getAuditLogger();
            userInfo = this.getOmRequest().getUserInfo();
            auditMap = this.buildVolumeAuditMap(volume);
            auditMap.put("owner", newOwner);
            acquiredUserLocks = false;
            acquiredVolumeLock = false;
            exception = null;
            omMetadataManager = ozoneManager.getMetadataManager();
            oldOwner = null;
            omClientResponse = null;
            if (ozoneManager.getAclsEnabled()) {
                this.checkAcls(ozoneManager, OzoneObj.ResourceType.VOLUME, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.WRITE_ACL, volume, null, null);
            }
            maxUserVolumeCount = ozoneManager.getMaxUserVolumeCount();
            oldOwnerVolumeList = null;
            newOwnerVolumeList = null;
            omVolumeArgs = null;
            acquiredVolumeLock = omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
            omVolumeArgs = this.getVolumeInfo(omMetadataManager, volume);
            oldOwner = omVolumeArgs.getOwnerName();
            if (!oldOwner.equals(newOwner)) break block17;
            OMVolumeSetOwnerRequest.LOG.warn("Volume '{}' owner is already user '{}'.", (Object)volume, (Object)oldOwner);
            omResponse.setStatus(OzoneManagerProtocolProtos.Status.OK).setMessage("Volume '" + volume + "' owner is already '" + newOwner + "'.").setSuccess(false);
            omResponse.setSetVolumePropertyResponse(OzoneManagerProtocolProtos.SetVolumePropertyResponse.newBuilder().setResponse(false).build());
            var24_23 = omClientResponse = new OMVolumeSetOwnerResponse(omResponse.build());
            this.addResponseToDoubleBuffer(transactionLogIndex, omClientResponse, ozoneManagerDoubleBufferHelper);
            if (acquiredUserLocks) {
                omMetadataManager.getLock().releaseMultiUserLock(newOwner, oldOwner);
            }
            if (acquiredVolumeLock) {
                omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
            }
            return var24_23;
        }
        try {
            acquiredUserLocks = omMetadataManager.getLock().acquireMultiUserLock(newOwner, oldOwner);
            oldOwnerVolumeList = (OzoneManagerProtocolProtos.UserVolumeInfo)omMetadataManager.getUserTable().get((Object)oldOwner);
            oldOwnerVolumeList = this.delVolumeFromOwnerList(oldOwnerVolumeList, volume, oldOwner, transactionLogIndex);
            newOwnerVolumeList = (OzoneManagerProtocolProtos.UserVolumeInfo)omMetadataManager.getUserTable().get((Object)newOwner);
            newOwnerVolumeList = this.addVolumeToOwnerList(newOwnerVolumeList, volume, newOwner, maxUserVolumeCount, transactionLogIndex);
            omVolumeArgs.setOwnerName(newOwner);
            omVolumeArgs.setUpdateID(transactionLogIndex, ozoneManager.isRatisEnabled());
            omVolumeArgs.setModificationTime(setVolumePropertyRequest.getModificationTime());
            omMetadataManager.getUserTable().addCacheEntry(new CacheKey((Object)omMetadataManager.getUserKey(newOwner)), new CacheValue(Optional.of((Object)newOwnerVolumeList), transactionLogIndex));
            omMetadataManager.getUserTable().addCacheEntry(new CacheKey((Object)omMetadataManager.getUserKey(oldOwner)), new CacheValue(Optional.of((Object)oldOwnerVolumeList), transactionLogIndex));
            omMetadataManager.getVolumeTable().addCacheEntry(new CacheKey((Object)omMetadataManager.getVolumeKey(volume)), new CacheValue(Optional.of((Object)omVolumeArgs), transactionLogIndex));
            omResponse.setSetVolumePropertyResponse(OzoneManagerProtocolProtos.SetVolumePropertyResponse.newBuilder().setResponse(true).build());
            omClientResponse = new OMVolumeSetOwnerResponse(omResponse.build(), oldOwner, oldOwnerVolumeList, newOwnerVolumeList, omVolumeArgs);
        }
        catch (IOException ex) {
            try {
                exception = ex;
                omClientResponse = new OMVolumeSetOwnerResponse(this.createErrorOMResponse(omResponse, exception));
            }
            catch (Throwable var25_24) {
                this.addResponseToDoubleBuffer(transactionLogIndex, omClientResponse, ozoneManagerDoubleBufferHelper);
                if (acquiredUserLocks) {
                    omMetadataManager.getLock().releaseMultiUserLock(newOwner, oldOwner);
                }
                if (acquiredVolumeLock) {
                    omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
                }
                throw var25_24;
            }
            this.addResponseToDoubleBuffer(transactionLogIndex, omClientResponse, ozoneManagerDoubleBufferHelper);
            if (acquiredUserLocks) {
                omMetadataManager.getLock().releaseMultiUserLock(newOwner, oldOwner);
            }
            if (acquiredVolumeLock) {
                omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
            } else {
                ** GOTO lbl86
            }
        }
        this.addResponseToDoubleBuffer(transactionLogIndex, omClientResponse, ozoneManagerDoubleBufferHelper);
        if (acquiredUserLocks) {
            omMetadataManager.getLock().releaseMultiUserLock(newOwner, oldOwner);
        }
        if (acquiredVolumeLock) {
            omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
        }
        this.auditLog(auditLogger, this.buildAuditMessage((AuditAction)OMAction.SET_OWNER, auditMap, exception, userInfo));
        if (exception == null) {
            OMVolumeSetOwnerRequest.LOG.debug("Successfully changed Owner of Volume {} from {} -> {}", new Object[]{volume, oldOwner, newOwner});
        } else {
            OMVolumeSetOwnerRequest.LOG.error("Changing volume ownership failed for user:{} volume:{}", new Object[]{newOwner, volume, exception});
            omMetrics.incNumVolumeUpdateFails();
        }
        return omClientResponse;
    }
}

