/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.volume.acl;

import com.google.common.base.Optional;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hdds.scm.storage.CheckedBiFunction;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerDoubleBufferHelper;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.volume.OMVolumeRequest;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;

public abstract class OMVolumeAclRequest
extends OMVolumeRequest {
    private CheckedBiFunction<List<OzoneAcl>, OmVolumeArgs, IOException> omVolumeAclOp;

    public OMVolumeAclRequest(OzoneManagerProtocolProtos.OMRequest omRequest, CheckedBiFunction<List<OzoneAcl>, OmVolumeArgs, IOException> aclOp) {
        super(omRequest);
        this.omVolumeAclOp = aclOp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long trxnLogIndex, OzoneManagerDoubleBufferHelper omDoubleBufferHelper) {
        volume = this.getVolumeName();
        ozoneAcls = this.getAcls();
        omMetrics = ozoneManager.getMetrics();
        omMetrics.incNumVolumeUpdates();
        omVolumeArgs = null;
        omResponse = this.onInit();
        omClientResponse = null;
        exception = null;
        omMetadataManager = ozoneManager.getMetadataManager();
        lockAcquired = false;
        result = null;
        try {
            if (ozoneManager.getAclsEnabled()) {
                this.checkAcls(ozoneManager, OzoneObj.ResourceType.VOLUME, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.WRITE_ACL, volume, null, null);
            }
            lockAcquired = omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
            omVolumeArgs = this.getVolumeInfo(omMetadataManager, volume);
            applyAcl = true;
            try {
                this.omVolumeAclOp.apply(ozoneAcls, (Object)omVolumeArgs);
            }
            catch (OMException ex) {
                applyAcl = false;
            }
            if (applyAcl) {
                omVolumeArgs.setUpdateID(trxnLogIndex, ozoneManager.isRatisEnabled());
                omMetadataManager.getVolumeTable().addCacheEntry(new CacheKey((Object)omMetadataManager.getVolumeKey(volume)), new CacheValue(Optional.of((Object)omVolumeArgs), trxnLogIndex));
            }
            omClientResponse = this.onSuccess(omResponse, omVolumeArgs, applyAcl);
            result = OMClientRequest.Result.SUCCESS;
        }
        catch (IOException ex) {
            try {
                result = OMClientRequest.Result.FAILURE;
                exception = ex;
                omMetrics.incNumVolumeUpdateFails();
                omClientResponse = this.onFailure(omResponse, ex);
            }
            catch (Throwable var17_17) {
                this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
                if (lockAcquired) {
                    omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
                }
                throw var17_17;
            }
            this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
            if (lockAcquired) {
                omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
            } else {
                ** GOTO lbl47
            }
        }
        this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
        if (lockAcquired) {
            omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
        }
        this.onComplete(result, exception, trxnLogIndex);
        return omClientResponse;
    }

    abstract List<OzoneAcl> getAcls();

    abstract String getVolumeName();

    abstract OzoneManagerProtocolProtos.OMResponse.Builder onInit();

    abstract OMClientResponse onSuccess(OzoneManagerProtocolProtos.OMResponse.Builder var1, OmVolumeArgs var2, boolean var3);

    abstract OMClientResponse onFailure(OzoneManagerProtocolProtos.OMResponse.Builder var1, IOException var2);

    abstract void onComplete(OMClientRequest.Result var1, IOException var2, long var3);
}

