/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.volume.acl;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hdds.scm.storage.CheckedBiFunction;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.request.volume.acl.OMVolumeAclRequest;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.volume.OMVolumeAclOpResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMVolumeSetAclRequest
extends OMVolumeAclRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMVolumeSetAclRequest.class);
    private static CheckedBiFunction<List<OzoneAcl>, OmVolumeArgs, IOException> volumeSetAclOp = (acls, volArgs) -> volArgs.setAcls(acls);
    private List<OzoneAcl> ozoneAcls;
    private String volumeName;

    public OMVolumeSetAclRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest, volumeSetAclOp);
        OzoneManagerProtocolProtos.SetAclRequest setAclRequest = this.getOmRequest().getSetAclRequest();
        Preconditions.checkNotNull((Object)setAclRequest);
        this.ozoneAcls = new ArrayList<OzoneAcl>();
        setAclRequest.getAclList().forEach(oai -> this.ozoneAcls.add(OzoneAcl.fromProtobuf((OzoneManagerProtocolProtos.OzoneAclInfo)oai)));
        this.volumeName = setAclRequest.getObj().getPath().substring(1);
    }

    @Override
    public List<OzoneAcl> getAcls() {
        return this.ozoneAcls;
    }

    @Override
    public String getVolumeName() {
        return this.volumeName;
    }

    @Override
    OzoneManagerProtocolProtos.OMResponse.Builder onInit() {
        return OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
    }

    @Override
    OMClientResponse onSuccess(OzoneManagerProtocolProtos.OMResponse.Builder omResponse, OmVolumeArgs omVolumeArgs, boolean aclApplied) {
        omResponse.setSetAclResponse(OzoneManagerProtocolProtos.SetAclResponse.newBuilder().setResponse(aclApplied).build());
        return new OMVolumeAclOpResponse(omResponse.build(), omVolumeArgs);
    }

    @Override
    OMClientResponse onFailure(OzoneManagerProtocolProtos.OMResponse.Builder omResponse, IOException ex) {
        return new OMVolumeAclOpResponse(this.createErrorOMResponse(omResponse, ex));
    }

    @Override
    void onComplete(OMClientRequest.Result result, IOException ex, long trxnLogIndex) {
        switch (result) {
            case SUCCESS: {
                if (!LOG.isDebugEnabled()) break;
                LOG.debug("Set acls: {} to volume: {} success!", this.getAcls(), (Object)this.getVolumeName());
                break;
            }
            case FAILURE: {
                LOG.error("Set acls {} to volume {} failed!", new Object[]{this.getAcls(), this.getVolumeName(), ex});
                break;
            }
            default: {
                LOG.error("Unrecognized Result for OMVolumeSetAclRequest: {}", (Object)this.getOmRequest());
            }
        }
    }
}

