/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

public abstract class OMClientResponse {
    private OzoneManagerProtocolProtos.OMResponse omResponse;
    private CompletableFuture<Void> flushFuture = null;

    public OMClientResponse(OzoneManagerProtocolProtos.OMResponse omResponse) {
        Preconditions.checkNotNull((Object)omResponse);
        this.omResponse = omResponse;
    }

    public void checkStatusNotOK() {
        Preconditions.checkArgument((!this.omResponse.getStatus().equals((Object)OzoneManagerProtocolProtos.Status.OK) ? 1 : 0) != 0);
    }

    public void checkAndUpdateDB(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        if (this.omResponse.getStatus() == OzoneManagerProtocolProtos.Status.OK) {
            this.addToDBBatch(omMetadataManager, batchOperation);
        }
    }

    protected abstract void addToDBBatch(OMMetadataManager var1, BatchOperation var2) throws IOException;

    public OzoneManagerProtocolProtos.OMResponse getOMResponse() {
        return this.omResponse;
    }

    public void setFlushFuture(CompletableFuture<Void> flushFuture) {
        this.flushFuture = flushFuture;
    }

    public CompletableFuture<Void> getFlushFuture() {
        return this.flushFuture;
    }
}

