/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.key;

import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.RepeatedOmKeyInfo;
import org.apache.hadoop.ozone.om.response.CleanupTableInfo;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

@CleanupTableInfo(cleanupTables={"keyTable"})
public class OMKeysDeleteResponse
extends OMClientResponse {
    private List<OmKeyInfo> omKeyInfoList;
    private boolean isRatisEnabled;
    private long trxnLogIndex;

    public OMKeysDeleteResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, @Nonnull List<OmKeyInfo> keyDeleteList, long trxnLogIndex, boolean isRatisEnabled) {
        super(omResponse);
        this.omKeyInfoList = keyDeleteList;
        this.isRatisEnabled = isRatisEnabled;
        this.trxnLogIndex = trxnLogIndex;
    }

    public OMKeysDeleteResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse) {
        super(omResponse);
        this.checkStatusNotOK();
    }

    @Override
    public void checkAndUpdateDB(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        if (this.getOMResponse().getStatus() == OzoneManagerProtocolProtos.Status.OK || this.getOMResponse().getStatus() == OzoneManagerProtocolProtos.Status.PARTIAL_DELETE) {
            this.addToDBBatch(omMetadataManager, batchOperation);
        }
    }

    @Override
    public void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        String volumeName = "";
        String bucketName = "";
        String keyName = "";
        for (OmKeyInfo omKeyInfo : this.omKeyInfoList) {
            volumeName = omKeyInfo.getVolumeName();
            bucketName = omKeyInfo.getBucketName();
            keyName = omKeyInfo.getKeyName();
            String deleteKey = omMetadataManager.getOzoneKey(volumeName, bucketName, keyName);
            omMetadataManager.getKeyTable().deleteWithBatch(batchOperation, (Object)deleteKey);
            RepeatedOmKeyInfo repeatedOmKeyInfo = (RepeatedOmKeyInfo)omMetadataManager.getDeletedTable().get((Object)deleteKey);
            repeatedOmKeyInfo = OmUtils.prepareKeyForDelete((OmKeyInfo)omKeyInfo, (RepeatedOmKeyInfo)repeatedOmKeyInfo, (long)this.trxnLogIndex, (boolean)this.isRatisEnabled);
            omMetadataManager.getDeletedTable().putWithBatch(batchOperation, (Object)deleteKey, (Object)repeatedOmKeyInfo);
        }
    }
}

