/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.security;

import java.io.IOException;
import java.util.EnumSet;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.annotation.InterfaceStability;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.security.token.OzoneBlockTokenIdentifier;
import org.apache.hadoop.hdds.security.x509.SecurityConfig;
import org.apache.hadoop.hdds.security.x509.certificate.client.CertificateClient;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ozone.security.OzoneSecretManager;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class OzoneBlockTokenSecretManager
extends OzoneSecretManager<OzoneBlockTokenIdentifier> {
    private static final Logger LOG = LoggerFactory.getLogger(OzoneBlockTokenSecretManager.class);
    static final Text SERVICE = new Text("HDDS_SERVICE");
    private final String omCertSerialId;

    public OzoneBlockTokenSecretManager(SecurityConfig conf, long blockTokenExpirytime, String omCertSerialId) {
        super(conf, blockTokenExpirytime, blockTokenExpirytime, SERVICE, LOG);
        this.omCertSerialId = omCertSerialId;
    }

    public OzoneBlockTokenIdentifier createIdentifier() {
        throw new SecurityException("Ozone block token can't be created without owner and access mode information.");
    }

    public OzoneBlockTokenIdentifier createIdentifier(String owner, String blockId, EnumSet<HddsProtos.BlockTokenSecretProto.AccessModeProto> modes, long maxLength) {
        return new OzoneBlockTokenIdentifier(owner, blockId, modes, this.getTokenExpiryTime(), this.omCertSerialId, maxLength);
    }

    public Token<OzoneBlockTokenIdentifier> generateToken(String user, String blockId, EnumSet<HddsProtos.BlockTokenSecretProto.AccessModeProto> modes, long maxLength) {
        OzoneBlockTokenIdentifier tokenIdentifier = this.createIdentifier(user, blockId, modes, maxLength);
        if (LOG.isTraceEnabled()) {
            long expiryTime = tokenIdentifier.getExpiryDate();
            String tokenId = tokenIdentifier.toString();
            LOG.trace("Issued delegation token -> expiryTime:{}, tokenId:{}", (Object)expiryTime, (Object)tokenId);
        }
        return new Token(tokenIdentifier.getBytes(), this.createPassword(tokenIdentifier), tokenIdentifier.getKind(), new Text(blockId));
    }

    public Token<OzoneBlockTokenIdentifier> generateToken(String blockId, EnumSet<HddsProtos.BlockTokenSecretProto.AccessModeProto> modes, long maxLength) throws IOException {
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        String userID = ugi == null ? null : ugi.getShortUserName();
        return this.generateToken(userID, blockId, modes, maxLength);
    }

    public byte[] retrievePassword(OzoneBlockTokenIdentifier identifier) throws SecretManager.InvalidToken {
        this.validateToken(identifier);
        return this.createPassword(identifier);
    }

    @Override
    public long renewToken(Token<OzoneBlockTokenIdentifier> token, String renewer) throws IOException {
        throw new UnsupportedOperationException("Renew token operation is not supported for ozone block tokens.");
    }

    @Override
    public OzoneBlockTokenIdentifier cancelToken(Token<OzoneBlockTokenIdentifier> token, String canceller) throws IOException {
        throw new UnsupportedOperationException("Cancel token operation is not supported for ozone block tokens.");
    }

    public boolean validateToken(OzoneBlockTokenIdentifier identifier) throws SecretManager.InvalidToken {
        long now = Time.now();
        if (identifier.getExpiryDate() < now) {
            throw new SecretManager.InvalidToken("token " + this.formatTokenId(identifier) + " is expired, current time: " + Time.formatTime((long)now) + " expiry time: " + identifier.getExpiryDate());
        }
        if (!this.verifySignature(identifier, this.createPassword(identifier))) {
            throw new SecretManager.InvalidToken("Tampered/Invalid token.");
        }
        return true;
    }

    public boolean verifySignature(OzoneBlockTokenIdentifier identifier, byte[] password) {
        throw new UnsupportedOperationException("This operation is not supported for block tokens.");
    }

    @Override
    public synchronized void start(CertificateClient client) throws IOException {
        super.start(client);
    }

    private long getTokenExpiryTime() {
        return Time.now() + this.getTokenRenewInterval();
    }

    @Override
    public synchronized void stop() throws IOException {
        super.stop();
    }
}

