/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.security.acl;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.annotation.InterfaceStability;
import org.apache.hadoop.ozone.om.BucketManager;
import org.apache.hadoop.ozone.om.KeyManager;
import org.apache.hadoop.ozone.om.PrefixManager;
import org.apache.hadoop.ozone.om.VolumeManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.IOzoneObj;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.ozone.security.acl.OzoneObjInfo;
import org.apache.hadoop.ozone.security.acl.RequestContext;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "Yarn", "Ranger", "Hive", "HBase"})
@InterfaceStability.Evolving
public class OzoneNativeAuthorizer
implements IAccessAuthorizer {
    private static final Logger LOG = LoggerFactory.getLogger(OzoneNativeAuthorizer.class);
    private VolumeManager volumeManager;
    private BucketManager bucketManager;
    private KeyManager keyManager;
    private PrefixManager prefixManager;
    private Collection<String> ozAdmins;

    public OzoneNativeAuthorizer() {
    }

    public OzoneNativeAuthorizer(VolumeManager volumeManager, BucketManager bucketManager, KeyManager keyManager, PrefixManager prefixManager, Collection<String> ozoneAdmins) {
        this.volumeManager = volumeManager;
        this.bucketManager = bucketManager;
        this.keyManager = keyManager;
        this.prefixManager = prefixManager;
        this.ozAdmins = ozoneAdmins;
    }

    public boolean checkAccess(IOzoneObj ozObject, RequestContext context) throws OMException {
        boolean isACLTypeDelete;
        Objects.requireNonNull(ozObject);
        Objects.requireNonNull(context);
        boolean isACLTypeCreate = context.getAclRights() == IAccessAuthorizer.ACLType.CREATE;
        boolean bl = isACLTypeDelete = context.getAclRights() == IAccessAuthorizer.ACLType.DELETE;
        if (!(ozObject instanceof OzoneObjInfo)) {
            throw new OMException("Unexpected input received. OM native acls are configured to work with OzoneObjInfo type only.", OMException.ResultCodes.INVALID_REQUEST);
        }
        OzoneObjInfo objInfo = (OzoneObjInfo)ozObject;
        boolean isAdmin = this.isAdmin(context.getClientUgi());
        if (isAdmin) {
            return true;
        }
        boolean isListAllVolume = context.getAclRights() == IAccessAuthorizer.ACLType.LIST && objInfo.getVolumeName().equals("/");
        RequestContext parentContext = isACLTypeCreate || isACLTypeDelete ? RequestContext.newBuilder().setClientUgi(context.getClientUgi()).setIp(context.getIp()).setAclType(context.getAclType()).setAclRights(IAccessAuthorizer.ACLType.WRITE).build() : context;
        switch (objInfo.getResourceType()) {
            case VOLUME: {
                LOG.trace("Checking access for volume: {}", (Object)objInfo);
                if (isACLTypeCreate || isListAllVolume) {
                    return false;
                }
                return this.volumeManager.checkAccess((OzoneObj)objInfo, context);
            }
            case BUCKET: {
                LOG.trace("Checking access for bucket: {}", (Object)objInfo);
                boolean bucketAccess = isACLTypeCreate || this.bucketManager.checkAccess((OzoneObj)objInfo, context);
                return bucketAccess && this.volumeManager.checkAccess((OzoneObj)objInfo, parentContext);
            }
            case KEY: {
                LOG.trace("Checking access for Key: {}", (Object)objInfo);
                boolean keyAccess = isACLTypeCreate || this.keyManager.checkAccess((OzoneObj)objInfo, context);
                return keyAccess && this.prefixManager.checkAccess((OzoneObj)objInfo, parentContext) && this.bucketManager.checkAccess((OzoneObj)objInfo, parentContext) && this.volumeManager.checkAccess((OzoneObj)objInfo, parentContext);
            }
            case PREFIX: {
                LOG.trace("Checking access for Prefix: {}", (Object)objInfo);
                boolean prefixAccess = isACLTypeCreate || this.prefixManager.checkAccess((OzoneObj)objInfo, context);
                return prefixAccess && this.bucketManager.checkAccess((OzoneObj)objInfo, parentContext) && this.volumeManager.checkAccess((OzoneObj)objInfo, parentContext);
            }
        }
        throw new OMException("Unexpected object type:" + objInfo.getResourceType(), OMException.ResultCodes.INVALID_REQUEST);
    }

    public void setVolumeManager(VolumeManager volumeManager) {
        this.volumeManager = volumeManager;
    }

    public void setBucketManager(BucketManager bucketManager) {
        this.bucketManager = bucketManager;
    }

    public void setKeyManager(KeyManager keyManager) {
        this.keyManager = keyManager;
    }

    public void setPrefixManager(PrefixManager prefixManager) {
        this.prefixManager = prefixManager;
    }

    public void setOzoneAdmins(Collection<String> ozoneAdmins) {
        this.ozAdmins = ozoneAdmins;
    }

    public Collection<String> getOzoneAdmins() {
        return Collections.unmodifiableCollection(this.ozAdmins);
    }

    private boolean isAdmin(UserGroupInformation callerUgi) {
        if (this.ozAdmins == null) {
            return false;
        }
        return this.ozAdmins.contains(callerUgi.getShortUserName()) || this.ozAdmins.contains(callerUgi.getUserName()) || this.ozAdmins.contains("*");
    }
}

