/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import com.google.common.base.Strings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.TableIterator;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.PrefixManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmPrefixInfo;
import org.apache.hadoop.ozone.om.helpers.OzoneAclUtil;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.ozone.security.acl.RequestContext;
import org.apache.hadoop.ozone.util.RadixNode;
import org.apache.hadoop.ozone.util.RadixTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrefixManagerImpl
implements PrefixManager {
    private static final Logger LOG = LoggerFactory.getLogger(PrefixManagerImpl.class);
    private static final List<OzoneAcl> EMPTY_ACL_LIST = new ArrayList<OzoneAcl>();
    private final OMMetadataManager metadataManager;
    private RadixTree<OmPrefixInfo> prefixTree;
    private boolean isRatisEnabled;

    public PrefixManagerImpl(OMMetadataManager metadataManager, boolean isRatisEnabled) {
        this.isRatisEnabled = isRatisEnabled;
        this.metadataManager = metadataManager;
        this.loadPrefixTree();
    }

    private void loadPrefixTree() {
        this.prefixTree = new RadixTree();
        try (TableIterator iterator = this.getMetadataManager().getPrefixTable().iterator();){
            iterator.seekToFirst();
            while (iterator.hasNext()) {
                Table.KeyValue kv = (Table.KeyValue)iterator.next();
                this.prefixTree.insert((String)kv.getKey(), kv.getValue());
            }
        }
        catch (IOException ex) {
            LOG.error("Fail to load prefix tree");
        }
    }

    @Override
    public OMMetadataManager getMetadataManager() {
        return this.metadataManager;
    }

    @Override
    public boolean addAcl(OzoneObj obj, OzoneAcl acl) throws IOException {
        boolean bl;
        this.validateOzoneObj(obj);
        String prefixPath = obj.getPath();
        this.metadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.PREFIX_LOCK, new String[]{prefixPath});
        try {
            OmPrefixInfo prefixInfo = (OmPrefixInfo)this.metadataManager.getPrefixTable().get((Object)prefixPath);
            OMPrefixAclOpResult omPrefixAclOpResult = this.addAcl(obj, acl, prefixInfo, 0L);
            bl = omPrefixAclOpResult.isSuccess();
        }
        catch (IOException ex) {
            try {
                if (!(ex instanceof OMException)) {
                    LOG.error("Add acl operation failed for prefix path:{} acl:{}", new Object[]{prefixPath, acl, ex});
                }
                throw ex;
            }
            catch (Throwable throwable) {
                this.metadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.PREFIX_LOCK, new String[]{prefixPath});
                throw throwable;
            }
        }
        this.metadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.PREFIX_LOCK, new String[]{prefixPath});
        return bl;
    }

    @Override
    public boolean removeAcl(OzoneObj obj, OzoneAcl acl) throws IOException {
        boolean bl;
        OMPrefixAclOpResult omPrefixAclOpResult;
        String prefixPath;
        block7: {
            this.validateOzoneObj(obj);
            prefixPath = obj.getPath();
            this.metadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.PREFIX_LOCK, new String[]{prefixPath});
            OmPrefixInfo prefixInfo = (OmPrefixInfo)this.metadataManager.getPrefixTable().get((Object)prefixPath);
            omPrefixAclOpResult = this.removeAcl(obj, acl, prefixInfo);
            if (omPrefixAclOpResult.isSuccess()) break block7;
            if (LOG.isDebugEnabled()) {
                LOG.debug("acl {} does not exist for prefix path {} ", (Object)acl, (Object)prefixPath);
            }
            boolean bl2 = false;
            this.metadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.PREFIX_LOCK, new String[]{prefixPath});
            return bl2;
        }
        try {
            bl = omPrefixAclOpResult.isSuccess();
        }
        catch (IOException ex) {
            try {
                if (!(ex instanceof OMException)) {
                    LOG.error("Remove prefix acl operation failed for prefix path:{} acl:{}", new Object[]{prefixPath, acl, ex});
                }
                throw ex;
            }
            catch (Throwable throwable) {
                this.metadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.PREFIX_LOCK, new String[]{prefixPath});
                throw throwable;
            }
        }
        this.metadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.PREFIX_LOCK, new String[]{prefixPath});
        return bl;
    }

    @Override
    public boolean setAcl(OzoneObj obj, List<OzoneAcl> acls) throws IOException {
        boolean bl;
        this.validateOzoneObj(obj);
        String prefixPath = obj.getPath();
        this.metadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.PREFIX_LOCK, new String[]{prefixPath});
        try {
            OmPrefixInfo prefixInfo = (OmPrefixInfo)this.metadataManager.getPrefixTable().get((Object)prefixPath);
            OMPrefixAclOpResult omPrefixAclOpResult = this.setAcl(obj, acls, prefixInfo, 0L);
            bl = omPrefixAclOpResult.isSuccess();
        }
        catch (IOException ex) {
            try {
                if (!(ex instanceof OMException)) {
                    LOG.error("Set prefix acl operation failed for prefix path:{} acls:{}", new Object[]{prefixPath, acls, ex});
                }
                throw ex;
            }
            catch (Throwable throwable) {
                this.metadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.PREFIX_LOCK, new String[]{prefixPath});
                throw throwable;
            }
        }
        this.metadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.PREFIX_LOCK, new String[]{prefixPath});
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<OzoneAcl> getAcl(OzoneObj obj) throws IOException {
        String prefixPath;
        block2: {
            List list;
            this.validateOzoneObj(obj);
            prefixPath = obj.getPath();
            this.metadataManager.getLock().acquireReadLock(OzoneManagerLock.Resource.PREFIX_LOCK, new String[]{prefixPath});
            try {
                RadixNode lastNode;
                String longestPrefix = this.prefixTree.getLongestPrefix(prefixPath);
                if (!prefixPath.equals(longestPrefix) || (lastNode = this.prefixTree.getLastNodeInPrefixPath(prefixPath)) == null || lastNode.getValue() == null) break block2;
                list = ((OmPrefixInfo)lastNode.getValue()).getAcls();
            }
            catch (Throwable throwable) {
                this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.PREFIX_LOCK, new String[]{prefixPath});
                throw throwable;
            }
            this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.PREFIX_LOCK, new String[]{prefixPath});
            return list;
        }
        this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.PREFIX_LOCK, new String[]{prefixPath});
        return EMPTY_ACL_LIST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkAccess(OzoneObj ozObject, RequestContext context) throws OMException {
        String prefixPath;
        block5: {
            block6: {
                boolean bl;
                Objects.requireNonNull(ozObject);
                Objects.requireNonNull(context);
                prefixPath = ozObject.getPath();
                this.metadataManager.getLock().acquireReadLock(OzoneManagerLock.Resource.PREFIX_LOCK, new String[]{prefixPath});
                try {
                    String longestPrefix = this.prefixTree.getLongestPrefix(prefixPath);
                    if (!prefixPath.equals(longestPrefix)) break block5;
                    RadixNode lastNode = this.prefixTree.getLastNodeInPrefixPath(prefixPath);
                    if (lastNode == null || lastNode.getValue() == null) break block6;
                    boolean hasAccess = OzoneAclUtil.checkAclRights((List)((OmPrefixInfo)lastNode.getValue()).getAcls(), (RequestContext)context);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("user:{} has access rights for ozObj:{} ::{} ", new Object[]{context.getClientUgi(), ozObject, hasAccess});
                    }
                    bl = hasAccess;
                }
                catch (Throwable throwable) {
                    this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.PREFIX_LOCK, new String[]{prefixPath});
                    throw throwable;
                }
                this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.PREFIX_LOCK, new String[]{prefixPath});
                return bl;
            }
            boolean bl = true;
            this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.PREFIX_LOCK, new String[]{prefixPath});
            return bl;
        }
        boolean bl = true;
        this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.PREFIX_LOCK, new String[]{prefixPath});
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<OmPrefixInfo> getLongestPrefixPath(String path) {
        List<OmPrefixInfo> list;
        String prefixPath = this.prefixTree.getLongestPrefix(path);
        this.metadataManager.getLock().acquireReadLock(OzoneManagerLock.Resource.PREFIX_LOCK, new String[]{prefixPath});
        try {
            list = this.getLongestPrefixPathHelper(prefixPath);
        }
        catch (Throwable throwable) {
            this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.PREFIX_LOCK, new String[]{prefixPath});
            throw throwable;
        }
        this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.PREFIX_LOCK, new String[]{prefixPath});
        return list;
    }

    private List<OmPrefixInfo> getLongestPrefixPathHelper(String prefixPath) {
        return this.prefixTree.getLongestPrefixPath(prefixPath).stream().map(c -> (OmPrefixInfo)c.getValue()).collect(Collectors.toList());
    }

    public void validateOzoneObj(OzoneObj obj) throws OMException {
        Objects.requireNonNull(obj);
        if (!obj.getResourceType().equals((Object)OzoneObj.ResourceType.PREFIX)) {
            throw new IllegalArgumentException("Unexpected argument passed to PrefixManager. OzoneObj type:" + obj.getResourceType());
        }
        String volume = obj.getVolumeName();
        String bucket = obj.getBucketName();
        String prefixName = obj.getPrefixName();
        if (Strings.isNullOrEmpty((String)volume)) {
            throw new OMException("Volume name is required.", OMException.ResultCodes.VOLUME_NOT_FOUND);
        }
        if (Strings.isNullOrEmpty((String)bucket)) {
            throw new OMException("Bucket name is required.", OMException.ResultCodes.BUCKET_NOT_FOUND);
        }
        if (Strings.isNullOrEmpty((String)prefixName)) {
            throw new OMException("Prefix name is required.", OMException.ResultCodes.PREFIX_NOT_FOUND);
        }
        if (!prefixName.endsWith("/")) {
            throw new OMException("Invalid prefix name: " + prefixName, OMException.ResultCodes.PREFIX_NOT_FOUND);
        }
    }

    public OMPrefixAclOpResult addAcl(OzoneObj ozoneObj, OzoneAcl ozoneAcl, OmPrefixInfo prefixInfo, long transactionLogIndex) throws IOException {
        boolean changed;
        if (prefixInfo == null) {
            OmPrefixInfo.Builder prefixInfoBuilder = new OmPrefixInfo.Builder().setName(ozoneObj.getPath());
            if (transactionLogIndex > 0L) {
                prefixInfoBuilder.setObjectID(OmUtils.getObjectIdFromTxId((long)this.metadataManager.getOmEpoch(), (long)transactionLogIndex));
                prefixInfoBuilder.setUpdateID(transactionLogIndex);
            }
            prefixInfo = prefixInfoBuilder.build();
        }
        if (changed = prefixInfo.addAcl(ozoneAcl)) {
            this.prefixTree.insert(ozoneObj.getPath(), (Object)prefixInfo);
            if (!this.isRatisEnabled) {
                this.metadataManager.getPrefixTable().put((Object)ozoneObj.getPath(), (Object)prefixInfo);
            }
        }
        return new OMPrefixAclOpResult(prefixInfo, changed);
    }

    public OMPrefixAclOpResult removeAcl(OzoneObj ozoneObj, OzoneAcl ozoneAcl, OmPrefixInfo prefixInfo) throws IOException {
        boolean removed = false;
        if (prefixInfo != null) {
            removed = prefixInfo.removeAcl(ozoneAcl);
        }
        if (removed) {
            if (prefixInfo.getAcls().isEmpty()) {
                this.prefixTree.removePrefixPath(ozoneObj.getPath());
                if (!this.isRatisEnabled) {
                    this.metadataManager.getPrefixTable().delete((Object)ozoneObj.getPath());
                }
            } else {
                this.prefixTree.insert(ozoneObj.getPath(), (Object)prefixInfo);
                if (!this.isRatisEnabled) {
                    this.metadataManager.getPrefixTable().put((Object)ozoneObj.getPath(), (Object)prefixInfo);
                }
            }
        }
        return new OMPrefixAclOpResult(prefixInfo, removed);
    }

    public OMPrefixAclOpResult setAcl(OzoneObj ozoneObj, List<OzoneAcl> ozoneAcls, OmPrefixInfo prefixInfo, long transactionLogIndex) throws IOException {
        boolean changed;
        if (prefixInfo == null) {
            OmPrefixInfo.Builder prefixInfoBuilder = new OmPrefixInfo.Builder().setName(ozoneObj.getPath());
            if (transactionLogIndex > 0L) {
                prefixInfoBuilder.setObjectID(OmUtils.getObjectIdFromTxId((long)this.metadataManager.getOmEpoch(), (long)transactionLogIndex));
                prefixInfoBuilder.setUpdateID(transactionLogIndex);
            }
            prefixInfo = prefixInfoBuilder.build();
        }
        if (changed = prefixInfo.setAcls(ozoneAcls)) {
            OmPrefixInfo parentPrefixInfo;
            List aclsToBeSet = prefixInfo.getAcls();
            boolean prefixParentFound = false;
            List<OmPrefixInfo> prefixList = this.getLongestPrefixPathHelper(this.prefixTree.getLongestPrefix(ozoneObj.getPath()));
            if (prefixList.size() > 0 && (parentPrefixInfo = prefixList.get(prefixList.size() - 1)) != null) {
                prefixParentFound = OzoneAclUtil.inheritDefaultAcls((List)aclsToBeSet, (List)parentPrefixInfo.getAcls());
            }
            if (!prefixParentFound) {
                String bucketKey = this.metadataManager.getBucketKey(ozoneObj.getVolumeName(), ozoneObj.getBucketName());
                OmBucketInfo bucketInfo = (OmBucketInfo)this.metadataManager.getBucketTable().get((Object)bucketKey);
                if (bucketInfo != null) {
                    OzoneAclUtil.inheritDefaultAcls((List)aclsToBeSet, (List)bucketInfo.getAcls());
                }
            }
            this.prefixTree.insert(ozoneObj.getPath(), (Object)prefixInfo);
            if (!this.isRatisEnabled) {
                this.metadataManager.getPrefixTable().put((Object)ozoneObj.getPath(), (Object)prefixInfo);
            }
        }
        return new OMPrefixAclOpResult(prefixInfo, changed);
    }

    public static class OMPrefixAclOpResult {
        private OmPrefixInfo omPrefixInfo;
        private boolean operationsResult;

        public OMPrefixAclOpResult(OmPrefixInfo omPrefixInfo, boolean operationsResult) {
            this.omPrefixInfo = omPrefixInfo;
            this.operationsResult = operationsResult;
        }

        public OmPrefixInfo getOmPrefixInfo() {
            return this.omPrefixInfo;
        }

        public boolean isSuccess() {
            return this.operationsResult;
        }
    }
}

