/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.ozone.om.helpers.OmKeyArgs;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

public class ResolvedBucket {
    private final Pair<String, String> requested;
    private final Pair<String, String> resolved;

    public ResolvedBucket(Pair<String, String> requested, Pair<String, String> resolved) {
        this.requested = requested;
        this.resolved = resolved;
    }

    public Pair<String, String> requested() {
        return this.requested;
    }

    public Pair<String, String> resolved() {
        return this.resolved;
    }

    public String requestedVolume() {
        return (String)this.requested.getLeft();
    }

    public String requestedBucket() {
        return (String)this.requested.getRight();
    }

    public String realVolume() {
        return (String)this.resolved.getLeft();
    }

    public String realBucket() {
        return (String)this.resolved.getRight();
    }

    public OmKeyArgs update(OmKeyArgs args) {
        return this.isLink() ? args.toBuilder().setVolumeName(this.realVolume()).setBucketName(this.realBucket()).build() : args;
    }

    public OzoneManagerProtocolProtos.KeyArgs update(OzoneManagerProtocolProtos.KeyArgs args) {
        return this.isLink() ? args.toBuilder().setVolumeName(this.realVolume()).setBucketName(this.realBucket()).build() : args;
    }

    public boolean isLink() {
        return !Objects.equals(this.requested, this.resolved);
    }

    public Map<String, String> audit() {
        return this.audit(new LinkedHashMap<String, String>());
    }

    public Map<String, String> audit(Map<String, String> auditMap) {
        auditMap.putIfAbsent("volume", this.requestedVolume());
        auditMap.putIfAbsent("bucket", this.requestedBucket());
        if (this.isLink()) {
            auditMap.put("sourceVolume", this.realVolume());
            auditMap.put("sourceBucket", this.realBucket());
        }
        return auditMap;
    }
}

