/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.bucket;

import com.google.common.base.Optional;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.crypto.CipherSuite;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.crypto.key.KeyProviderCryptoExtension;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.om.helpers.OzoneAclUtil;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerDoubleBufferHelper;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.bucket.OMBucketCreateResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.protocolPB.OMPBHelper;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMBucketCreateRequest
extends OMClientRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMBucketCreateRequest.class);

    public OMBucketCreateRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        OzoneManagerProtocolProtos.CreateBucketRequest createBucketRequest = this.getOmRequest().getCreateBucketRequest();
        OzoneManagerProtocolProtos.BucketInfo bucketInfo = createBucketRequest.getBucketInfo();
        OmUtils.validateBucketName((String)bucketInfo.getBucketName());
        KeyProviderCryptoExtension kmsProvider = ozoneManager.getKmsProvider();
        OzoneManagerProtocolProtos.CreateBucketRequest.Builder newCreateBucketRequest = createBucketRequest.toBuilder();
        OzoneManagerProtocolProtos.BucketInfo.Builder newBucketInfo = bucketInfo.toBuilder();
        long initialTime = Time.now();
        newBucketInfo.setCreationTime(initialTime).setModificationTime(initialTime);
        if (bucketInfo.hasBeinfo()) {
            newBucketInfo.setBeinfo(this.getBeinfo(kmsProvider, bucketInfo));
        }
        boolean hasSourceVolume = bucketInfo.hasSourceVolume();
        boolean hasSourceBucket = bucketInfo.hasSourceBucket();
        if (hasSourceBucket != hasSourceVolume) {
            throw new OMException("Both source volume and source bucket are required for bucket links", OMException.ResultCodes.INVALID_REQUEST);
        }
        if (hasSourceBucket && bucketInfo.hasBeinfo()) {
            throw new OMException("Encryption cannot be set for bucket links", OMException.ResultCodes.INVALID_REQUEST);
        }
        newCreateBucketRequest.setBucketInfo(newBucketInfo.build());
        return this.getOmRequest().toBuilder().setUserInfo(this.getUserInfo()).setCreateBucketRequest(newCreateBucketRequest.build()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long transactionLogIndex, OzoneManagerDoubleBufferHelper ozoneManagerDoubleBufferHelper) {
        omMetrics = ozoneManager.getMetrics();
        omMetrics.incNumBucketCreates();
        metadataManager = ozoneManager.getMetadataManager();
        createBucketRequest = this.getOmRequest().getCreateBucketRequest();
        bucketInfo = createBucketRequest.getBucketInfo();
        volumeName = bucketInfo.getVolumeName();
        bucketName = bucketInfo.getBucketName();
        omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
        omBucketInfo = OmBucketInfo.getFromProtobuf((OzoneManagerProtocolProtos.BucketInfo)bucketInfo);
        auditLogger = ozoneManager.getAuditLogger();
        userInfo = this.getOmRequest().getUserInfo();
        volumeKey = metadataManager.getVolumeKey(volumeName);
        bucketKey = metadataManager.getBucketKey(volumeName, bucketName);
        exception = null;
        acquiredBucketLock = false;
        acquiredVolumeLock = false;
        omClientResponse = null;
        try {
            if (ozoneManager.getAclsEnabled()) {
                this.checkAcls(ozoneManager, OzoneObj.ResourceType.BUCKET, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.CREATE, volumeName, bucketName, null);
            }
            acquiredVolumeLock = metadataManager.getLock().acquireReadLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volumeName});
            acquiredBucketLock = metadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            omVolumeArgs = (OmVolumeArgs)metadataManager.getVolumeTable().getReadCopy((Object)volumeKey);
            if (omVolumeArgs == null) {
                OMBucketCreateRequest.LOG.debug("volume: {} not found ", (Object)volumeName);
                throw new OMException("Volume doesn't exist", OMException.ResultCodes.VOLUME_NOT_FOUND);
            }
            if (metadataManager.getBucketTable().isExist((Object)bucketKey)) {
                OMBucketCreateRequest.LOG.debug("bucket: {} already exists ", (Object)bucketName);
                throw new OMException("Bucket already exist", OMException.ResultCodes.BUCKET_ALREADY_EXISTS);
            }
            this.checkQuotaBytesValid(metadataManager, omVolumeArgs, omBucketInfo, volumeKey);
            omBucketInfo.setObjectID(ozoneManager.getObjectIdFromTxId(transactionLogIndex));
            omBucketInfo.setUpdateID(transactionLogIndex, ozoneManager.isRatisEnabled());
            this.addDefaultAcls(omBucketInfo, omVolumeArgs);
            this.checkQuotaInNamespace(omVolumeArgs, 1L);
            omVolumeArgs.incrUsedNamespace(1L);
            metadataManager.getVolumeTable().addCacheEntry(new CacheKey((Object)volumeKey), new CacheValue(Optional.of((Object)omVolumeArgs), transactionLogIndex));
            metadataManager.getBucketTable().addCacheEntry(new CacheKey((Object)bucketKey), new CacheValue(Optional.of((Object)omBucketInfo), transactionLogIndex));
            omResponse.setCreateBucketResponse(OzoneManagerProtocolProtos.CreateBucketResponse.newBuilder().build());
            omClientResponse = new OMBucketCreateResponse(omResponse.build(), omBucketInfo, omVolumeArgs.copyObject());
        }
        catch (IOException ex) {
            try {
                exception = ex;
                omClientResponse = new OMBucketCreateResponse(this.createErrorOMResponse(omResponse, exception));
            }
            catch (Throwable var22_22) {
                this.addResponseToDoubleBuffer(transactionLogIndex, omClientResponse, ozoneManagerDoubleBufferHelper);
                if (acquiredBucketLock) {
                    metadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                }
                if (acquiredVolumeLock) {
                    metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volumeName});
                }
                throw var22_22;
            }
            this.addResponseToDoubleBuffer(transactionLogIndex, omClientResponse, ozoneManagerDoubleBufferHelper);
            if (acquiredBucketLock) {
                metadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            }
            if (acquiredVolumeLock) {
                metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volumeName});
            } else {
                ** GOTO lbl65
            }
        }
        this.addResponseToDoubleBuffer(transactionLogIndex, omClientResponse, ozoneManagerDoubleBufferHelper);
        if (acquiredBucketLock) {
            metadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        }
        if (acquiredVolumeLock) {
            metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volumeName});
        }
        this.auditLog(auditLogger, this.buildAuditMessage((AuditAction)OMAction.CREATE_BUCKET, omBucketInfo.toAuditMap(), exception, userInfo));
        if (exception == null) {
            OMBucketCreateRequest.LOG.debug("created bucket: {} in volume: {}", (Object)bucketName, (Object)volumeName);
            omMetrics.incNumBuckets();
            return omClientResponse;
        }
        omMetrics.incNumBucketCreateFails();
        OMBucketCreateRequest.LOG.error("Bucket creation failed for bucket:{} in volume:{}", new Object[]{bucketName, volumeName, exception});
        return omClientResponse;
    }

    private void addDefaultAcls(OmBucketInfo omBucketInfo, OmVolumeArgs omVolumeArgs) {
        ArrayList acls = new ArrayList();
        if (omBucketInfo.getAcls() != null) {
            acls.addAll(omBucketInfo.getAcls());
        }
        List defaultVolumeAclList = omVolumeArgs.getAclMap().getDefaultAclList().stream().map(OzoneAcl::fromProtobuf).collect(Collectors.toList());
        OzoneAclUtil.inheritDefaultAcls(acls, defaultVolumeAclList);
        omBucketInfo.setAcls(acls);
    }

    private OzoneManagerProtocolProtos.BucketEncryptionInfoProto getBeinfo(KeyProviderCryptoExtension kmsProvider, OzoneManagerProtocolProtos.BucketInfo bucketInfo) throws IOException {
        OzoneManagerProtocolProtos.BucketEncryptionInfoProto bek = bucketInfo.getBeinfo();
        OzoneManagerProtocolProtos.BucketEncryptionInfoProto.Builder bekb = null;
        if (kmsProvider == null) {
            throw new OMException("Invalid KMS provider, check configuration hadoop.security.key.provider.path", OMException.ResultCodes.INVALID_KMS_PROVIDER);
        }
        if (bek.getKeyName() == null) {
            throw new OMException("Bucket encryption key needed.", OMException.ResultCodes.BUCKET_ENCRYPTION_KEY_NOT_FOUND);
        }
        KeyProvider.Metadata metadata = kmsProvider.getMetadata(bek.getKeyName());
        if (metadata == null) {
            throw new OMException("Bucket encryption key " + bek.getKeyName() + " doesn't exist.", OMException.ResultCodes.BUCKET_ENCRYPTION_KEY_NOT_FOUND);
        }
        kmsProvider.warmUpEncryptedKeys(new String[]{bek.getKeyName()});
        bekb = OzoneManagerProtocolProtos.BucketEncryptionInfoProto.newBuilder().setKeyName(bek.getKeyName()).setCryptoProtocolVersion(OzoneManagerProtocolProtos.CryptoProtocolVersionProto.ENCRYPTION_ZONES).setSuite(OMPBHelper.convert((CipherSuite)CipherSuite.convert((String)metadata.getCipher())));
        return bekb.build();
    }

    private void checkQuotaInNamespace(OmVolumeArgs omVolumeArgs, long allocatedNamespace) throws IOException {
        if (omVolumeArgs.getQuotaInNamespace() > 0L) {
            long toUseNamespaceInTotal;
            long usedNamespace = omVolumeArgs.getUsedNamespace();
            long quotaInNamespace = omVolumeArgs.getQuotaInNamespace();
            if (quotaInNamespace < (toUseNamespaceInTotal = usedNamespace + allocatedNamespace)) {
                throw new OMException("The namespace quota of Volume:" + omVolumeArgs.getVolume() + " exceeded: quotaInNamespace: " + quotaInNamespace + " but namespace consumed: " + toUseNamespaceInTotal + ".", OMException.ResultCodes.QUOTA_EXCEEDED);
            }
        }
    }

    public boolean checkQuotaBytesValid(OMMetadataManager metadataManager, OmVolumeArgs omVolumeArgs, OmBucketInfo omBucketInfo, String volumeKey) throws IOException {
        long quotaInBytes = omBucketInfo.getQuotaInBytes();
        long volumeQuotaInBytes = omVolumeArgs.getQuotaInBytes();
        long totalBucketQuota = 0L;
        if (quotaInBytes <= 0L) {
            return false;
        }
        totalBucketQuota = quotaInBytes;
        List bucketList = metadataManager.listBuckets(omVolumeArgs.getVolume(), null, null, Integer.MAX_VALUE);
        for (OmBucketInfo bucketInfo : bucketList) {
            long nextQuotaInBytes = bucketInfo.getQuotaInBytes();
            if (nextQuotaInBytes <= -1L) continue;
            totalBucketQuota += nextQuotaInBytes;
        }
        if (volumeQuotaInBytes < totalBucketQuota && volumeQuotaInBytes != -1L) {
            throw new IllegalArgumentException("Total buckets quota in this volume should not be greater than volume quota : the total space quota is set to:" + totalBucketQuota + ". But the volume space quota is:" + volumeQuotaInBytes);
        }
        return true;
    }
}

