/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.file;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfoGroup;
import org.apache.hadoop.ozone.om.helpers.OzoneAclUtil;
import org.apache.hadoop.ozone.om.helpers.OzoneFSUtils;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerDoubleBufferHelper;
import org.apache.hadoop.ozone.om.request.file.OMFileRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeyRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.file.OMDirectoryCreateResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMDirectoryCreateRequest
extends OMKeyRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMDirectoryCreateRequest.class);
    private static final long MAX_NUM_OF_RECURSIVE_DIRS = 255L;

    public OMDirectoryCreateRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) {
        OzoneManagerProtocolProtos.CreateDirectoryRequest createDirectoryRequest = this.getOmRequest().getCreateDirectoryRequest();
        Preconditions.checkNotNull((Object)createDirectoryRequest);
        OzoneManagerProtocolProtos.KeyArgs.Builder newKeyArgs = createDirectoryRequest.getKeyArgs().toBuilder().setModificationTime(Time.now());
        OzoneManagerProtocolProtos.CreateDirectoryRequest.Builder newCreateDirectoryRequest = createDirectoryRequest.toBuilder().setKeyArgs(newKeyArgs);
        return this.getOmRequest().toBuilder().setCreateDirectoryRequest(newCreateDirectoryRequest).setUserInfo(this.getUserInfo()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long trxnLogIndex, OzoneManagerDoubleBufferHelper omDoubleBufferHelper) {
        block10: {
            createDirectoryRequest = this.getOmRequest().getCreateDirectoryRequest();
            keyArgs = createDirectoryRequest.getKeyArgs();
            volumeName = keyArgs.getVolumeName();
            bucketName = keyArgs.getBucketName();
            keyName = keyArgs.getKeyName();
            omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
            omResponse.setCreateDirectoryResponse(OzoneManagerProtocolProtos.CreateDirectoryResponse.newBuilder());
            omMetrics = ozoneManager.getMetrics();
            omMetrics.incNumCreateDirectory();
            auditLogger = ozoneManager.getAuditLogger();
            userInfo = this.getOmRequest().getUserInfo();
            auditMap = this.buildKeyArgsAuditMap(keyArgs);
            omMetadataManager = ozoneManager.getMetadataManager();
            acquiredLock = false;
            exception = null;
            omClientResponse = null;
            result = Result.FAILURE;
            numMissingParents = 0;
            try {
                keyArgs = this.resolveBucketLink(ozoneManager, keyArgs, auditMap);
                volumeName = keyArgs.getVolumeName();
                bucketName = keyArgs.getBucketName();
                this.checkKeyAcls(ozoneManager, volumeName, bucketName, keyName, IAccessAuthorizer.ACLType.CREATE, OzoneObj.ResourceType.KEY);
                if (keyName.length() == 0) {
                    throw new OMException("Directory create failed. Cannot create directory at root of the filesystem", OMException.ResultCodes.CANNOT_CREATE_DIRECTORY_AT_ROOT);
                }
                acquiredLock = omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                this.validateBucketAndVolume(omMetadataManager, volumeName, bucketName);
                keyPath = Paths.get(keyName, new String[0]);
                omPathInfo = OMFileRequest.verifyFilesInPath(omMetadataManager, volumeName, bucketName, keyName, keyPath);
                omDirectoryResult = omPathInfo.getDirectoryResult();
                dirKeyInfo = null;
                if (omDirectoryResult == OMFileRequest.OMDirectoryResult.FILE_EXISTS || omDirectoryResult == OMFileRequest.OMDirectoryResult.FILE_EXISTS_IN_GIVENPATH) {
                    throw new OMException("Unable to create directory: " + keyName + " in volume/bucket: " + volumeName + "/" + bucketName, OMException.ResultCodes.FILE_ALREADY_EXISTS);
                }
                if (omDirectoryResult == OMFileRequest.OMDirectoryResult.DIRECTORY_EXISTS_IN_GIVENPATH || omDirectoryResult == OMFileRequest.OMDirectoryResult.NONE) {
                    missingParents = omPathInfo.getMissingParents();
                    baseObjId = ozoneManager.getObjectIdFromTxId(trxnLogIndex);
                    inheritAcls = omPathInfo.getAcls();
                    dirKeyInfo = OMDirectoryCreateRequest.createDirectoryKeyInfoWithACL(keyName, keyArgs, baseObjId, OzoneAclUtil.fromProtobuf((List)keyArgs.getAclsList()), trxnLogIndex);
                    missingParentInfos = OMDirectoryCreateRequest.getAllParentInfo(ozoneManager, keyArgs, missingParents, inheritAcls, trxnLogIndex);
                    numMissingParents = missingParentInfos.size();
                    OMFileRequest.addKeyTableCacheEntries(omMetadataManager, volumeName, bucketName, (Optional<OmKeyInfo>)Optional.of((Object)dirKeyInfo), (Optional<List<OmKeyInfo>>)Optional.of(missingParentInfos), trxnLogIndex);
                    result = Result.SUCCESS;
                    omClientResponse = new OMDirectoryCreateResponse(omResponse.build(), dirKeyInfo, missingParentInfos, result);
                    break block10;
                }
                result = Result.DIRECTORY_ALREADY_EXISTS;
                omResponse.setStatus(OzoneManagerProtocolProtos.Status.DIRECTORY_ALREADY_EXISTS);
                omClientResponse = new OMDirectoryCreateResponse(omResponse.build(), result);
            }
            catch (IOException ex) {
                try {
                    exception = ex;
                    omClientResponse = new OMDirectoryCreateResponse(this.createErrorOMResponse(omResponse, exception), result);
                }
                catch (Throwable var30_29) {
                    this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
                    if (acquiredLock) {
                        omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                    }
                    throw var30_29;
                }
                this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
                if (acquiredLock) {
                    omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                } else {
                    ** GOTO lbl68
                }
            }
        }
        this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
        if (acquiredLock) {
            omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        }
        this.auditLog(auditLogger, this.buildAuditMessage((AuditAction)OMAction.CREATE_DIRECTORY, auditMap, exception, userInfo));
        this.logResult(createDirectoryRequest, keyArgs, omMetrics, result, exception, numMissingParents);
        return omClientResponse;
    }

    public static List<OmKeyInfo> getAllParentInfo(OzoneManager ozoneManager, OzoneManagerProtocolProtos.KeyArgs keyArgs, List<String> missingParents, List<OzoneAcl> inheritAcls, long trxnLogIndex) throws IOException {
        OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
        ArrayList<OmKeyInfo> missingParentInfos = new ArrayList<OmKeyInfo>();
        long baseObjId = ozoneManager.getObjectIdFromTxId(trxnLogIndex);
        long maxObjId = baseObjId + 255L;
        long objectCount = 1L;
        String volumeName = keyArgs.getVolumeName();
        String bucketName = keyArgs.getBucketName();
        String keyName = keyArgs.getKeyName();
        for (String missingKey : missingParents) {
            long nextObjId = baseObjId + objectCount;
            if (nextObjId > maxObjId) {
                throw new OMException("Too many directories in path. Exceeds limit of 255. Unable to create directory: " + keyName + " in volume/bucket: " + volumeName + "/" + bucketName, OMException.ResultCodes.INVALID_KEY_NAME);
            }
            LOG.debug("missing parent {} getting added to KeyTable", (Object)missingKey);
            OmKeyInfo parentKeyInfo = OMDirectoryCreateRequest.createDirectoryKeyInfoWithACL(missingKey, keyArgs, nextObjId, inheritAcls, trxnLogIndex);
            ++objectCount;
            missingParentInfos.add(parentKeyInfo);
            omMetadataManager.getKeyTable().addCacheEntry(new CacheKey((Object)omMetadataManager.getOzoneKey(volumeName, bucketName, parentKeyInfo.getKeyName())), new CacheValue(Optional.of((Object)parentKeyInfo), trxnLogIndex));
        }
        return missingParentInfos;
    }

    private void logResult(OzoneManagerProtocolProtos.CreateDirectoryRequest createDirectoryRequest, OzoneManagerProtocolProtos.KeyArgs keyArgs, OMMetrics omMetrics, Result result, IOException exception, int numMissingParents) {
        String volumeName = keyArgs.getVolumeName();
        String bucketName = keyArgs.getBucketName();
        String keyName = keyArgs.getKeyName();
        switch (result) {
            case SUCCESS: {
                omMetrics.incNumKeys(numMissingParents + 1);
                if (!LOG.isDebugEnabled()) break;
                LOG.debug("Directory created. Volume:{}, Bucket:{}, Key:{}", new Object[]{volumeName, bucketName, keyName});
                break;
            }
            case DIRECTORY_ALREADY_EXISTS: {
                if (!LOG.isDebugEnabled()) break;
                LOG.debug("Directory already exists. Volume:{}, Bucket:{}, Key{}", new Object[]{volumeName, bucketName, keyName, exception});
                break;
            }
            case FAILURE: {
                omMetrics.incNumCreateDirectoryFails();
                LOG.error("Directory creation failed. Volume:{}, Bucket:{}, Key{}. Exception:{}", new Object[]{volumeName, bucketName, keyName, exception});
                break;
            }
            default: {
                LOG.error("Unrecognized Result for OMDirectoryCreateRequest: {}", (Object)createDirectoryRequest);
            }
        }
    }

    public static OmKeyInfo createDirectoryKeyInfoWithACL(String keyName, OzoneManagerProtocolProtos.KeyArgs keyArgs, long objectId, List<OzoneAcl> inheritAcls, long transactionIndex) {
        return OMDirectoryCreateRequest.dirKeyInfoBuilderNoACL(keyName, keyArgs, objectId).setAcls(inheritAcls).setUpdateID(transactionIndex).build();
    }

    private static OmKeyInfo.Builder dirKeyInfoBuilderNoACL(String keyName, OzoneManagerProtocolProtos.KeyArgs keyArgs, long objectId) {
        String dirName = OzoneFSUtils.addTrailingSlashIfNeeded((String)keyName);
        return new OmKeyInfo.Builder().setVolumeName(keyArgs.getVolumeName()).setBucketName(keyArgs.getBucketName()).setKeyName(dirName).setOmKeyLocationInfos(Collections.singletonList(new OmKeyLocationInfoGroup(0L, new ArrayList()))).setCreationTime(keyArgs.getModificationTime()).setModificationTime(keyArgs.getModificationTime()).setDataSize(0L).setReplicationType(HddsProtos.ReplicationType.RATIS).setReplicationFactor(HddsProtos.ReplicationFactor.ONE).setObjectID(objectId).setUpdateID(objectId);
    }

    public static enum Result {
        SUCCESS,
        DIRECTORY_ALREADY_EXISTS,
        FAILURE;

    }
}

