/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.key;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.ResolvedBucket;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerDoubleBufferHelper;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeyRequest;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.key.OMTrashRecoverResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMTrashRecoverRequest
extends OMKeyRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMTrashRecoverRequest.class);

    public OMTrashRecoverRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) {
        OzoneManagerProtocolProtos.RecoverTrashRequest recoverTrashRequest = this.getOmRequest().getRecoverTrashRequest();
        Preconditions.checkNotNull((Object)recoverTrashRequest);
        return this.getOmRequest().toBuilder().build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long transactionLogIndex, OzoneManagerDoubleBufferHelper ozoneManagerDoubleBufferHelper) {
        OzoneManagerProtocolProtos.RecoverTrashRequest recoverTrashRequest = this.getOmRequest().getRecoverTrashRequest();
        Preconditions.checkNotNull((Object)recoverTrashRequest);
        String volumeName = recoverTrashRequest.getVolumeName();
        String bucketName = recoverTrashRequest.getBucketName();
        String keyName = recoverTrashRequest.getKeyName();
        String destinationBucket = recoverTrashRequest.getDestinationBucket();
        OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OzoneManagerProtocolProtos.OMResponse.newBuilder().setCmdType(OzoneManagerProtocolProtos.Type.RecoverTrash).setStatus(OzoneManagerProtocolProtos.Status.OK).setSuccess(true);
        OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
        boolean acquireLock = false;
        OMClientResponse omClientResponse = null;
        try {
            ResolvedBucket bucket = ozoneManager.resolveBucketLink((Pair<String, String>)Pair.of((Object)volumeName, (Object)destinationBucket), (OMClientRequest)this);
            volumeName = bucket.realVolume();
            destinationBucket = bucket.realBucket();
            this.checkBucketAcls(ozoneManager, volumeName, destinationBucket, keyName, IAccessAuthorizer.ACLType.WRITE);
            acquireLock = omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, destinationBucket});
            this.validateBucketAndVolume(omMetadataManager, volumeName, bucketName);
            this.validateBucketAndVolume(omMetadataManager, volumeName, destinationBucket);
            omClientResponse = null;
            if (omClientResponse != null) {
                omClientResponse.setFlushFuture(ozoneManagerDoubleBufferHelper.add(omClientResponse, transactionLogIndex));
            }
            if (!acquireLock) return omClientResponse;
        }
        catch (IOException ex) {
            try {
                LOG.error("Fail for recovering trash.", (Throwable)ex);
                omClientResponse = new OMTrashRecoverResponse(null, this.createErrorOMResponse(omResponse, ex));
                if (omClientResponse != null) {
                    omClientResponse.setFlushFuture(ozoneManagerDoubleBufferHelper.add(omClientResponse, transactionLogIndex));
                }
                if (!acquireLock) return omClientResponse;
            }
            catch (Throwable throwable) {
                if (omClientResponse != null) {
                    omClientResponse.setFlushFuture(ozoneManagerDoubleBufferHelper.add(omClientResponse, transactionLogIndex));
                }
                if (!acquireLock) throw throwable;
                omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, destinationBucket});
                throw throwable;
            }
            omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, destinationBucket});
            return omClientResponse;
        }
        omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, destinationBucket});
        return omClientResponse;
    }
}

