/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.s3.multipart;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.UUID;
import org.apache.hadoop.hdds.utils.UniqueId;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfoGroup;
import org.apache.hadoop.ozone.om.helpers.OmMultipartKeyInfo;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerDoubleBufferHelper;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeyRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.s3.multipart.S3InitiateMultipartUploadResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.protocolPB.OMPBHelper;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3InitiateMultipartUploadRequest
extends OMKeyRequest {
    private static final Logger LOG = LoggerFactory.getLogger(S3InitiateMultipartUploadRequest.class);

    public S3InitiateMultipartUploadRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        OzoneManagerProtocolProtos.MultipartInfoInitiateRequest multipartInfoInitiateRequest = this.getOmRequest().getInitiateMultiPartUploadRequest();
        Preconditions.checkNotNull((Object)multipartInfoInitiateRequest);
        OzoneManagerProtocolProtos.KeyArgs keyArgs = multipartInfoInitiateRequest.getKeyArgs();
        OzoneManagerProtocolProtos.KeyArgs.Builder newKeyArgs = keyArgs.toBuilder().setMultipartUploadID(UUID.randomUUID().toString() + "-" + UniqueId.next()).setModificationTime(Time.now()).setKeyName(S3InitiateMultipartUploadRequest.validateAndNormalizeKey(ozoneManager.getEnableFileSystemPaths(), keyArgs.getKeyName()));
        this.generateRequiredEncryptionInfo(keyArgs, newKeyArgs, ozoneManager);
        return this.getOmRequest().toBuilder().setUserInfo(this.getUserInfo()).setInitiateMultiPartUploadRequest(multipartInfoInitiateRequest.toBuilder().setKeyArgs(newKeyArgs)).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long transactionLogIndex, OzoneManagerDoubleBufferHelper ozoneManagerDoubleBufferHelper) {
        multipartInfoInitiateRequest = this.getOmRequest().getInitiateMultiPartUploadRequest();
        keyArgs = multipartInfoInitiateRequest.getKeyArgs();
        Preconditions.checkNotNull((Object)keyArgs.getMultipartUploadID());
        auditMap = this.buildKeyArgsAuditMap(keyArgs);
        volumeName = keyArgs.getVolumeName();
        bucketName = keyArgs.getBucketName();
        requestedVolume = volumeName;
        requestedBucket = bucketName;
        keyName = keyArgs.getKeyName();
        omMetadataManager = ozoneManager.getMetadataManager();
        ozoneManager.getMetrics().incNumInitiateMultipartUploads();
        acquiredBucketLock = false;
        exception = null;
        multipartKeyInfo = null;
        omKeyInfo = null;
        result = null;
        objectID = ozoneManager.getObjectIdFromTxId(transactionLogIndex);
        omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
        omClientResponse = null;
        try {
            keyArgs = this.resolveBucketLink(ozoneManager, keyArgs, auditMap);
            volumeName = keyArgs.getVolumeName();
            bucketName = keyArgs.getBucketName();
            this.checkKeyAcls(ozoneManager, volumeName, bucketName, keyName, IAccessAuthorizer.ACLType.CREATE, OzoneObj.ResourceType.KEY);
            acquiredBucketLock = omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            this.validateBucketAndVolume(omMetadataManager, volumeName, bucketName);
            multipartKey = omMetadataManager.getMultipartKey(volumeName, bucketName, keyName, keyArgs.getMultipartUploadID());
            multipartKeyInfo = new OmMultipartKeyInfo.Builder().setUploadID(keyArgs.getMultipartUploadID()).setCreationTime(keyArgs.getModificationTime()).setReplicationType(keyArgs.getType()).setReplicationFactor(keyArgs.getFactor()).setObjectID(objectID).setUpdateID(transactionLogIndex).build();
            bucketInfo = (OmBucketInfo)omMetadataManager.getBucketTable().get((Object)omMetadataManager.getBucketKey(volumeName, bucketName));
            omKeyInfo = new OmKeyInfo.Builder().setVolumeName(volumeName).setBucketName(bucketName).setKeyName(keyArgs.getKeyName()).setCreationTime(keyArgs.getModificationTime()).setModificationTime(keyArgs.getModificationTime()).setReplicationType(keyArgs.getType()).setReplicationFactor(keyArgs.getFactor()).setOmKeyLocationInfos(Collections.singletonList(new OmKeyLocationInfoGroup(0L, new ArrayList<E>()))).setAcls(this.getAclsForKey(keyArgs, bucketInfo, ozoneManager.getPrefixManager())).setObjectID(objectID).setUpdateID(transactionLogIndex).setFileEncryptionInfo(keyArgs.hasFileEncryptionInfo() != false ? OMPBHelper.convert((OzoneManagerProtocolProtos.FileEncryptionInfoProto)keyArgs.getFileEncryptionInfo()) : null).build();
            omMetadataManager.getOpenKeyTable().addCacheEntry(new CacheKey((Object)multipartKey), new CacheValue(Optional.of((Object)omKeyInfo), transactionLogIndex));
            omMetadataManager.getMultipartInfoTable().addCacheEntry(new CacheKey((Object)multipartKey), new CacheValue(Optional.of((Object)multipartKeyInfo), transactionLogIndex));
            omClientResponse = new S3InitiateMultipartUploadResponse(omResponse.setInitiateMultiPartUploadResponse(OzoneManagerProtocolProtos.MultipartInfoInitiateResponse.newBuilder().setVolumeName(requestedVolume).setBucketName(requestedBucket).setKeyName(keyName).setMultipartUploadID(keyArgs.getMultipartUploadID())).build(), multipartKeyInfo, omKeyInfo);
            result = OMClientRequest.Result.SUCCESS;
        }
        catch (IOException ex) {
            try {
                result = OMClientRequest.Result.FAILURE;
                exception = ex;
                omClientResponse = new S3InitiateMultipartUploadResponse(this.createErrorOMResponse(omResponse, exception));
            }
            catch (Throwable var25_24) {
                this.addResponseToDoubleBuffer(transactionLogIndex, omClientResponse, ozoneManagerDoubleBufferHelper);
                if (acquiredBucketLock) {
                    omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                }
                throw var25_24;
            }
            this.addResponseToDoubleBuffer(transactionLogIndex, omClientResponse, ozoneManagerDoubleBufferHelper);
            if (acquiredBucketLock) {
                omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            } else {
                ** GOTO lbl54
            }
        }
        this.addResponseToDoubleBuffer(transactionLogIndex, omClientResponse, ozoneManagerDoubleBufferHelper);
        if (acquiredBucketLock) {
            omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        }
        this.auditLog(ozoneManager.getAuditLogger(), this.buildAuditMessage((AuditAction)OMAction.INITIATE_MULTIPART_UPLOAD, auditMap, exception, this.getOmRequest().getUserInfo()));
        switch (1.$SwitchMap$org$apache$hadoop$ozone$om$request$OMClientRequest$Result[result.ordinal()]) {
            case 1: {
                S3InitiateMultipartUploadRequest.LOG.debug("S3 InitiateMultipart Upload request for Key {} in Volume/Bucket {}/{} is successfully completed", new Object[]{keyName, volumeName, bucketName});
                break;
            }
            case 2: {
                ozoneManager.getMetrics().incNumInitiateMultipartUploadFails();
                S3InitiateMultipartUploadRequest.LOG.error("S3 InitiateMultipart Upload request for Key {} in Volume/Bucket {}/{} is failed", new Object[]{keyName, volumeName, bucketName, exception});
                break;
            }
            default: {
                S3InitiateMultipartUploadRequest.LOG.error("Unrecognized Result for S3InitiateMultipartUploadRequest: {}", (Object)multipartInfoInitiateRequest);
            }
        }
        return omClientResponse;
    }
}

