/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.volume;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerDoubleBufferHelper;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.request.volume.OMVolumeRequest;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.volume.OMVolumeSetQuotaResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMVolumeSetQuotaRequest
extends OMVolumeRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMVolumeSetQuotaRequest.class);

    public OMVolumeSetQuotaRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        long modificationTime = Time.now();
        OzoneManagerProtocolProtos.SetVolumePropertyRequest.Builder setPropertyRequestBuilde = this.getOmRequest().getSetVolumePropertyRequest().toBuilder().setModificationTime(modificationTime);
        return this.getOmRequest().toBuilder().setSetVolumePropertyRequest(setPropertyRequestBuilde).setUserInfo(this.getUserInfo()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long transactionLogIndex, OzoneManagerDoubleBufferHelper ozoneManagerDoubleBufferHelper) {
        setVolumePropertyRequest = this.getOmRequest().getSetVolumePropertyRequest();
        Preconditions.checkNotNull((Object)setVolumePropertyRequest);
        omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
        if (!setVolumePropertyRequest.hasQuotaInBytes()) {
            omResponse.setStatus(OzoneManagerProtocolProtos.Status.INVALID_REQUEST).setSuccess(false);
            return new OMVolumeSetQuotaResponse(omResponse.build());
        }
        volume = setVolumePropertyRequest.getVolumeName();
        omMetrics = ozoneManager.getMetrics();
        omMetrics.incNumVolumeUpdates();
        auditLogger = ozoneManager.getAuditLogger();
        userInfo = this.getOmRequest().getUserInfo();
        auditMap = this.buildVolumeAuditMap(volume);
        auditMap.put("quotaInBytes", String.valueOf(setVolumePropertyRequest.getQuotaInBytes()));
        omMetadataManager = ozoneManager.getMetadataManager();
        exception = null;
        acquireVolumeLock = false;
        omClientResponse = null;
        try {
            if (ozoneManager.getAclsEnabled()) {
                this.checkAcls(ozoneManager, OzoneObj.ResourceType.VOLUME, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.WRITE, volume, null, null);
            }
            acquireVolumeLock = omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
            omVolumeArgs = this.getVolumeInfo(omMetadataManager, volume);
            if (this.checkQuotaBytesValid(omMetadataManager, setVolumePropertyRequest.getQuotaInBytes(), volume)) {
                omVolumeArgs.setQuotaInBytes(setVolumePropertyRequest.getQuotaInBytes());
            } else {
                omVolumeArgs.setQuotaInBytes(omVolumeArgs.getQuotaInBytes());
            }
            if (this.checkQuotaNamespaceValid(setVolumePropertyRequest.getQuotaInNamespace())) {
                omVolumeArgs.setQuotaInNamespace(setVolumePropertyRequest.getQuotaInNamespace());
            } else {
                omVolumeArgs.setQuotaInNamespace(omVolumeArgs.getQuotaInNamespace());
            }
            omVolumeArgs.setUpdateID(transactionLogIndex, ozoneManager.isRatisEnabled());
            omVolumeArgs.setModificationTime(setVolumePropertyRequest.getModificationTime());
            omMetadataManager.getVolumeTable().addCacheEntry(new CacheKey((Object)omMetadataManager.getVolumeKey(volume)), new CacheValue(Optional.of((Object)omVolumeArgs), transactionLogIndex));
            omResponse.setSetVolumePropertyResponse(OzoneManagerProtocolProtos.SetVolumePropertyResponse.newBuilder().build());
            omClientResponse = new OMVolumeSetQuotaResponse(omResponse.build(), omVolumeArgs);
        }
        catch (IOException ex) {
            try {
                exception = ex;
                omClientResponse = new OMVolumeSetQuotaResponse(this.createErrorOMResponse(omResponse, exception));
            }
            catch (Throwable var17_17) {
                this.addResponseToDoubleBuffer(transactionLogIndex, omClientResponse, ozoneManagerDoubleBufferHelper);
                if (acquireVolumeLock) {
                    omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
                }
                throw var17_17;
            }
            this.addResponseToDoubleBuffer(transactionLogIndex, omClientResponse, ozoneManagerDoubleBufferHelper);
            if (acquireVolumeLock) {
                omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
            } else {
                ** GOTO lbl57
            }
        }
        this.addResponseToDoubleBuffer(transactionLogIndex, omClientResponse, ozoneManagerDoubleBufferHelper);
        if (acquireVolumeLock) {
            omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
        }
        this.auditLog(auditLogger, this.buildAuditMessage((AuditAction)OMAction.SET_QUOTA, auditMap, exception, userInfo));
        if (exception == null) {
            OMVolumeSetQuotaRequest.LOG.debug("Changing volume quota is successfully completed for volume: {} quota:{}", (Object)volume, (Object)setVolumePropertyRequest.getQuotaInBytes());
        } else {
            omMetrics.incNumVolumeUpdateFails();
            OMVolumeSetQuotaRequest.LOG.error("Changing volume quota failed for volume:{} quota:{}", new Object[]{volume, setVolumePropertyRequest.getQuotaInBytes(), exception});
        }
        return omClientResponse;
    }

    public boolean checkQuotaBytesValid(OMMetadataManager metadataManager, long volumeQuotaInBytes, String volumeName) throws IOException {
        long totalBucketQuota = 0L;
        if (volumeQuotaInBytes < -1L || volumeQuotaInBytes == 0L) {
            return false;
        }
        List bucketList = metadataManager.listBuckets(volumeName, null, null, Integer.MAX_VALUE);
        for (OmBucketInfo bucketInfo : bucketList) {
            long nextQuotaInBytes = bucketInfo.getQuotaInBytes();
            if (nextQuotaInBytes <= -1L) continue;
            totalBucketQuota += nextQuotaInBytes;
        }
        if (volumeQuotaInBytes < totalBucketQuota && volumeQuotaInBytes != -1L) {
            throw new IllegalArgumentException("Total buckets quota in this volume should not be greater than volume quota : the total space quota is:" + totalBucketQuota + ". But the volume space quota is:" + volumeQuotaInBytes);
        }
        return true;
    }

    public boolean checkQuotaNamespaceValid(long quotaInNamespace) {
        return quotaInNamespace >= -1L && quotaInNamespace != 0L;
    }
}

