/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.file;

import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.request.file.OMDirectoryCreateRequest;
import org.apache.hadoop.ozone.om.response.CleanupTableInfo;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CleanupTableInfo(cleanupTables={"keyTable"})
public class OMDirectoryCreateResponse
extends OMClientResponse {
    public static final Logger LOG = LoggerFactory.getLogger(OMDirectoryCreateResponse.class);
    private OmKeyInfo dirKeyInfo;
    private List<OmKeyInfo> parentKeyInfos;
    private OMDirectoryCreateRequest.Result result;

    public OMDirectoryCreateResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, @Nonnull OmKeyInfo dirKeyInfo, @Nonnull List<OmKeyInfo> parentKeyInfos, @Nonnull OMDirectoryCreateRequest.Result result) {
        super(omResponse);
        this.dirKeyInfo = dirKeyInfo;
        this.parentKeyInfos = parentKeyInfos;
        this.result = result;
    }

    public OMDirectoryCreateResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, @Nonnull OMDirectoryCreateRequest.Result result) {
        super(omResponse);
        this.result = result;
    }

    @Override
    protected void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        if (OMDirectoryCreateRequest.Result.SUCCESS == this.result) {
            for (OmKeyInfo parentKeyInfo : this.parentKeyInfos) {
                String parentKey = omMetadataManager.getOzoneDirKey(parentKeyInfo.getVolumeName(), parentKeyInfo.getBucketName(), parentKeyInfo.getKeyName());
                LOG.debug("putWithBatch parent : key {} info : {}", (Object)parentKey, (Object)parentKeyInfo);
                omMetadataManager.getKeyTable().putWithBatch(batchOperation, (Object)parentKey, (Object)parentKeyInfo);
            }
            String dirKey = omMetadataManager.getOzoneKey(this.dirKeyInfo.getVolumeName(), this.dirKeyInfo.getBucketName(), this.dirKeyInfo.getKeyName());
            omMetadataManager.getKeyTable().putWithBatch(batchOperation, (Object)dirKey, (Object)this.dirKeyInfo);
        } else if (OMDirectoryCreateRequest.Result.DIRECTORY_ALREADY_EXISTS == this.result) {
            LOG.debug("Directory already exists. addToDBBatch is a no-op");
        }
    }
}

