/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.key;

import java.io.IOException;
import javax.annotation.Nonnull;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.response.CleanupTableInfo;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

@CleanupTableInfo(cleanupTables={"openKeyTable", "keyTable"})
public class OMKeyCommitResponse
extends OMClientResponse {
    private OmKeyInfo omKeyInfo;
    private String ozoneKeyName;
    private String openKeyName;
    private OmBucketInfo omBucketInfo;

    public OMKeyCommitResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, @Nonnull OmKeyInfo omKeyInfo, String ozoneKeyName, String openKeyName, @Nonnull OmBucketInfo omBucketInfo) {
        super(omResponse);
        this.omKeyInfo = omKeyInfo;
        this.ozoneKeyName = ozoneKeyName;
        this.openKeyName = openKeyName;
        this.omBucketInfo = omBucketInfo;
    }

    public OMKeyCommitResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse) {
        super(omResponse);
        this.checkStatusNotOK();
    }

    @Override
    public void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        omMetadataManager.getOpenKeyTable().deleteWithBatch(batchOperation, (Object)this.openKeyName);
        omMetadataManager.getKeyTable().putWithBatch(batchOperation, (Object)this.ozoneKeyName, (Object)this.omKeyInfo);
        omMetadataManager.getBucketTable().putWithBatch(batchOperation, (Object)omMetadataManager.getBucketKey(this.omBucketInfo.getVolumeName(), this.omBucketInfo.getBucketName()), (Object)this.omBucketInfo);
    }
}

